/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote.internal;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.CacheProvider;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import java.util.ArrayList;
import org.openrewrite.remote.internal.SharedObjectIdMap;

public final class CustomSerializationProvider
extends DefaultSerializerProvider {
    private final SharedObjectIdMap _seenObjectIds;

    public CustomSerializationProvider(SharedObjectIdMap sharedObjectIdMap) {
        this._seenObjectIds = sharedObjectIdMap;
    }

    public CustomSerializationProvider(CustomSerializationProvider src, SerializationConfig config, SerializerFactory jsf) {
        super((SerializerProvider)src, config, jsf);
        this._seenObjectIds = src._seenObjectIds;
    }

    public CustomSerializationProvider(CustomSerializationProvider src, CacheProvider cacheProvider) {
        super((DefaultSerializerProvider)src, cacheProvider);
        this._seenObjectIds = src._seenObjectIds;
    }

    public CustomSerializationProvider(CustomSerializationProvider src) {
        super((DefaultSerializerProvider)src);
        this._seenObjectIds = src._seenObjectIds;
    }

    public DefaultSerializerProvider copy() {
        return new CustomSerializationProvider(this);
    }

    public DefaultSerializerProvider createInstance(SerializationConfig config, SerializerFactory jsf) {
        return new CustomSerializationProvider(this, config, jsf);
    }

    public DefaultSerializerProvider withCaches(CacheProvider cacheProvider) {
        return new CustomSerializationProvider(this, cacheProvider);
    }

    public WritableObjectId findObjectId(Object forPojo, ObjectIdGenerator<?> generatorType) {
        WritableObjectId oid = this._seenObjectIds.get(forPojo);
        if (oid != null) {
            return oid;
        }
        ObjectIdGenerators.IntSequenceGenerator generator = null;
        if (this._objectIdGenerators == null) {
            this._objectIdGenerators = new ArrayList(8);
        } else {
            int len = this._objectIdGenerators.size();
            for (int i = 0; i < len; ++i) {
                ObjectIdGenerator gen = (ObjectIdGenerator)this._objectIdGenerators.get(i);
                if (!gen.canUseFor(generatorType)) continue;
                generator = gen;
                break;
            }
        }
        if (generator == null) {
            generator = new ObjectIdGenerators.IntSequenceGenerator(generatorType.getScope(), this._seenObjectIds.idToObject.size());
            this._objectIdGenerators.add(generator);
        }
        oid = new WritableObjectId(generator);
        this._seenObjectIds.put(forPojo, oid);
        return oid;
    }

    public void resetGenerators() {
        if (this._objectIdGenerators != null) {
            this._objectIdGenerators.clear();
        }
    }
}

