/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote.internal;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdResolver;
import com.fasterxml.jackson.annotation.SimpleObjectIdResolver;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public final class SharedObjectIdMap {
    private final ObjectIdResolver resolver = new SimpleObjectIdResolver();
    private static @Nullable Field writableObjectIdWritten;
    private static Field readableObjectItem;
    final transient IdentityHashMap<Object, WritableObjectId> objectToId = new IdentityHashMap();
    final transient LinkedHashMap<ObjectIdGenerator.IdKey, ReadableObjectId> idToObject = new LinkedHashMap();
    final transient IdentityHashMap<Object, WritableObjectId> newObjectToId = new IdentityHashMap();
    final transient LinkedHashMap<ObjectIdGenerator.IdKey, ReadableObjectId> newIdToObject = new LinkedHashMap();

    public WritableObjectId get(Object pojo) {
        WritableObjectId id = this.newObjectToId.get(pojo);
        return id != null ? id : this.objectToId.get(pojo);
    }

    public ReadableObjectId get(ObjectIdGenerator.IdKey key) {
        ReadableObjectId object = this.newIdToObject.get(key);
        return object != null ? object : this.idToObject.get(key);
    }

    public void put(Object pojo, WritableObjectId oid) {
        this.newObjectToId.put(pojo, oid);
    }

    public void put(ObjectIdGenerator.IdKey key, ReadableObjectId entry) {
        this.newIdToObject.put(key, entry);
    }

    public void merge() {
        WritableObjectId oid;
        this.objectToId.putAll(this.newObjectToId);
        for (Map.Entry<Object, WritableObjectId> entry : this.newObjectToId.entrySet()) {
            oid = entry.getValue();
            if (oid.id == null) continue;
            ObjectIdGenerator.IdKey key = oid.generator.key(oid.id);
            this.idToObject.put(key, this.getReadableObjectId(key, entry.getKey()));
        }
        this.newObjectToId.clear();
        this.idToObject.putAll(this.newIdToObject);
        for (Map.Entry<Object, WritableObjectId> entry : this.newIdToObject.entrySet()) {
            oid = (ReadableObjectId)entry.getValue();
            if (oid.getKey() == null) continue;
            this.objectToId.put(oid.resolve(), SharedObjectIdMap.getWritableObjectId((ObjectIdGenerator.IdKey)entry.getKey()));
        }
        this.newIdToObject.clear();
    }

    private ReadableObjectId getReadableObjectId(ObjectIdGenerator.IdKey key, final Object value) {
        ReadableObjectId readableObjectId = new ReadableObjectId(key){

            public Object resolve() {
                return value;
            }
        };
        readableObjectId.setResolver(this.resolver);
        Objects.requireNonNull(readableObjectItem).set(readableObjectId, value);
        return readableObjectId;
    }

    private static WritableObjectId getWritableObjectId(ObjectIdGenerator.IdKey key) {
        WritableObjectId writableObjectId = new WritableObjectId(null);
        writableObjectId.id = key.key;
        Objects.requireNonNull(writableObjectIdWritten).set(writableObjectId, true);
        return writableObjectId;
    }

    public void clear() {
        this.objectToId.clear();
        this.idToObject.clear();
        this.newObjectToId.clear();
        this.newIdToObject.clear();
    }

    static {
        try {
            writableObjectIdWritten = WritableObjectId.class.getDeclaredField("idWritten");
            writableObjectIdWritten.setAccessible(true);
            readableObjectItem = ReadableObjectId.class.getDeclaredField("_item");
            readableObjectItem.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }
}

