/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote.properties;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.UUID;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.remote.Receiver;
import org.openrewrite.remote.ReceiverContext;
import org.openrewrite.remote.ReceiverFactory;

public final class PropertiesReceiver
implements Receiver<Properties> {
    @Override
    public Properties receive(@Nullable Properties before, ReceiverContext ctx) {
        ReceiverContext forked = this.fork(ctx);
        return (Properties)forked.getVisitor().visit((Tree)before, (Object)forked);
    }

    @Override
    public ReceiverContext fork(ReceiverContext ctx) {
        return ctx.fork((TreeVisitor<?, ReceiverContext>)new Visitor(), new Factory());
    }

    @Generated
    public PropertiesReceiver() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof PropertiesReceiver;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "PropertiesReceiver()";
    }

    private static class Visitor
    extends PropertiesVisitor<ReceiverContext> {
        private Visitor() {
        }

        public @Nullable Properties visit(@Nullable Tree tree, ReceiverContext ctx) {
            Cursor cursor = new Cursor(this.getCursor(), (Object)tree);
            this.setCursor(cursor);
            tree = (Tree)ctx.receiveNode((Properties)tree, ctx::receiveTree);
            this.setCursor(cursor.getParent());
            return (Properties)tree;
        }

        public Properties.File visitFile(Properties.File file, ReceiverContext ctx) {
            file = file.withId(ctx.receiveNonNullValue(file.getId(), UUID.class));
            file = file.withPrefix(ctx.receiveNonNullValue(file.getPrefix(), String.class));
            file = file.withMarkers(ctx.receiveNonNullNode(file.getMarkers(), ctx::receiveMarkers));
            file = file.withSourcePath(ctx.receiveNonNullValue(file.getSourcePath(), Path.class));
            file = file.withContent(ctx.receiveNonNullNodes(file.getContent(), ctx::receiveTree));
            String charsetName = ctx.receiveValue((file = file.withEof(ctx.receiveNonNullValue(file.getEof(), String.class))).getCharset().name(), String.class);
            if (charsetName != null) {
                file = (Properties.File)file.withCharset(Charset.forName(charsetName));
            }
            file = file.withCharsetBomMarked(ctx.receiveNonNullValue(file.isCharsetBomMarked(), Boolean.TYPE).booleanValue());
            file = file.withFileAttributes(ctx.receiveValue(file.getFileAttributes(), FileAttributes.class));
            file = file.withChecksum(ctx.receiveValue(file.getChecksum(), Checksum.class));
            return file;
        }

        public Properties.Entry visitEntry(Properties.Entry entry, ReceiverContext ctx) {
            entry = entry.withId(ctx.receiveNonNullValue(entry.getId(), UUID.class));
            entry = entry.withPrefix(ctx.receiveNonNullValue(entry.getPrefix(), String.class));
            entry = entry.withMarkers(ctx.receiveNonNullNode(entry.getMarkers(), ctx::receiveMarkers));
            entry = entry.withKey(ctx.receiveNonNullValue(entry.getKey(), String.class));
            entry = entry.withBeforeEquals(ctx.receiveNonNullValue(entry.getBeforeEquals(), String.class));
            entry = entry.withDelimiter(ctx.receiveValue(entry.getDelimiter(), Properties.Entry.Delimiter.class));
            entry = entry.withValue(ctx.receiveNonNullValue(entry.getValue(), Properties.Value.class));
            return entry;
        }

        public Properties.Value visitValue(Properties.Value value, ReceiverContext ctx) {
            value = value.withId(ctx.receiveNonNullValue(value.getId(), UUID.class));
            value = value.withPrefix(ctx.receiveNonNullValue(value.getPrefix(), String.class));
            value = value.withMarkers(ctx.receiveNonNullNode(value.getMarkers(), ctx::receiveMarkers));
            value = value.withText(ctx.receiveNonNullValue(value.getText(), String.class));
            return value;
        }

        public Properties.Comment visitComment(Properties.Comment comment, ReceiverContext ctx) {
            comment = comment.withId(ctx.receiveNonNullValue(comment.getId(), UUID.class));
            comment = comment.withPrefix(ctx.receiveNonNullValue(comment.getPrefix(), String.class));
            comment = comment.withMarkers(ctx.receiveNonNullNode(comment.getMarkers(), ctx::receiveMarkers));
            comment = comment.withDelimiter(ctx.receiveNonNullValue(comment.getDelimiter(), Properties.Comment.Delimiter.class));
            comment = comment.withMessage(ctx.receiveNonNullValue(comment.getMessage(), String.class));
            return comment;
        }
    }

    private static class Factory
    implements ReceiverFactory {
        private Factory() {
        }

        @Override
        public <T> T create(Class<T> type, ReceiverContext ctx) {
            if (type == Properties.File.class) {
                return (T)new Properties.File(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, Path.class), ctx.receiveNonNullNodes(null, ctx::receiveTree), ctx.receiveNonNullValue(null, String.class), ctx.receiveValue(null, String.class), ctx.receiveNonNullValue(null, Boolean.TYPE).booleanValue(), ctx.receiveValue(null, FileAttributes.class), ctx.receiveValue(null, Checksum.class));
            }
            if (type == Properties.Entry.class) {
                return (T)new Properties.Entry(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveValue(null, Properties.Entry.Delimiter.class), ctx.receiveNonNullValue(null, Properties.Value.class));
            }
            if (type == Properties.Value.class) {
                return (T)new Properties.Value(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, String.class));
            }
            if (type == Properties.Comment.class) {
                return (T)new Properties.Comment(ctx.receiveNonNullValue(null, UUID.class), ctx.receiveNonNullValue(null, String.class), ctx.receiveNonNullNode(null, ctx::receiveMarkers), ctx.receiveNonNullValue(null, Properties.Comment.Delimiter.class), ctx.receiveNonNullValue(null, String.class));
            }
            throw new IllegalArgumentException("Unknown type: " + type);
        }
    }
}

