/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.Throwing;
import org.openrewrite.remote.RemoteUtils;
import org.openrewrite.remote.RemotingMessageType;
import org.openrewrite.remote.RemotingMessenger;
import org.openrewrite.remote.RemotingServerEngine;

public abstract class AbstractRemotingServerEngine
implements RemotingServerEngine {
    @Generated
    private static final Logger log = Logger.getLogger(AbstractRemotingServerEngine.class.getName());
    final InetSocketAddress socket;
    final Duration timeout;
    CBORFactory factory = new CBORFactory();
    boolean started;
    @Nullable Process process;
    final Set<Socket> activeSockets = new HashSet<Socket>();

    protected AbstractRemotingServerEngine(InetSocketAddress socket, Duration timeout) {
        this.socket = socket;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Socket openConnection() throws IOException {
        if (!this.started || this.process != null && !this.process.isAlive()) {
            throw new IllegalStateException("Cannot get new socket connection");
        }
        Socket s = new Socket(this.socket.getAddress(), this.socket.getPort());
        AbstractRemotingServerEngine abstractRemotingServerEngine = this;
        synchronized (abstractRemotingServerEngine) {
            this.activeSockets.add(s);
        }
        return s;
    }

    @Override
    public final void start() {
        if (this.started || this.hello()) {
            this.started = true;
            return;
        }
        try {
            ProcessBuilder processBuilder = this.configureProcess(new ProcessBuilder(new String[0]));
            if (System.getProperty("os.name").startsWith("Windows")) {
                processBuilder.redirectOutput(new File("NUL"));
                processBuilder.redirectError(new File("NUL"));
            } else {
                processBuilder.redirectOutput(new File("/dev/null"));
                processBuilder.redirectError(new File("/dev/null"));
            }
            Process process = processBuilder.start();
            log.fine("Starting Rewrite Remoting Server at " + process);
            if (!process.isAlive()) {
                throw new IllegalStateException("Rewrite Server has not started correctly" + process.exitValue());
            }
            this.process = process;
            RemoteUtils.cleaner.put(this, process::destroy);
            long timeout = System.currentTimeMillis() + this.timeout.toMillis();
            int step = 50;
            int delay = 10;
            while (!(this.started = this.hello())) {
                if (!process.isAlive()) {
                    throw new IllegalStateException("Rewrite Server has not started correctly" + process.exitValue());
                }
                if (System.currentTimeMillis() > timeout) {
                    this.terminateServer();
                    throw new IllegalStateException("Rewrite Server has not started correctly");
                }
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    this.terminateServer();
                    throw new RuntimeException(e);
                }
                delay += step;
            }
        }
        catch (IOException e) {
            Throwing.sneakyThrow((Throwable)e);
        }
    }

    protected abstract ProcessBuilder configureProcess(ProcessBuilder var1);

    @Override
    public final boolean isAlive() {
        return this.process != null && this.process.isAlive() || this.hello();
    }

    @Override
    public final void close() {
        this.terminateServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateServer() {
        if (this.process != null) {
            this.process.destroy();
            if (!this.process.waitFor(this.timeout.toMillis(), TimeUnit.MILLISECONDS) && !this.process.destroyForcibly().waitFor(this.timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException("Failed to forcibly terminate Rewrite server");
            }
            this.process = null;
            this.started = false;
        }
        AbstractRemotingServerEngine abstractRemotingServerEngine = this;
        synchronized (abstractRemotingServerEngine) {
            for (Socket activeSocket : this.activeSockets) {
                try {
                    activeSocket.close();
                }
                catch (Exception exception) {}
            }
            this.activeSockets.clear();
        }
    }

    private boolean hello() {
        boolean bl;
        Socket s = new Socket(this.socket.getAddress(), this.socket.getPort());
        try {
            CBORGenerator generator = this.factory.createGenerator(s.getOutputStream());
            generator.writeNumber(RemotingMessageType.Request.ordinal());
            generator.writeString("hello");
            RemotingMessenger.sendMessageEnd(generator);
            InputStream inputStream = s.getInputStream();
            CBORParser parser = this.factory.createParser(inputStream);
            JsonToken ignore = parser.nextToken();
            ignore = parser.nextToken();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    s.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        s.close();
        return bl;
    }
}

