/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Supplier;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.remote.DiffEvent;
import org.openrewrite.remote.EventType;
import org.openrewrite.remote.JsonReceiver;
import org.openrewrite.remote.OmniReceiver;
import org.openrewrite.remote.Receiver;
import org.openrewrite.remote.ReceiverFactory;
import org.openrewrite.remote.RemoteUtils;
import org.openrewrite.remote.RemotingContext;
import org.openrewrite.remote.SenderReceiverProvider;
import org.openrewrite.remote.TreeReceiver;

public final class ReceiverContext {
    static final SortedMap<Class<?>, Supplier<Receiver<?>>> REGISTRY = new TreeMap(new SenderReceiverProvider.TypeComparer());
    private final TreeReceiver receiver;
    private final RemotingContext context;
    private @Nullable TreeVisitor<?, ReceiverContext> visitor;
    private @Nullable ReceiverFactory factory;

    public ReceiverContext(TreeReceiver receiver, RemotingContext context) {
        this.receiver = receiver;
        this.context = context;
    }

    private ReceiverContext(TreeReceiver receiver, TreeVisitor<?, ReceiverContext> visitor, ReceiverFactory factory, RemotingContext context) {
        this.receiver = receiver;
        this.visitor = visitor;
        this.factory = factory;
        this.context = context;
    }

    public static <T extends Tree> T receiveTree(@Nullable T before, JsonReceiver jsonReceiver, RemotingContext context) {
        ReceiverContext ctx = new ReceiverContext(jsonReceiver, context);
        return ctx.receiveTree(before);
    }

    public <T extends Tree> T receiveTree(@Nullable T before) {
        try {
            Tree tree = new OmniReceiver().receive(before, this);
            return (T)tree;
        }
        finally {
            this.context.mergeNewObjectIds();
        }
    }

    public <T extends Tree> Receiver<T> newReceiver(Class<? extends T> clazz) {
        SenderReceiverProvider<T> compatibleProvider = this.context.getProvider(clazz);
        return compatibleProvider.newReceiver();
    }

    public ReceiverContext fork(TreeVisitor<?, ReceiverContext> visitor, ReceiverFactory factory) {
        return new ReceiverContext(this.receiver, visitor, factory, this.context);
    }

    public static <T> T create(@Nullable T ignore, @Nullable Class<T> type, ReceiverContext ctx) {
        return ctx.factory.create(Objects.requireNonNull(type), ctx);
    }

    public <T extends Tree> T receiveTree(@Nullable T before, @Nullable Class<? super T> type, ReceiverContext ctx) {
        return (T)(before != null ? before.accept(this.visitor, (Object)ctx) : (Tree)this.factory.create(type, ctx));
    }

    public <T extends Tree> @Nullable T polymorphicReceiveTree(@Nullable T before) {
        DiffEvent event = this.receiver.receiveNode();
        switch (event.getEventType()) {
            case Add: 
            case Update: {
                Class<?> treeType = event.getConcreteType();
                Receiver<?> treeReceiver = this.newReceiver(treeType != null ? treeType : before.getClass());
                ReceiverContext forked = treeReceiver.fork(this);
                return forked.receiveTree(event.getEventType() == EventType.Add ? null : (T)before, treeType, forked);
            }
            case Delete: {
                return null;
            }
        }
        return before;
    }

    public <T> @Nullable T receiveNode(@Nullable T before, DetailsReceiver<T> details) {
        DiffEvent event = this.receiver.receiveNode();
        if (event.getEventType() == EventType.Delete) {
            return null;
        }
        if (event.getEventType() != EventType.NoChange) {
            return details.receiveDetails(before, event.getConcreteType(), this);
        }
        return before;
    }

    public <T> T receiveNonNullNode(@Nullable T before, DetailsReceiver<T> details) {
        DiffEvent event = this.receiver.receiveNode();
        Object node = event.getEventType() == EventType.Delete ? null : (event.getEventType() != EventType.NoChange ? (Object)details.receiveDetails(before, event.getConcreteType(), this) : (Object)before);
        return Objects.requireNonNull(node);
    }

    public Markers receiveMarkers(@Nullable Markers before, @Nullable Class<Markers> ignore, ReceiverContext ctx) {
        UUID id = Objects.requireNonNull(this.receiveNonNullValue(before != null ? before.getId() : null, UUID.class));
        List<Marker> afterMarkers = Objects.requireNonNull(RemoteUtils.receiveValues(before != null ? before.getMarkers() : null, Marker.class, ctx));
        return before != null ? before.withId(id).withMarkers(afterMarkers) : new Markers(id, afterMarkers);
    }

    public <T> List<T> receiveNonNullNodes(@Nullable List<T> before, DetailsReceiver<T> details) {
        return Objects.requireNonNull(RemoteUtils.receiveNodes(before, details, this));
    }

    public <T> @Nullable List<T> receiveNodes(@Nullable List<T> before, DetailsReceiver<T> details) {
        return RemoteUtils.receiveNodes(before, details, this);
    }

    public <T> @Nullable List<T> receiveValues(@Nullable List<T> before, Class<T> type) {
        return RemoteUtils.receiveValues(before, type, this);
    }

    public <T> @Nullable T receiveValue(@Nullable T before, Class<? extends T> type) {
        DiffEvent event = this.receiver.receiveValue(type);
        switch (event.getEventType()) {
            case Add: 
            case Update: {
                return (T)event.getMsg();
            }
            case Delete: {
                return null;
            }
        }
        return before;
    }

    public <T> T receiveNonNullValue(@Nullable T before, Class<? extends T> type) {
        DiffEvent event = this.receiver.receiveValue(type);
        switch (event.getEventType()) {
            case Add: 
            case Update: {
                return (T)Objects.requireNonNull(event.getMsg());
            }
            case Delete: {
                return Objects.requireNonNull(null);
            }
        }
        return Objects.requireNonNull(before);
    }

    @Generated
    public TreeReceiver getReceiver() {
        return this.receiver;
    }

    @Generated
    public RemotingContext getContext() {
        return this.context;
    }

    @Generated
    public @Nullable TreeVisitor<?, ReceiverContext> getVisitor() {
        return this.visitor;
    }

    @Generated
    public @Nullable ReceiverFactory getFactory() {
        return this.factory;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReceiverContext)) {
            return false;
        }
        ReceiverContext other = (ReceiverContext)o;
        TreeReceiver this$receiver = this.getReceiver();
        TreeReceiver other$receiver = other.getReceiver();
        if (this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver)) {
            return false;
        }
        RemotingContext this$context = this.getContext();
        RemotingContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        TreeVisitor<?, ReceiverContext> this$visitor = this.getVisitor();
        TreeVisitor<?, ReceiverContext> other$visitor = other.getVisitor();
        if (this$visitor == null ? other$visitor != null : !this$visitor.equals(other$visitor)) {
            return false;
        }
        ReceiverFactory this$factory = this.getFactory();
        ReceiverFactory other$factory = other.getFactory();
        return !(this$factory == null ? other$factory != null : !this$factory.equals(other$factory));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TreeReceiver $receiver = this.getReceiver();
        result = result * 59 + ($receiver == null ? 43 : $receiver.hashCode());
        RemotingContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        TreeVisitor<?, ReceiverContext> $visitor = this.getVisitor();
        result = result * 59 + ($visitor == null ? 43 : $visitor.hashCode());
        ReceiverFactory $factory = this.getFactory();
        result = result * 59 + ($factory == null ? 43 : $factory.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReceiverContext(receiver=" + this.getReceiver() + ", context=" + this.getContext() + ", visitor=" + this.getVisitor() + ", factory=" + this.getFactory() + ")";
    }

    @FunctionalInterface
    public static interface DetailsReceiver<T> {
        public T receiveDetails(@Nullable T var1, @Nullable Class<T> var2, ReceiverContext var3);
    }
}

