/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.InputStream;
import java.io.OutputStream;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.remote.JsonReceiver;
import org.openrewrite.remote.JsonSender;
import org.openrewrite.remote.ReceiverContext;
import org.openrewrite.remote.SenderContext;
import org.openrewrite.remote.SenderReceiverProvider;
import org.openrewrite.remote.internal.CustomDeserializationContext;
import org.openrewrite.remote.internal.CustomSerializationProvider;
import org.openrewrite.remote.internal.PathModule;
import org.openrewrite.remote.internal.SharedObjectIdMap;

public final class RemotingContext {
    private final boolean debug;
    private final ClassLoader classLoader;
    private final SharedObjectIdMap sharedObjectIdMap = new SharedObjectIdMap();
    private @Nullable ObjectMapper mapper;

    public RemotingContext(ClassLoader classLoader, boolean debug) {
        this.classLoader = classLoader;
        this.debug = debug;
    }

    public ObjectMapper objectMapper() {
        if (this.mapper == null) {
            CBORFactory f = new CBORFactory();
            ObjectMapper m = new ObjectMapper((JsonFactory)f, (DefaultSerializerProvider)new CustomSerializationProvider(this.sharedObjectIdMap), (DefaultDeserializationContext)new CustomDeserializationContext(this.sharedObjectIdMap)).setConstructorDetector(ConstructorDetector.USE_PROPERTIES_BASED).registerModule((Module)new ParameterNamesModule()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new PathModule()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).setSerializationInclusion(JsonInclude.Include.NON_NULL);
            m.setTypeFactory(TypeFactory.defaultInstance().withClassLoader(this.classLoader));
            m.enable(SerializationFeature.WRITE_ENUMS_USING_INDEX);
            this.mapper = m.setVisibility(m.getSerializationConfig().getDefaultVisibilityChecker().withCreatorVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withFieldVisibility(JsonAutoDetect.Visibility.ANY));
        }
        return this.mapper;
    }

    public boolean debug() {
        return this.debug;
    }

    public <T extends Tree> SenderReceiverProvider<T> getProvider(Class<? extends T> clazz) {
        return SenderReceiverProvider.registry().findCompatibleProvider(clazz);
    }

    public JsonSender newSender(OutputStream out) {
        return new JsonSender(out, this);
    }

    public JsonSender newSender(JsonGenerator generator) {
        return new JsonSender(generator, this);
    }

    public SenderContext newSenderContext(OutputStream out) {
        return new SenderContext(this.newSender(out), this);
    }

    public SenderContext newSenderContext(JsonGenerator generator) {
        return new SenderContext(this.newSender(generator), this);
    }

    public JsonReceiver newReceiver(InputStream in) {
        return new JsonReceiver(in, this);
    }

    public JsonReceiver newReceiver(JsonParser parser) {
        return new JsonReceiver(parser, this);
    }

    public ReceiverContext newReceiverContext(CBORParser parser) {
        return new ReceiverContext(new JsonReceiver((JsonParser)parser, this), this);
    }

    public <T> Class<T> findClass(String className) throws ClassNotFoundException {
        return this.objectMapper().getTypeFactory().findClass(className);
    }

    void mergeNewObjectIds() {
        this.sharedObjectIdMap.merge();
        if (this.mapper != null) {
            ((CustomSerializationProvider)this.mapper.getSerializerProvider()).resetGenerators();
        }
    }

    public void reset() {
        this.sharedObjectIdMap.clear();
        if (this.mapper != null) {
            ((CustomSerializationProvider)this.mapper.getSerializerProvider()).resetGenerators();
        }
    }
}

