/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.remote.RemotingContext;
import org.openrewrite.remote.RemotingExecutionContextView;
import org.openrewrite.remote.RemotingMessenger;
import org.openrewrite.remote.RemotingServerEngine;
import org.openrewrite.text.PlainTextParser;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class RemotingInputParser
implements Parser {
    final RemotingServerEngine remotingServerEngine;

    public RemotingInputParser(RemotingServerEngine remotingServerEngine) {
        this.remotingServerEngine = remotingServerEngine;
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> inputs, @Nullable Path relativeTo, ExecutionContext ctx) {
        try {
            this.remotingServerEngine.start();
        }
        catch (Exception e) {
            return PlainTextParser.builder().build().parseInputs(inputs, relativeTo, ctx);
        }
        RemotingExecutionContextView view = RemotingExecutionContextView.view(ctx);
        RemotingContext remotingContext = view.getOrCreateRemotingContext();
        Socket activeSocket = view.getOrCreateSocket(this.remotingServerEngine);
        RemotingMessenger messenger = view.getOrCreateRemotingMessenger();
        ParsingExecutionContextView pctx = ParsingExecutionContextView.view((ExecutionContext)ctx);
        ParsingEventListener parsingListener = pctx.getParsingListener();
        return this.acceptedInputs(inputs).map(input -> {
            Path path = input.getRelativePath(relativeTo);
            parsingListener.startedParsing(input);
            try (EncodingDetectingInputStream is = input.getSource(ctx);){
                SourceFile parsed = Objects.requireNonNull(messenger.sendRequest(generator -> {
                    if (input.isSynthetic() || !Files.isRegularFile(input.getPath(), new LinkOption[0])) {
                        generator.writeString("parse-source");
                        generator.writeString(is.readFully());
                    } else {
                        generator.writeString("parse-file");
                        generator.writeString(input.getPath().toString());
                        generator.writeString(relativeTo.toString());
                    }
                }, parser -> RemotingMessenger.receiveTree(remotingContext, parser, null), activeSocket)).withSourcePath(path).withFileAttributes(FileAttributes.fromPath((Path)input.getPath())).withCharset(this.getCharset(ctx));
                if (parsed instanceof ParseError) {
                    ctx.getOnError().accept(new AssertionError(parsed));
                    SourceFile sourceFile2 = parsed;
                    return sourceFile2;
                }
                parsingListener.parsed(input, parsed);
                SourceFile sourceFile = this.requirePrintEqualsInput(parsed, (Parser.Input)input, relativeTo, ctx);
                return sourceFile;
            }
            catch (Throwable t) {
                ctx.getOnError().accept(t);
                return ParseError.build((Parser)this, (Parser.Input)input, (Path)relativeTo, (ExecutionContext)ctx, (Throwable)t);
            }
        });
    }

    public boolean accept(Path path) {
        return true;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("Source.file");
    }
}

