/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.Throwing;
import org.openrewrite.remote.CborMemoryBuffer;
import org.openrewrite.remote.ReceiverContext;
import org.openrewrite.remote.RemotingContext;
import org.openrewrite.remote.RemotingMessageType;

public class RemotingMessenger {
    @Generated
    private static final Logger log = Logger.getLogger(RemotingMessenger.class.getName());
    private static final int[] MESSAGE_END = new int[]{23};
    private static final byte[] BYTE_BUFFER = new byte[8192];
    private final CBORFactory factory;
    private @Nullable Socket socket;
    private @Nullable OutputStream outputStream;
    private @Nullable InputStream inputStream;
    private final Map<String, Supplier<RequestHandler<?>>> handlers;
    private final Function<RemotingMessenger, ? extends ExecutionContext> contextSupplier;

    public RemotingMessenger(CBORFactory factory, Map<String, Supplier<RequestHandler<?>>> handlers, Function<RemotingMessenger, ? extends ExecutionContext> contextSupplier) {
        this.factory = factory;
        this.handlers = new HashMap(handlers);
        this.contextSupplier = contextSupplier;
    }

    public static <T extends Tree> T receiveTree(RemotingContext context, CBORParser parser, @Nullable T before) throws IOException {
        parser.nextToken();
        byte[] treeData = parser.getBinaryValue();
        JsonParser nested = parser.getCodec().getFactory().createParser(treeData);
        ReceiverContext receiverContext = new ReceiverContext(context.newReceiver(nested), context);
        return receiverContext.receiveTree(before);
    }

    public static <T extends SourceFile> void sendTree(RemotingContext context, CBORGenerator generator, T after, @Nullable T before) throws IOException {
        try (CborMemoryBuffer out = new CborMemoryBuffer(generator);){
            JsonGenerator nested = generator.getCodec().getFactory().createGenerator((OutputStream)out);
            context.newSenderContext(nested).sendTree(after, before);
            nested.flush();
        }
    }

    private void connect(Socket socket) {
        block5: {
            if (socket == this.socket) break block5;
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.socket = socket;
            this.outputStream = socket.getOutputStream();
            this.inputStream = socket.getInputStream();
        }
    }

    public boolean processRequest(Socket socketChannel) {
        this.connect(socketChannel);
        try {
            return this.processRequest0();
        }
        catch (IOException ignore) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processRequest0() throws IOException {
        MessageBuffer request = this.readMessage(Objects.requireNonNull(this.inputStream));
        if (request == null) {
            return false;
        }
        CBORParser parser = request.createParser(this.factory);
        CBORGenerator generator = this.factory.createGenerator(this.outputStream);
        parser.nextToken();
        String command = parser.getValueAsString();
        try {
            if (command != null) {
                RequestHandler<Void> handler;
                log.info("Handling " + command);
                switch (command) {
                    case "hello": {
                        handler = this.helloHandler();
                        break;
                    }
                    default: {
                        handler = this.handlers.get(command).get();
                        if (handler != null) break;
                        throw new IllegalArgumentException("Unknown command: " + command);
                    }
                }
                this.process(handler, parser, generator);
            }
        }
        finally {
            RemotingMessenger.sendMessageEnd(generator);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void process(RequestHandler<T> handler, CBORParser parser, CBORGenerator generator) {
        try {
            try {
                ExecutionContext ctx = this.contextSupplier.apply(this);
                Object payload = handler.receiveRequest(parser, ctx);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                CBORGenerator nested = this.factory.createGenerator((OutputStream)out);
                nested.writeNumber(RemotingMessageType.Response.ordinal());
                nested.writeNumber(0);
                handler.sendResponse(payload, nested, ctx);
                nested.flush();
                byte[] bytes = out.toByteArray();
                generator.writeBytes(bytes, 0, bytes.length);
            }
            catch (RuntimeException e) {
                generator.writeNumber(RemotingMessageType.Response.ordinal());
                generator.writeNumber(1);
                generator.writeString(e.getMessage());
            }
            finally {
                RemotingMessenger.readMessageEnd(parser);
            }
        }
        catch (IOException e) {
            Throwing.sneakyThrow((Throwable)e);
        }
    }

    private RequestHandler<Void> helloHandler() {
        return RequestHandler.of((parser, ctx) -> null, (ignore, generator, ctx) -> {});
    }

    private MessageBuffer readMessage(InputStream inputStream) throws IOException {
        MessageBuffer message = new MessageBuffer();
        do {
            int bytesRead;
            if ((bytesRead = inputStream.read(BYTE_BUFFER)) == -1) {
                return message;
            }
            if (bytesRead == 0) break;
            message.write(BYTE_BUFFER, 0, bytesRead);
        } while (!message.terminated());
        return message;
    }

    public <T> @Nullable T sendRequest(RequestSender request, Socket socketChannel) {
        return this.sendRequest(request, null, socketChannel);
    }

    public <T> @Nullable T sendRequest(RequestSender request, @Nullable ResponseReceiver<T> response, Socket socketChannel) {
        this.connect(socketChannel);
        return this.sendRequest0(request, response);
    }

    private <T> @Nullable T sendRequest0(RequestSender request, @Nullable ResponseReceiver<T> response) {
        try {
            CBORGenerator generator = this.factory.createGenerator(this.outputStream);
            generator.writeNumber(RemotingMessageType.Request.ordinal());
            request.process(generator);
            RemotingMessenger.sendMessageEnd(generator);
            while (true) {
                int read;
                if ((read = this.inputStream.read()) == -1) {
                    throw new RuntimeException("Socket InputStream was closed unexpectedly");
                }
                if (RemotingMessageType.of(read) != RemotingMessageType.Request) break;
                this.processRequest(this.socket);
            }
            MessageBuffer requestBuffer = this.readMessage(Objects.requireNonNull(this.inputStream));
            CBORParser parser = requestBuffer.createParser(this.factory);
            parser.nextToken();
            if (parser.getIntValue() != 0) {
                parser.nextToken();
                throw new RuntimeException("Error returned from remote: " + parser.getText());
            }
            if (response != null) {
                return response.process(parser);
            }
        }
        catch (IOException e) {
            Throwing.sneakyThrow((Throwable)e);
        }
        return null;
    }

    public void sendReset(Socket socket) {
        this.sendRequest(generator -> generator.writeString("reset"), socket);
    }

    public static void sendMessageEnd(CBORGenerator generator) throws IOException {
        generator.writeArray(MESSAGE_END, 0, 1);
        generator.flush();
    }

    static void readMessageEnd(CBORParser parser) throws IOException {
        JsonToken token = parser.nextToken();
        assert (token == JsonToken.START_ARRAY) : "Expected start array";
        parser.nextToken();
        assert (parser.getIntValue() == 23) : "Expected end message value";
        token = parser.nextToken();
        assert (token == JsonToken.END_ARRAY) : "Expected end message array";
    }

    private static class MessageBuffer
    extends ByteArrayOutputStream {
        public MessageBuffer() {
            super(8192);
        }

        public boolean terminated() {
            return this.count >= 2 && this.buf[this.count - 2] == -127 && this.buf[this.count - 1] == 23;
        }

        public CBORParser createParser(CBORFactory factory) throws IOException {
            return factory.createParser(this.buf, 0, this.count);
        }
    }

    public static interface RequestHandler<T>
    extends RequestReceiver<T>,
    ResponseSender<T> {
        public static <T> RequestHandler<T> of(final RequestReceiver<T> request, final ResponseSender<T> response) {
            return new RequestHandler<T>(){

                @Override
                public @Nullable T receiveRequest(CBORParser parser, ExecutionContext ctx) throws IOException {
                    return request.receiveRequest(parser, ctx);
                }

                @Override
                public void sendResponse(@Nullable T payload, CBORGenerator generator, ExecutionContext ctx) throws IOException {
                    response.sendResponse(payload, generator, ctx);
                }
            };
        }
    }

    public static interface RequestReceiver<T> {
        public @Nullable T receiveRequest(CBORParser var1, ExecutionContext var2) throws IOException;
    }

    public static interface ResponseSender<T> {
        public void sendResponse(@Nullable T var1, CBORGenerator var2, ExecutionContext var3) throws IOException;
    }

    public static interface RequestSender {
        public void process(CBORGenerator var1) throws IOException;
    }

    public static interface ResponseReceiver<T> {
        public T process(CBORParser var1) throws IOException;
    }
}

