/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote.internal;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdResolver;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.cfg.CacheProvider;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.DeserializerCache;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.remote.internal.SharedObjectIdMap;

public final class CustomDeserializationContext
extends DefaultDeserializationContext {
    private final SharedObjectIdMap _objectIds;
    private @Nullable List<ObjectIdResolver> _objectIdResolvers;

    public CustomDeserializationContext(SharedObjectIdMap sharedObjectIdMap) {
        super((DeserializerFactory)BeanDeserializerFactory.instance, new DeserializerCache());
        this._objectIds = sharedObjectIdMap;
    }

    public CustomDeserializationContext(CustomDeserializationContext src, DeserializerFactory factory) {
        super((DefaultDeserializationContext)src, factory);
        this._objectIds = src._objectIds;
        this._objectIdResolvers = src._objectIdResolvers;
    }

    public CustomDeserializationContext(CustomDeserializationContext src, CacheProvider cacheProvider) {
        super((DefaultDeserializationContext)src, cacheProvider);
        this._objectIds = src._objectIds;
        this._objectIdResolvers = src._objectIdResolvers;
    }

    public CustomDeserializationContext(CustomDeserializationContext src, DeserializationConfig config, JsonParser p, InjectableValues values) {
        super((DefaultDeserializationContext)src, config, p, values);
        this._objectIds = src._objectIds;
        this._objectIdResolvers = src._objectIdResolvers;
    }

    public CustomDeserializationContext(CustomDeserializationContext src, DeserializationConfig config) {
        super((DefaultDeserializationContext)src, config);
        this._objectIds = src._objectIds;
        this._objectIdResolvers = src._objectIdResolvers;
    }

    public CustomDeserializationContext(CustomDeserializationContext src) {
        super((DefaultDeserializationContext)src);
        this._objectIds = src._objectIds;
        this._objectIdResolvers = src._objectIdResolvers;
    }

    public DefaultDeserializationContext copy() {
        return new CustomDeserializationContext(this);
    }

    public DefaultDeserializationContext with(DeserializerFactory factory) {
        return new CustomDeserializationContext(this, factory);
    }

    public DefaultDeserializationContext withCaches(CacheProvider cacheProvider) {
        return new CustomDeserializationContext(this, cacheProvider);
    }

    public DefaultDeserializationContext createInstance(DeserializationConfig config, JsonParser p, InjectableValues values) {
        return new CustomDeserializationContext(this, config, p, values);
    }

    public DefaultDeserializationContext createDummyInstance(DeserializationConfig config) {
        return new CustomDeserializationContext(this, config);
    }

    public @Nullable ReadableObjectId findObjectId(@Nullable Object id, ObjectIdGenerator<?> gen, ObjectIdResolver resolverType) {
        if (id == null) {
            return null;
        }
        ObjectIdGenerator.IdKey key = gen.key(id);
        ReadableObjectId entry = this._objectIds.get(key);
        if (entry != null) {
            return entry;
        }
        ObjectIdResolver resolver = null;
        if (this._objectIdResolvers == null) {
            this._objectIdResolvers = new ArrayList<ObjectIdResolver>(8);
        } else {
            for (ObjectIdResolver res : this._objectIdResolvers) {
                if (!res.canUseFor(resolverType)) continue;
                resolver = res;
                break;
            }
        }
        if (resolver == null) {
            resolver = resolverType.newForDeserialization((Object)this);
            this._objectIdResolvers.add(resolver);
        }
        entry = this.createReadableObjectId(key);
        entry.setResolver(resolver);
        this._objectIds.put(key, entry);
        return entry;
    }
}

