/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote.yaml;

import java.util.function.Function;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.remote.Sender;
import org.openrewrite.remote.SenderContext;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class YamlSender
implements Sender<Yaml> {
    @Override
    public void send(Yaml after, @Nullable Yaml before, SenderContext ctx) {
        Visitor visitor = new Visitor();
        visitor.visit((Tree)after, ctx.fork((TreeVisitor<?, SenderContext>)visitor, (Tree)before));
        ctx.flush();
    }

    @Generated
    public YamlSender() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof YamlSender;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "YamlSender()";
    }

    private static class Visitor
    extends YamlVisitor<SenderContext> {
        private Visitor() {
        }

        public @Nullable Yaml visit(@Nullable Tree tree, SenderContext ctx) {
            this.setCursor(new Cursor(this.getCursor(), (Object)tree));
            ctx.sendNode(tree, Function.identity(), ctx::sendTree);
            this.setCursor(this.getCursor().getParent());
            return (Yaml)tree;
        }

        public Yaml.Documents visitDocuments(Yaml.Documents documents, SenderContext ctx) {
            ctx.sendValue(documents, Yaml.Documents::getId);
            ctx.sendNode(documents, Yaml.Documents::getMarkers, ctx::sendMarkers);
            ctx.sendValue(documents, Yaml.Documents::getSourcePath);
            ctx.sendTypedValue(documents, Yaml.Documents::getFileAttributes);
            ctx.sendValue(documents, e -> e.getCharset() != null ? e.getCharset().name() : "UTF-8");
            ctx.sendValue(documents, Yaml.Documents::isCharsetBomMarked);
            ctx.sendTypedValue(documents, Yaml.Documents::getChecksum);
            ctx.sendNodes(documents, Yaml.Documents::getDocuments, ctx::sendTree, Tree::getId);
            return documents;
        }

        public Yaml.Document visitDocument(Yaml.Document document, SenderContext ctx) {
            ctx.sendValue(document, Yaml.Document::getId);
            ctx.sendValue(document, Yaml.Document::getPrefix);
            ctx.sendNode(document, Yaml.Document::getMarkers, ctx::sendMarkers);
            ctx.sendValue(document, Yaml.Document::isExplicit);
            ctx.sendNode(document, Yaml.Document::getBlock, ctx::sendTree);
            ctx.sendNode(document, Yaml.Document::getEnd, ctx::sendTree);
            return document;
        }

        public Yaml.Document.End visitDocumentEnd(Yaml.Document.End end, SenderContext ctx) {
            ctx.sendValue(end, Yaml.Document.End::getId);
            ctx.sendValue(end, Yaml.Document.End::getPrefix);
            ctx.sendNode(end, Yaml.Document.End::getMarkers, ctx::sendMarkers);
            ctx.sendValue(end, Yaml.Document.End::isExplicit);
            return end;
        }

        public Yaml.Scalar visitScalar(Yaml.Scalar scalar, SenderContext ctx) {
            ctx.sendValue(scalar, Yaml.Scalar::getId);
            ctx.sendValue(scalar, Yaml.Scalar::getPrefix);
            ctx.sendNode(scalar, Yaml.Scalar::getMarkers, ctx::sendMarkers);
            ctx.sendValue(scalar, Yaml.Scalar::getStyle);
            ctx.sendNode(scalar, Yaml.Scalar::getAnchor, ctx::sendTree);
            ctx.sendValue(scalar, Yaml.Scalar::getValue);
            return scalar;
        }

        public Yaml.Mapping visitMapping(Yaml.Mapping mapping, SenderContext ctx) {
            ctx.sendValue(mapping, Yaml.Mapping::getId);
            ctx.sendNode(mapping, Yaml.Mapping::getMarkers, ctx::sendMarkers);
            ctx.sendValue(mapping, Yaml.Mapping::getOpeningBracePrefix);
            ctx.sendNodes(mapping, Yaml.Mapping::getEntries, ctx::sendTree, Tree::getId);
            ctx.sendValue(mapping, Yaml.Mapping::getClosingBracePrefix);
            ctx.sendNode(mapping, Yaml.Mapping::getAnchor, ctx::sendTree);
            return mapping;
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, SenderContext ctx) {
            ctx.sendValue(entry, Yaml.Mapping.Entry::getId);
            ctx.sendValue(entry, Yaml.Mapping.Entry::getPrefix);
            ctx.sendNode(entry, Yaml.Mapping.Entry::getMarkers, ctx::sendMarkers);
            ctx.sendNode(entry, Yaml.Mapping.Entry::getKey, ctx::sendTree);
            ctx.sendValue(entry, Yaml.Mapping.Entry::getBeforeMappingValueIndicator);
            ctx.sendNode(entry, Yaml.Mapping.Entry::getValue, ctx::sendTree);
            return entry;
        }

        public Yaml.Sequence visitSequence(Yaml.Sequence sequence, SenderContext ctx) {
            ctx.sendValue(sequence, Yaml.Sequence::getId);
            ctx.sendNode(sequence, Yaml.Sequence::getMarkers, ctx::sendMarkers);
            ctx.sendValue(sequence, Yaml.Sequence::getOpeningBracketPrefix);
            ctx.sendNodes(sequence, Yaml.Sequence::getEntries, ctx::sendTree, Tree::getId);
            ctx.sendValue(sequence, Yaml.Sequence::getClosingBracketPrefix);
            ctx.sendNode(sequence, Yaml.Sequence::getAnchor, ctx::sendTree);
            return sequence;
        }

        public Yaml.Sequence.Entry visitSequenceEntry(Yaml.Sequence.Entry entry, SenderContext ctx) {
            ctx.sendValue(entry, Yaml.Sequence.Entry::getId);
            ctx.sendValue(entry, Yaml.Sequence.Entry::getPrefix);
            ctx.sendNode(entry, Yaml.Sequence.Entry::getMarkers, ctx::sendMarkers);
            ctx.sendNode(entry, Yaml.Sequence.Entry::getBlock, ctx::sendTree);
            ctx.sendValue(entry, Yaml.Sequence.Entry::isDash);
            ctx.sendValue(entry, Yaml.Sequence.Entry::getTrailingCommaPrefix);
            return entry;
        }

        public Yaml.Alias visitAlias(Yaml.Alias alias, SenderContext ctx) {
            ctx.sendValue(alias, Yaml.Alias::getId);
            ctx.sendValue(alias, Yaml.Alias::getPrefix);
            ctx.sendNode(alias, Yaml.Alias::getMarkers, ctx::sendMarkers);
            ctx.sendNode(alias, Yaml.Alias::getAnchor, ctx::sendTree);
            return alias;
        }

        public Yaml.Anchor visitAnchor(Yaml.Anchor anchor, SenderContext ctx) {
            ctx.sendValue(anchor, Yaml.Anchor::getId);
            ctx.sendValue(anchor, Yaml.Anchor::getPrefix);
            ctx.sendValue(anchor, Yaml.Anchor::getPostfix);
            ctx.sendNode(anchor, Yaml.Anchor::getMarkers, ctx::sendMarkers);
            ctx.sendValue(anchor, Yaml.Anchor::getKey);
            return anchor;
        }
    }
}

