/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.test;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.test.UncheckedSupplier;

public class MockHttpSender
implements HttpSender {
    final UncheckedSupplier<InputStream> is;
    int responseCode = 200;
    Map<String, List<String>> responseHeaders = Collections.emptyMap();

    public MockHttpSender(UncheckedSupplier<InputStream> is) {
        this.is = is;
    }

    public MockHttpSender(int responseCode) {
        this.is = null;
        this.responseCode = responseCode;
    }

    public MockHttpSender withResponseHeaders(Map<String, List<String>> headers) {
        this.responseHeaders = headers;
        return this;
    }

    public HttpSender.Response send(HttpSender.Request request) {
        if (this.responseCode != 200) {
            return new HttpSender.Response(this.responseCode, null, this.responseHeaders, () -> {});
        }
        return new HttpSender.Response(this.responseCode, this.is.get(), this.responseHeaders, () -> {});
    }
}

