/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.toml;

import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.toml.tree.Space;
import org.openrewrite.toml.tree.Toml;
import org.openrewrite.toml.tree.TomlRightPadded;
import org.openrewrite.toml.tree.TomlValue;

public class TomlVisitor<P>
extends TreeVisitor<Toml, P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof Toml.Document;
    }

    public String getLanguage() {
        return "toml";
    }

    public Toml visitArray(Toml.Array array, P p) {
        Toml.Array a = array;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), p));
        a = a.withMarkers(this.visitMarkers(a.getMarkers(), p));
        a = a.withValues(ListUtils.map(a.getValues(), v -> (TomlValue)this.visit((Tree)v, p)));
        return a;
    }

    public Toml visitDocument(Toml.Document document, P p) {
        Toml.Document d = document;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), p));
        d = d.withMarkers(this.visitMarkers(d.getMarkers(), p));
        d = d.withValues(ListUtils.map(d.getValues(), v -> (TomlValue)this.visit((Tree)v, p)));
        d = d.withEof(this.visitSpace(d.getEof(), p));
        return d;
    }

    public Toml visitEmpty(Toml.Empty empty, P p) {
        Toml.Empty e = empty;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), p));
        e = e.withMarkers(this.visitMarkers(e.getMarkers(), p));
        return e;
    }

    public Toml visitIdentifier(Toml.Identifier identifier, P p) {
        Toml.Identifier i = identifier;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), p));
        i = i.withMarkers(this.visitMarkers(i.getMarkers(), p));
        return i;
    }

    public Toml visitKeyValue(Toml.KeyValue keyValue, P p) {
        Toml.KeyValue kv = keyValue;
        kv = kv.withPrefix(this.visitSpace(kv.getPrefix(), p));
        kv = kv.withMarkers(this.visitMarkers(kv.getMarkers(), p));
        kv = kv.getPadding().withKey(this.visitRightPadded(kv.getPadding().getKey(), p));
        kv = kv.withValue((Toml)this.visit(kv.getValue(), p));
        return kv;
    }

    public Toml visitLiteral(Toml.Literal literal, P p) {
        Toml.Literal l = literal;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), p));
        l = l.withMarkers(this.visitMarkers(l.getMarkers(), p));
        return l;
    }

    public Space visitSpace(Space space, P p) {
        return space;
    }

    public Toml visitTable(Toml.Table table, P p) {
        Toml.Table t = table;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), p));
        t = t.withMarkers(this.visitMarkers(t.getMarkers(), p));
        t = t.withValues(ListUtils.map(t.getValues(), v -> (Toml)this.visit((Tree)v, p)));
        return t;
    }

    public <T> TomlRightPadded<T> visitRightPadded(@Nullable TomlRightPadded<T> right, P p) {
        if (right == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), right));
        Object t = right.getElement();
        if (t instanceof Toml) {
            t = this.visitAndCast((Toml)right.getElement(), p);
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            return null;
        }
        Space after = this.visitSpace(right.getAfter(), p);
        return after == right.getAfter() && t == right.getElement() ? right : new TomlRightPadded<T>(t, after, right.getMarkers());
    }
}

