/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.toml;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.toml.TomlParsingException;
import org.openrewrite.toml.internal.TomlParserVisitor;
import org.openrewrite.toml.internal.grammar.TomlLexer;
import org.openrewrite.toml.tree.Toml;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class TomlParser
implements Parser {
    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingEventListener parsingListener = ParsingExecutionContextView.view((ExecutionContext)ctx).getParsingListener();
        return this.acceptedInputs(sourceFiles).map(input -> {
            SourceFile sourceFile;
            block8: {
                parsingListener.startedParsing(input);
                EncodingDetectingInputStream sourceStream = input.getSource(ctx);
                try {
                    TomlLexer lexer = new TomlLexer(CharStreams.fromStream((InputStream)sourceStream));
                    lexer.removeErrorListeners();
                    lexer.addErrorListener((ANTLRErrorListener)new ForwardingErrorListener(input.getPath(), ctx));
                    org.openrewrite.toml.internal.grammar.TomlParser parser = new org.openrewrite.toml.internal.grammar.TomlParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
                    parser.removeErrorListeners();
                    parser.addErrorListener((ANTLRErrorListener)new ForwardingErrorListener(input.getPath(), ctx));
                    Toml.Document document = new TomlParserVisitor(input.getRelativePath(relativeTo), input.getFileAttributes(), input.getSource(ctx)).visitDocument(parser.document());
                    parsingListener.parsed(input, (SourceFile)document);
                    sourceFile = this.requirePrintEqualsInput(document, (Parser.Input)input, relativeTo, ctx);
                    if (sourceStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (sourceStream != null) {
                            try {
                                sourceStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        ctx.getOnError().accept(t);
                        return ParseError.build((Parser)this, (Parser.Input)input, (Path)relativeTo, (ExecutionContext)ctx, (Throwable)t);
                    }
                }
                sourceStream.close();
            }
            return sourceFile;
        });
    }

    public Stream<SourceFile> parse(String ... sources) {
        return this.parse((ExecutionContext)new InMemoryExecutionContext(), sources);
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".toml") || path.endsWith(".xmake.cfg");
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.toml");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Parser.Builder {
        public Builder() {
            super(Toml.Document.class);
        }

        public TomlParser build() {
            return new TomlParser();
        }

        public String getDslName() {
            return "toml";
        }
    }

    private static class ForwardingErrorListener
    extends BaseErrorListener {
        private final Path sourcePath;
        private final ExecutionContext ctx;

        private ForwardingErrorListener(Path sourcePath, ExecutionContext ctx) {
            this.sourcePath = sourcePath;
            this.ctx = ctx;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.ctx.getOnError().accept(new TomlParsingException(this.sourcePath, String.format("Syntax error in %s at line %d:%d %s.", this.sourcePath, line, charPositionInLine, msg), e));
        }
    }
}

