/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.toml;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.toml.TomlIsoVisitor;
import org.openrewrite.toml.TomlPathMatcher;
import org.openrewrite.toml.tree.Toml;

public final class ChangeKey
extends Recipe {
    @Option(displayName="Old key path", description="A TOML path expression to locate a key.", example="package.name")
    private final String oldKeyPath;
    @Option(displayName="New key", description="The new name for the key.", example="project-name")
    private final String newKey;

    public String getDisplayName() {
        return "Change TOML key";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s` to `%s`", this.oldKeyPath, this.newKey);
    }

    public String getDescription() {
        return "Change a TOML key, while leaving the value intact.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final TomlPathMatcher matcher = new TomlPathMatcher(this.oldKeyPath);
        return new TomlIsoVisitor<ExecutionContext>(){

            @Override
            public Toml.KeyValue visitKeyValue(Toml.KeyValue keyValue, ExecutionContext ctx) {
                Toml kv = super.visitKeyValue(keyValue, ctx);
                if (matcher.matches(this.getCursor()) && ((Toml.KeyValue)kv).getKey() instanceof Toml.Identifier) {
                    String newKeyName = ChangeKey.this.newKey;
                    if (newKeyName.startsWith("\"") && newKeyName.endsWith("\"") || newKeyName.startsWith("'") && newKeyName.endsWith("'")) {
                        newKeyName = newKeyName.substring(1, newKeyName.length() - 1);
                    }
                    String formattedKey = newKeyName.matches("^[A-Za-z0-9_-]+$") ? newKeyName : "\"" + newKeyName + "\"";
                    return ((Toml.KeyValue)kv).withKey(((Toml.Identifier)((Toml.KeyValue)kv).getKey()).withName(newKeyName).withSource(formattedKey));
                }
                return kv;
            }
        };
    }

    @Generated
    public ChangeKey(String oldKeyPath, String newKey) {
        this.oldKeyPath = oldKeyPath;
        this.newKey = newKey;
    }

    @Generated
    public String getOldKeyPath() {
        return this.oldKeyPath;
    }

    @Generated
    public String getNewKey() {
        return this.newKey;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeKey(oldKeyPath=" + this.getOldKeyPath() + ", newKey=" + this.getNewKey() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeKey)) {
            return false;
        }
        ChangeKey other = (ChangeKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldKeyPath = this.getOldKeyPath();
        String other$oldKeyPath = other.getOldKeyPath();
        if (this$oldKeyPath == null ? other$oldKeyPath != null : !this$oldKeyPath.equals(other$oldKeyPath)) {
            return false;
        }
        String this$newKey = this.getNewKey();
        String other$newKey = other.getNewKey();
        return !(this$newKey == null ? other$newKey != null : !this$newKey.equals(other$newKey));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldKeyPath = this.getOldKeyPath();
        result = result * 59 + ($oldKeyPath == null ? 43 : $oldKeyPath.hashCode());
        String $newKey = this.getNewKey();
        result = result * 59 + ($newKey == null ? 43 : $newKey.hashCode());
        return result;
    }
}

