/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.toml;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.toml.TomlVisitor;
import org.openrewrite.toml.tree.Toml;
import org.openrewrite.toml.tree.TomlKey;

public class SemanticallyEqual {
    private SemanticallyEqual() {
    }

    public static boolean areEqual(Toml first, Toml second) {
        SemanticallyEqualVisitor sme = new SemanticallyEqualVisitor();
        sme.visit(first, second);
        return sme.areEqual;
    }

    private static class SemanticallyEqualVisitor
    extends TomlVisitor<Toml> {
        boolean areEqual = true;

        private SemanticallyEqualVisitor() {
        }

        @Override
        public Toml visitDocument(Toml.Document document, Toml other) {
            if (document == other) {
                return null;
            }
            if (!(other instanceof Toml.Document)) {
                this.areEqual = false;
                return null;
            }
            Toml.Document otherDocument = (Toml.Document)other;
            this.visitList(document.getValues(), otherDocument.getValues());
            return null;
        }

        @Override
        public Toml visitTable(Toml.Table table, Toml other) {
            if (table == other) {
                return null;
            }
            if (!(other instanceof Toml.Table)) {
                this.areEqual = false;
                return null;
            }
            Toml.Table otherTable = (Toml.Table)other;
            if (!this.keyEquals(table.getName(), otherTable.getName())) {
                this.areEqual = false;
                return null;
            }
            this.visitList(table.getValues(), otherTable.getValues());
            return null;
        }

        @Override
        public Toml visitKeyValue(Toml.KeyValue keyValue, Toml other) {
            if (keyValue == other) {
                return null;
            }
            if (!(other instanceof Toml.KeyValue)) {
                this.areEqual = false;
                return null;
            }
            Toml.KeyValue otherKeyValue = (Toml.KeyValue)other;
            if (!this.keyEquals(keyValue.getKey(), otherKeyValue.getKey())) {
                this.areEqual = false;
                return null;
            }
            this.visit(keyValue.getValue(), otherKeyValue.getValue());
            return null;
        }

        @Override
        public Toml visitLiteral(Toml.Literal literal, Toml other) {
            if (literal == other) {
                return null;
            }
            if (!(other instanceof Toml.Literal)) {
                this.areEqual = false;
                return null;
            }
            Toml.Literal otherLiteral = (Toml.Literal)other;
            if (literal.getType() != otherLiteral.getType()) {
                this.areEqual = false;
                return null;
            }
            Object val1 = literal.getValue();
            Object val2 = otherLiteral.getValue();
            if (val1 == null && val2 == null) {
                return null;
            }
            if (val1 == null || val2 == null) {
                this.areEqual = false;
                return null;
            }
            if (!val1.toString().equals(val2.toString())) {
                this.areEqual = false;
            }
            return null;
        }

        @Override
        public Toml visitArray(Toml.Array array, Toml other) {
            if (array == other) {
                return null;
            }
            if (!(other instanceof Toml.Array)) {
                this.areEqual = false;
                return null;
            }
            Toml.Array otherArray = (Toml.Array)other;
            List<Toml> values1 = array.getValues();
            List<Toml> values2 = otherArray.getValues();
            if (values1.size() != values2.size()) {
                this.areEqual = false;
                return null;
            }
            this.visitList(values1, values2);
            return null;
        }

        @Override
        public Toml visitIdentifier(Toml.Identifier identifier, Toml other) {
            if (identifier == other) {
                return null;
            }
            if (!(other instanceof Toml.Identifier)) {
                this.areEqual = false;
                return null;
            }
            Toml.Identifier otherIdentifier = (Toml.Identifier)other;
            if (!identifier.getName().equals(otherIdentifier.getName())) {
                this.areEqual = false;
            }
            return null;
        }

        @Override
        public Toml visitEmpty(Toml.Empty empty, Toml other) {
            if (empty == other) {
                return null;
            }
            if (!(other instanceof Toml.Empty)) {
                this.areEqual = false;
            }
            return null;
        }

        private void visitList(@Nullable List<? extends Toml> list1, @Nullable List<? extends Toml> list2) {
            if (!this.areEqual) {
                return;
            }
            if (list1 == null && list2 == null) {
                return;
            }
            if (list1 == null || list2 == null || list1.size() != list2.size()) {
                this.areEqual = false;
                return;
            }
            for (int i = 0; i < list1.size(); ++i) {
                this.visit(list1.get(i), list2.get(i));
                if (this.areEqual) continue;
                return;
            }
        }

        private boolean keyEquals(@Nullable TomlKey key1, @Nullable TomlKey key2) {
            if (key1 == key2) {
                return true;
            }
            if (key1 == null || key2 == null) {
                return false;
            }
            if (key1.getClass() != key2.getClass()) {
                return false;
            }
            if (key1 instanceof Toml.Identifier && key2 instanceof Toml.Identifier) {
                return ((Toml.Identifier)key1).getName().equals(((Toml.Identifier)key2).getName());
            }
            return false;
        }
    }
}

