/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Misc;
import org.openrewrite.xml.tree.Xml;

public class XmlVisitor<P>
extends TreeVisitor<Xml, P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof Xml.Document;
    }

    public String getLanguage() {
        return "xml";
    }

    public Xml visitDocument(Xml.Document document, P p) {
        Xml.Document d = document;
        d = d.withProlog((Xml.Prolog)this.visitAndCast(d.getProlog(), p));
        d = d.withRoot((Xml.Tag)this.visitAndCast(d.getRoot(), p));
        return d.withMarkers(this.visitMarkers(d.getMarkers(), p));
    }

    public Xml visitXmlDecl(Xml.XmlDecl xmlDecl, P p) {
        xmlDecl = xmlDecl.withAttributes(ListUtils.map(xmlDecl.getAttributes(), a -> (Xml.Attribute)this.visitAndCast((Tree)a, p)));
        return xmlDecl.withMarkers(this.visitMarkers(xmlDecl.getMarkers(), p));
    }

    public Xml visitProcessingInstruction(Xml.ProcessingInstruction pi, P p) {
        pi = pi.withProcessingInstructions((Xml.CharData)this.visitAndCast(pi.getProcessingInstructions(), p));
        return pi.withMarkers(this.visitMarkers(pi.getMarkers(), p));
    }

    public Xml visitTag(Xml.Tag tag, P p) {
        Xml.Tag t = tag;
        if ((t = t.withAttributes(ListUtils.map(t.getAttributes(), a -> (Xml.Attribute)this.visitAndCast((Tree)a, p)))).getContent() != null) {
            t = t.withContent(ListUtils.map(t.getContent(), c -> (Content)this.visitAndCast((Tree)c, p)));
        }
        t = t.withClosing((Xml.Tag.Closing)this.visitAndCast(t.getClosing(), p));
        return t.withMarkers(this.visitMarkers(t.getMarkers(), p));
    }

    public Xml visitAttribute(Xml.Attribute attribute, P p) {
        return attribute.withMarkers(this.visitMarkers(attribute.getMarkers(), p));
    }

    public Xml visitCharData(Xml.CharData charData, P p) {
        return charData.withMarkers(this.visitMarkers(charData.getMarkers(), p));
    }

    public Xml visitComment(Xml.Comment comment, P p) {
        return comment.withMarkers(this.visitMarkers(comment.getMarkers(), p));
    }

    public Xml visitDocTypeDecl(Xml.DocTypeDecl docTypeDecl, P p) {
        Xml.DocTypeDecl d = docTypeDecl;
        d = d.withInternalSubset(ListUtils.map(d.getInternalSubset(), i -> (Xml.Ident)this.visitAndCast((Tree)i, p)));
        d = d.withExternalSubsets((Xml.DocTypeDecl.ExternalSubsets)this.visitAndCast(d.getExternalSubsets(), p));
        return d.withMarkers(this.visitMarkers(d.getMarkers(), p));
    }

    public Xml visitProlog(Xml.Prolog prolog, P p) {
        Xml.Prolog pl = prolog;
        pl = pl.withXmlDecl((Xml.XmlDecl)this.visitAndCast(prolog.getXmlDecl(), p));
        pl = pl.withMisc(ListUtils.map(pl.getMisc(), m -> (Misc)this.visitAndCast((Tree)m, p)));
        return pl.withMarkers(this.visitMarkers(pl.getMarkers(), p));
    }

    public Xml visitIdent(Xml.Ident ident, P p) {
        return ident.withMarkers(this.visitMarkers(ident.getMarkers(), p));
    }

    public Xml visitElement(Xml.Element element, P p) {
        return element.withSubset(ListUtils.map(element.getSubset(), i -> (Xml.Ident)this.visitAndCast((Tree)i, p)));
    }
}

