/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangeNamespaceValue
extends Recipe {
    private static final String XMLNS_PREFIX = "xmlns";
    private static final String VERSION_PREFIX = "version";
    private static final String SCHEMA_LOCATION_MATCH_PATTERN = "(?m)(.*)(%s)(\\s+)(.*)";
    private static final String SCHEMA_LOCATION_REPLACEMENT_PATTERN = "$1%s$3%s";
    private static final String MSG_TAG_UPDATED = "msg-tag-updated";
    @Nullable
    @Option(displayName="Element name", description="The name of the element whose attribute's value is to be changed. Interpreted as an XPath Expression.", example="property", required=false)
    private final String elementName;
    @Nullable
    @Option(displayName="Old value", description="Only change the property value if it matches the configured `oldValue`.", example="newfoo.bar.attribute.value.string", required=false)
    private final String oldValue;
    @Option(displayName="New value", description="The new value to be used for the namespace.", example="newfoo.bar.attribute.value.string")
    private final String newValue;
    @Nullable
    @Option(displayName="Resource version", description="The version of resource to change", example="1.1", required=false)
    private final String versionMatcher;
    @Nullable
    @Option(displayName="Search all namespaces", description="Specify whether evaluate all namespaces. Defaults to true", example="true", required=false)
    private final Boolean searchAllNamespaces;
    @Nullable
    @Option(displayName="New Resource version", description="The new version of the resource", example="2.0")
    private final String newVersion;
    @Option(displayName="Schema location", description="The new value to be used for the namespace schema location.", example="newfoo.bar.attribute.value.string", required=false)
    @Nullable
    private final String newSchemaLocation;
    public static final String XML_SCHEMA_INSTANCE_PREFIX = "xsi";
    public static final String XML_SCHEMA_INSTANCE_URI = "http://www.w3.org/2001/XMLSchema-instance";

    public String getDisplayName() {
        return "Change XML attribute of a specific resource version";
    }

    public String getDescription() {
        return "Alters XML Attribute value within specified element of a specific resource versions.";
    }

    public static Xml.Tag findTagContainingXmlSchemaInstanceNamespace(Cursor cursor) {
        while (cursor != null) {
            if (cursor.getValue() instanceof Xml.Document) {
                return ((Xml.Document)cursor.getValue()).getRoot();
            }
            Xml.Tag tag = (Xml.Tag)cursor.firstEnclosing(Xml.Tag.class);
            if (tag != null && tag.getNamespaces().containsValue(XML_SCHEMA_INSTANCE_URI)) {
                return tag;
            }
            cursor = cursor.getParent();
        }
        throw new IllegalArgumentException("Could not find tag containing namespace 'http://www.w3.org/2001/XMLSchema-instance' or the enclosing Xml.Document instance.");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final XPathMatcher elementNameMatcher = this.elementName != null ? new XPathMatcher(this.elementName) : null;
        return new XmlIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml d = super.visitDocument(document, ctx);
                if (((Boolean)ctx.pollMessage(ChangeNamespaceValue.MSG_TAG_UPDATED, (Object)false)).booleanValue()) {
                    d = ((Xml.Document)d).withRoot(this.addOrUpdateSchemaLocation(((Xml.Document)d).getRoot(), this.getCursor()));
                }
                return d;
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml t = super.visitTag(tag, ctx);
                if (this.matchesElementName(this.getCursor()) && this.matchesVersion((Xml.Tag)t)) {
                    t = ((Xml.Tag)t).withAttributes(ListUtils.map(((Xml.Tag)t).getAttributes(), this::maybeReplaceNamespaceAttribute));
                    t = ((Xml.Tag)t).withAttributes(ListUtils.map(((Xml.Tag)t).getAttributes(), this::maybeReplaceVersionAttribute));
                    ctx.putMessage(ChangeNamespaceValue.MSG_TAG_UPDATED, (Object)true);
                }
                return t;
            }

            private boolean matchesElementName(Cursor cursor) {
                return elementNameMatcher == null || elementNameMatcher.matches(cursor);
            }

            private boolean matchesVersion(Xml.Tag tag) {
                if (ChangeNamespaceValue.this.versionMatcher == null) {
                    return true;
                }
                for (Xml.Attribute attribute : tag.getAttributes()) {
                    if (!this.isVersionAttribute(attribute) || !this.isVersionMatch(attribute)) continue;
                    return true;
                }
                return false;
            }

            private Xml.Attribute maybeReplaceNamespaceAttribute(Xml.Attribute attribute) {
                if (this.isXmlnsAttribute(attribute) && this.isOldValue(attribute)) {
                    return attribute.withValue(new Xml.Attribute.Value(attribute.getId(), "", attribute.getMarkers(), attribute.getValue().getQuote(), ChangeNamespaceValue.this.newValue));
                }
                return attribute;
            }

            private Xml.Attribute maybeReplaceVersionAttribute(Xml.Attribute attribute) {
                if (this.isVersionAttribute(attribute) && ChangeNamespaceValue.this.newVersion != null) {
                    return attribute.withValue(new Xml.Attribute.Value(attribute.getId(), "", attribute.getMarkers(), attribute.getValue().getQuote(), ChangeNamespaceValue.this.newVersion));
                }
                return attribute;
            }

            private boolean isXmlnsAttribute(Xml.Attribute attribute) {
                boolean searchAll = ChangeNamespaceValue.this.searchAllNamespaces == null || Boolean.TRUE.equals(ChangeNamespaceValue.this.searchAllNamespaces);
                return searchAll && attribute.getKeyAsString().startsWith(ChangeNamespaceValue.XMLNS_PREFIX) || !searchAll && attribute.getKeyAsString().equals(ChangeNamespaceValue.XMLNS_PREFIX);
            }

            private boolean isVersionAttribute(Xml.Attribute attribute) {
                return attribute.getKeyAsString().startsWith(ChangeNamespaceValue.VERSION_PREFIX);
            }

            private boolean isOldValue(Xml.Attribute attribute) {
                return ChangeNamespaceValue.this.oldValue == null || attribute.getValueAsString().equals(ChangeNamespaceValue.this.oldValue);
            }

            private boolean isVersionMatch(Xml.Attribute attribute) {
                if (ChangeNamespaceValue.this.versionMatcher == null) {
                    return true;
                }
                String[] versions = ChangeNamespaceValue.this.versionMatcher.split(",");
                double dversion = Double.parseDouble(attribute.getValueAsString());
                for (String splitVersion : versions) {
                    double dversionExpected;
                    boolean checkGreaterThan = false;
                    if (splitVersion.endsWith("+")) {
                        splitVersion = splitVersion.substring(0, splitVersion.length() - 1);
                        checkGreaterThan = true;
                    }
                    try {
                        dversionExpected = Double.parseDouble(splitVersion);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                    if ((checkGreaterThan || dversionExpected != dversion) && (!checkGreaterThan || !(dversionExpected <= dversion))) continue;
                    return true;
                }
                return false;
            }

            private Xml.Tag addOrUpdateSchemaLocation(Xml.Tag root, Cursor cursor) {
                if (StringUtils.isBlank((String)ChangeNamespaceValue.this.newSchemaLocation)) {
                    return root;
                }
                Xml.Tag newRoot = this.maybeAddNamespace(root);
                Optional<Xml.Attribute> maybeSchemaLocation = this.maybeGetSchemaLocation(cursor, newRoot);
                if (maybeSchemaLocation.isPresent() && ChangeNamespaceValue.this.oldValue != null) {
                    newRoot = this.updateSchemaLocation(newRoot, maybeSchemaLocation.get());
                } else if (!maybeSchemaLocation.isPresent()) {
                    newRoot = this.addSchemaLocation(newRoot);
                }
                return newRoot;
            }

            private Optional<Xml.Attribute> maybeGetSchemaLocation(Cursor cursor, Xml.Tag tag) {
                Xml.Tag schemaLocationTag = ChangeNamespaceValue.findTagContainingXmlSchemaInstanceNamespace(cursor);
                Map<String, String> namespaces = tag.getNamespaces();
                for (Xml.Attribute attribute : schemaLocationTag.getAttributes()) {
                    String attributeNamespace = namespaces.get(Xml.extractNamespacePrefix(attribute.getKeyAsString()));
                    if (!ChangeNamespaceValue.XML_SCHEMA_INSTANCE_URI.equals(attributeNamespace) || !attribute.getKeyAsString().endsWith("schemaLocation")) continue;
                    return Optional.of(attribute);
                }
                return Optional.empty();
            }

            private Xml.Tag maybeAddNamespace(Xml.Tag root) {
                Map<String, String> namespaces = root.getNamespaces();
                if (namespaces.containsValue(ChangeNamespaceValue.this.newValue) && !namespaces.containsValue(ChangeNamespaceValue.XML_SCHEMA_INSTANCE_URI)) {
                    namespaces.put(ChangeNamespaceValue.XML_SCHEMA_INSTANCE_PREFIX, ChangeNamespaceValue.XML_SCHEMA_INSTANCE_URI);
                    root = root.withNamespaces(namespaces);
                }
                return root;
            }

            private Xml.Tag updateSchemaLocation(Xml.Tag newRoot, Xml.Attribute attribute) {
                if (ChangeNamespaceValue.this.oldValue == null) {
                    return newRoot;
                }
                String oldSchemaLocation = attribute.getValueAsString();
                Matcher pattern = Pattern.compile(String.format(ChangeNamespaceValue.SCHEMA_LOCATION_MATCH_PATTERN, Pattern.quote(ChangeNamespaceValue.this.oldValue))).matcher(oldSchemaLocation);
                if (pattern.find()) {
                    String newSchemaLocationValue = pattern.replaceFirst(String.format(ChangeNamespaceValue.SCHEMA_LOCATION_REPLACEMENT_PATTERN, ChangeNamespaceValue.this.newValue, ChangeNamespaceValue.this.newSchemaLocation));
                    Xml.Attribute newAttribute = attribute.withValue(attribute.getValue().withValue(newSchemaLocationValue));
                    newRoot = newRoot.withAttributes(ListUtils.map(newRoot.getAttributes(), a -> a == attribute ? newAttribute : a));
                }
                return newRoot;
            }

            private Xml.Tag addSchemaLocation(Xml.Tag newRoot) {
                return newRoot.withAttributes(ListUtils.concat(newRoot.getAttributes(), (Object)new Xml.Attribute(Tree.randomId(), " ", Markers.EMPTY, new Xml.Ident(Tree.randomId(), "", Markers.EMPTY, String.format("%s:schemaLocation", ChangeNamespaceValue.XML_SCHEMA_INSTANCE_PREFIX)), "", new Xml.Attribute.Value(Tree.randomId(), "", Markers.EMPTY, Xml.Attribute.Value.Quote.Double, String.format("%s %s", ChangeNamespaceValue.this.newValue, ChangeNamespaceValue.this.newSchemaLocation)))));
            }
        };
    }

    @Generated
    public ChangeNamespaceValue(@Nullable String elementName, @Nullable String oldValue, String newValue, @Nullable String versionMatcher, @Nullable Boolean searchAllNamespaces, @Nullable String newVersion, @Nullable String newSchemaLocation) {
        this.elementName = elementName;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.versionMatcher = versionMatcher;
        this.searchAllNamespaces = searchAllNamespaces;
        this.newVersion = newVersion;
        this.newSchemaLocation = newSchemaLocation;
    }

    @Nullable
    @Generated
    public String getElementName() {
        return this.elementName;
    }

    @Nullable
    @Generated
    public String getOldValue() {
        return this.oldValue;
    }

    @Generated
    public String getNewValue() {
        return this.newValue;
    }

    @Nullable
    @Generated
    public String getVersionMatcher() {
        return this.versionMatcher;
    }

    @Nullable
    @Generated
    public Boolean getSearchAllNamespaces() {
        return this.searchAllNamespaces;
    }

    @Nullable
    @Generated
    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    @Generated
    public String getNewSchemaLocation() {
        return this.newSchemaLocation;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeNamespaceValue(elementName=" + this.getElementName() + ", oldValue=" + this.getOldValue() + ", newValue=" + this.getNewValue() + ", versionMatcher=" + this.getVersionMatcher() + ", searchAllNamespaces=" + this.getSearchAllNamespaces() + ", newVersion=" + this.getNewVersion() + ", newSchemaLocation=" + this.getNewSchemaLocation() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeNamespaceValue)) {
            return false;
        }
        ChangeNamespaceValue other = (ChangeNamespaceValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$searchAllNamespaces = this.getSearchAllNamespaces();
        Boolean other$searchAllNamespaces = other.getSearchAllNamespaces();
        if (this$searchAllNamespaces == null ? other$searchAllNamespaces != null : !((Object)this$searchAllNamespaces).equals(other$searchAllNamespaces)) {
            return false;
        }
        String this$elementName = this.getElementName();
        String other$elementName = other.getElementName();
        if (this$elementName == null ? other$elementName != null : !this$elementName.equals(other$elementName)) {
            return false;
        }
        String this$oldValue = this.getOldValue();
        String other$oldValue = other.getOldValue();
        if (this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        if (this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue)) {
            return false;
        }
        String this$versionMatcher = this.getVersionMatcher();
        String other$versionMatcher = other.getVersionMatcher();
        if (this$versionMatcher == null ? other$versionMatcher != null : !this$versionMatcher.equals(other$versionMatcher)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$newSchemaLocation = this.getNewSchemaLocation();
        String other$newSchemaLocation = other.getNewSchemaLocation();
        return !(this$newSchemaLocation == null ? other$newSchemaLocation != null : !this$newSchemaLocation.equals(other$newSchemaLocation));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeNamespaceValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $searchAllNamespaces = this.getSearchAllNamespaces();
        result = result * 59 + ($searchAllNamespaces == null ? 43 : ((Object)$searchAllNamespaces).hashCode());
        String $elementName = this.getElementName();
        result = result * 59 + ($elementName == null ? 43 : $elementName.hashCode());
        String $oldValue = this.getOldValue();
        result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        String $versionMatcher = this.getVersionMatcher();
        result = result * 59 + ($versionMatcher == null ? 43 : $versionMatcher.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $newSchemaLocation = this.getNewSchemaLocation();
        result = result * 59 + ($newSchemaLocation == null ? 43 : $newSchemaLocation.hashCode());
        return result;
    }
}

