/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.trait;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.trait.SimpleTraitMatcher;
import org.openrewrite.trait.TypeReference;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

final class SpringTypeReference
implements TypeReference {
    private final Cursor cursor;

    public Tree getTree() {
        return super.getTree();
    }

    public String getName() {
        Xml.Tag tag;
        if (this.getTree() instanceof Xml.Attribute) {
            Xml.Attribute attribute = (Xml.Attribute)this.getTree();
            return attribute.getValueAsString();
        }
        if (this.getTree() instanceof Xml.Tag && (tag = (Xml.Tag)this.getTree()).getValue().isPresent()) {
            return tag.getValue().get();
        }
        throw new IllegalArgumentException("getTree() must be an Xml.Attribute or Xml.Tag: " + this.getTree().getClass());
    }

    @Generated
    public SpringTypeReference(Cursor cursor) {
        this.cursor = cursor;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringTypeReference)) {
            return false;
        }
        SpringTypeReference other = (SpringTypeReference)o;
        Cursor this$cursor = this.getCursor();
        Cursor other$cursor = other.getCursor();
        return !(this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "SpringTypeReference(cursor=" + this.getCursor() + ")";
    }

    public static class Provider
    implements TypeReference.Provider {
        public Set<TypeReference> getTypeReferences(SourceFile sourceFile) {
            HashSet<TypeReference> typeReferences = new HashSet<TypeReference>();
            new Matcher().asVisitor(reference -> {
                typeReferences.add((TypeReference)reference);
                return reference.getTree();
            }).visit((Tree)sourceFile, (Object)0);
            return typeReferences;
        }

        public boolean isAcceptable(SourceFile sourceFile) {
            if (sourceFile instanceof Xml.Document) {
                Xml.Document doc = (Xml.Document)sourceFile;
                for (Xml.Attribute attrib : doc.getRoot().getAttributes()) {
                    if (!attrib.getKeyAsString().equals("xsi:schemaLocation") || !attrib.getValueAsString().contains("www.springframework.org/schema/beans")) continue;
                    return true;
                }
            }
            return false;
        }
    }

    static class Matcher
    extends SimpleTraitMatcher<SpringTypeReference> {
        private final Pattern typeReference = Pattern.compile("(?:[a-zA-Z_][a-zA-Z0-9_]*\\.)+[A-Z*][a-zA-Z0-9_]*(?:<[a-zA-Z0-9_,?<> ]*>)?");
        private final XPathMatcher classXPath = new XPathMatcher("//@class");
        private final XPathMatcher typeXPath = new XPathMatcher("//@type");
        private final XPathMatcher tags = new XPathMatcher("//value");

        Matcher() {
        }

        protected @Nullable SpringTypeReference test(Cursor cursor) {
            Object value = cursor.getValue();
            if (value instanceof Xml.Attribute) {
                Xml.Attribute attrib = (Xml.Attribute)value;
                if ((this.classXPath.matches(cursor) || this.typeXPath.matches(cursor)) && this.typeReference.matcher(attrib.getValueAsString()).matches()) {
                    return new SpringTypeReference(cursor);
                }
            } else if (value instanceof Xml.Tag) {
                Xml.Tag tag = (Xml.Tag)value;
                if (this.tags.matches(cursor) && tag.getValue().isPresent() && this.typeReference.matcher(tag.getValue().get()).matches()) {
                    return new SpringTypeReference(cursor);
                }
            }
            return null;
        }
    }
}

