/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.security;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.security.IsOwaspSuppressionsFile;
import org.openrewrite.xml.tree.Xml;

public final class AddOwaspDateBoundSuppressions
extends Recipe {
    @Option(displayName="Until date", required=false, description="Optional. The date to add to the suppression. Default will be 30 days from today.", example="2023-01-01")
    @Nullable
    private final String untilDate;

    public String getDisplayName() {
        return "Add date bounds to OWASP suppressions";
    }

    public String getDescription() {
        return "Adds an expiration date to all OWASP suppressions in order to ensure that they are periodically reviewed. For use with the OWASP `dependency-check` tool. More details: https://jeremylong.github.io/DependencyCheck/general/suppression.html.";
    }

    public Validated<Object> validate() {
        return super.validate().and(Validated.test((String)"untilDate", (String)"Must be empty or a valid date of format yyyy-MM-dd", (Object)this.untilDate, date -> {
            if (date != null && !date.isEmpty()) {
                try {
                    LocalDate.parse(date);
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        }));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsOwaspSuppressionsFile(), (TreeVisitor)new XmlIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml t = super.visitTag(tag, ctx);
                if (new XPathMatcher("/suppressions/suppress").matches(this.getCursor())) {
                    boolean hasUntil = false;
                    List<Xml.Attribute> attributes = ((Xml.Tag)t).getAttributes();
                    for (Xml.Attribute attribute : attributes) {
                        if (!attribute.getKeyAsString().equals("until")) continue;
                        hasUntil = true;
                    }
                    if (!hasUntil) {
                        String date = AddOwaspDateBoundSuppressions.this.untilDate != null && !AddOwaspDateBoundSuppressions.this.untilDate.isEmpty() ? AddOwaspDateBoundSuppressions.this.untilDate : LocalDate.now().plus(30L, ChronoUnit.DAYS).toString();
                        return ((Xml.Tag)t).withAttributes(ListUtils.concat(attributes, (Object)this.autoFormat(new Xml.Attribute(Tree.randomId(), "", Markers.EMPTY, new Xml.Ident(Tree.randomId(), "", Markers.EMPTY, "until"), "", this.autoFormat(new Xml.Attribute.Value(Tree.randomId(), "", Markers.EMPTY, Xml.Attribute.Value.Quote.Double, date + "Z"), ctx)), ctx)));
                    }
                }
                return t;
            }
        });
    }

    public AddOwaspDateBoundSuppressions(@Nullable String untilDate) {
        this.untilDate = untilDate;
    }

    @Nullable
    public String getUntilDate() {
        return this.untilDate;
    }

    @NonNull
    public String toString() {
        return "AddOwaspDateBoundSuppressions(untilDate=" + this.getUntilDate() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddOwaspDateBoundSuppressions)) {
            return false;
        }
        AddOwaspDateBoundSuppressions other = (AddOwaspDateBoundSuppressions)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$untilDate = this.getUntilDate();
        String other$untilDate = other.getUntilDate();
        return !(this$untilDate == null ? other$untilDate != null : !this$untilDate.equals(other$untilDate));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddOwaspDateBoundSuppressions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $untilDate = this.getUntilDate();
        result = result * 59 + ($untilDate == null ? 43 : $untilDate.hashCode());
        return result;
    }
}

