/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.search;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class FindProperty
extends Recipe {
    @Option(displayName="Property key", description="The key to look for.", example="management.metrics.binders.files.enabled")
    private final String propertyKey;

    public String getDisplayName() {
        return "Find YAML properties";
    }

    public String getDescription() {
        return "Find a YAML property. Nested YAML mappings are interpreted as dot separated property names, i.e.  as Spring Boot interprets application.yml files.";
    }

    public YamlVisitor<ExecutionContext> getVisitor() {
        return new YamlIsoVisitor<ExecutionContext>(){

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml e = super.visitMappingEntry(entry, ctx);
                Deque propertyEntries = this.getCursor().getPathAsStream().filter(Yaml.Mapping.Entry.class::isInstance).map(Yaml.Mapping.Entry.class::cast).collect(Collectors.toCollection(ArrayDeque::new));
                String prop = StreamSupport.stream(Spliterators.spliteratorUnknownSize(propertyEntries.descendingIterator(), 0), false).map(e2 -> e2.getKey().getValue()).collect(Collectors.joining("."));
                if (prop.equals(FindProperty.this.propertyKey)) {
                    e = ((Yaml.Mapping.Entry)e).withValue((Yaml.Block)((Yaml.Mapping.Entry)e).getValue().withMarkers(((Yaml.Mapping.Entry)e).getValue().getMarkers().searchResult()));
                }
                return e;
            }
        };
    }

    public static Set<Yaml.Block> find(Yaml y, final String propertyKey) {
        YamlIsoVisitor<Set<Yaml.Block>> findVisitor = new YamlIsoVisitor<Set<Yaml.Block>>(){

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, Set<Yaml.Block> values) {
                Yaml e = super.visitMappingEntry(entry, values);
                Deque propertyEntries = this.getCursor().getPathAsStream().filter(Yaml.Mapping.Entry.class::isInstance).map(Yaml.Mapping.Entry.class::cast).collect(Collectors.toCollection(ArrayDeque::new));
                String prop = StreamSupport.stream(Spliterators.spliteratorUnknownSize(propertyEntries.descendingIterator(), 0), false).map(e2 -> e2.getKey().getValue()).collect(Collectors.joining("."));
                if (prop.equals(propertyKey)) {
                    values.add(entry.getValue());
                }
                return e;
            }
        };
        HashSet<Yaml.Block> values = new HashSet<Yaml.Block>();
        findVisitor.visit(y, values);
        return values;
    }

    public FindProperty(String propertyKey) {
        this.propertyKey = propertyKey;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    @NonNull
    public String toString() {
        return "FindProperty(propertyKey=" + this.getPropertyKey() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindProperty)) {
            return false;
        }
        FindProperty other = (FindProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        return !(this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        return result;
    }
}

