/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.AppendToSequenceVisitor;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlVisitor;

public final class AppendToSequence
extends Recipe {
    @Option(displayName="sequence path", description="A JsonPath expression to locate a YAML sequence.", example="$.universe.planets")
    private final String sequencePath;
    @Option(displayName="New value", description="The new value to be appended to the sequence.", example="earth")
    private final String value;
    @Option(displayName="Optional: match existing sequence values", description="Recipe appends to sequence only when existing sequence values match", example="existingValue1", required=false)
    @Nullable
    private final List<String> existingSequenceValues;
    @Option(displayName="Optional boolean: match existing sequence values in any order", description="match existing sequence values in any order", example="true", required=false)
    @Nullable
    private final String matchExistingSequenceValuesInAnyOrder;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/application-*.yml")
    @Nullable
    private final String fileMatcher;

    public String getDisplayName() {
        return "Append to sequence";
    }

    public String getDescription() {
        return "Append item to YAML sequence.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    public YamlVisitor<ExecutionContext> getVisitor() {
        JsonPathMatcher matcher = new JsonPathMatcher(this.sequencePath);
        boolean anyOrder = this.matchExistingSequenceValuesInAnyOrder == null ? false : Boolean.valueOf(this.matchExistingSequenceValuesInAnyOrder);
        return new AppendToSequenceVisitor(matcher, this.value, this.existingSequenceValues, anyOrder);
    }

    public AppendToSequence(String sequencePath, String value, @Nullable List<String> existingSequenceValues, @Nullable String matchExistingSequenceValuesInAnyOrder, @Nullable String fileMatcher) {
        this.sequencePath = sequencePath;
        this.value = value;
        this.existingSequenceValues = existingSequenceValues;
        this.matchExistingSequenceValuesInAnyOrder = matchExistingSequenceValuesInAnyOrder;
        this.fileMatcher = fileMatcher;
    }

    public String getSequencePath() {
        return this.sequencePath;
    }

    public String getValue() {
        return this.value;
    }

    @Nullable
    public List<String> getExistingSequenceValues() {
        return this.existingSequenceValues;
    }

    @Nullable
    public String getMatchExistingSequenceValuesInAnyOrder() {
        return this.matchExistingSequenceValuesInAnyOrder;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "AppendToSequence(sequencePath=" + this.getSequencePath() + ", value=" + this.getValue() + ", existingSequenceValues=" + this.getExistingSequenceValues() + ", matchExistingSequenceValuesInAnyOrder=" + this.getMatchExistingSequenceValuesInAnyOrder() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppendToSequence)) {
            return false;
        }
        AppendToSequence other = (AppendToSequence)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$sequencePath = this.getSequencePath();
        String other$sequencePath = other.getSequencePath();
        if (this$sequencePath == null ? other$sequencePath != null : !this$sequencePath.equals(other$sequencePath)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        List<String> this$existingSequenceValues = this.getExistingSequenceValues();
        List<String> other$existingSequenceValues = other.getExistingSequenceValues();
        if (this$existingSequenceValues == null ? other$existingSequenceValues != null : !((Object)this$existingSequenceValues).equals(other$existingSequenceValues)) {
            return false;
        }
        String this$matchExistingSequenceValuesInAnyOrder = this.getMatchExistingSequenceValuesInAnyOrder();
        String other$matchExistingSequenceValuesInAnyOrder = other.getMatchExistingSequenceValuesInAnyOrder();
        if (this$matchExistingSequenceValuesInAnyOrder == null ? other$matchExistingSequenceValuesInAnyOrder != null : !this$matchExistingSequenceValuesInAnyOrder.equals(other$matchExistingSequenceValuesInAnyOrder)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AppendToSequence;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $sequencePath = this.getSequencePath();
        result = result * 59 + ($sequencePath == null ? 43 : $sequencePath.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        List<String> $existingSequenceValues = this.getExistingSequenceValues();
        result = result * 59 + ($existingSequenceValues == null ? 43 : ((Object)$existingSequenceValues).hashCode());
        String $matchExistingSequenceValuesInAnyOrder = this.getMatchExistingSequenceValuesInAnyOrder();
        result = result * 59 + ($matchExistingSequenceValuesInAnyOrder == null ? 43 : $matchExistingSequenceValuesInAnyOrder.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

