/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.format;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.yaml.MultilineScalarChanged;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.style.IndentsStyle;
import org.openrewrite.yaml.tree.Yaml;

public class IndentsVisitor<P>
extends YamlIsoVisitor<P> {
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^(\\s*)(.*\\R?)", 8);
    private final IndentsStyle style;
    private final @Nullable Tree stopAfter;

    public IndentsVisitor(IndentsStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    public @Nullable Yaml visit(@Nullable Tree tree, P p, Cursor parent) {
        this.setCursor(parent);
        for (Cursor c = parent; c != null && c.getValue() instanceof Yaml; c = c.getParent()) {
            int indent;
            Yaml y = (Yaml)c.getValue();
            String prefix = y.getPrefix();
            if (!StringUtils.hasLineBreak((String)prefix) || (indent = this.findIndent(prefix)) == 0) continue;
            c.putMessage("lastIndent", (Object)indent);
        }
        Iterator path = parent.getPath(Yaml.class::isInstance);
        if (path.hasNext()) {
            this.preVisit((Yaml)path.next(), p);
        }
        return this.visit(tree, (Object)p);
    }

    public @Nullable Yaml preVisit(Yaml tree, P p) {
        if (((Boolean)this.getCursor().getNearestMessage("stop", (Object)false)).booleanValue()) {
            return tree;
        }
        Yaml y = tree;
        int indent = (Integer)this.getCursor().getNearestMessage("lastIndent", (Object)0);
        if (StringUtils.hasLineBreak((String)y.getPrefix()) && !this.isUnindentedTopLevel()) {
            if (y instanceof Yaml.Sequence.Entry) {
                indent = (Integer)this.getCursor().getParentOrThrow().getMessage("sequenceEntryIndent", (Object)indent);
                y = y.withPrefix(this.indentTo(y.getPrefix(), indent + this.style.getIndentSize()));
                this.getCursor().getParentOrThrow().putMessage("sequenceEntryIndent", (Object)indent);
                this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)(indent + this.firstIndent(((Yaml.Sequence.Entry)y).getBlock()).length() + 1));
            } else if (y instanceof Yaml.Mapping.Entry) {
                y = y.withPrefix(this.indentTo(y.getPrefix(), indent + this.style.getIndentSize()));
                this.getCursor().putMessage("lastIndent", (Object)(indent + this.style.getIndentSize()));
            } else if (y instanceof Yaml.Document) {
                y = y.withPrefix(this.indentComments(y.getPrefix(), 0));
            }
        } else if (y instanceof Yaml.Mapping.Entry) {
            if (this.getCursor().getParentOrThrow(2).getValue() instanceof Yaml.Sequence.Entry) {
                this.getCursor().putMessage("lastIndent", (Object)(indent + this.style.getIndentSize()));
            } else {
                y = y.withPrefix(this.indentComments(y.getPrefix(), indent));
            }
        } else if (y instanceof Yaml.Scalar && y.getMarkers().findFirst(MultilineScalarChanged.class).isPresent()) {
            int indentValue = indent;
            if (!((MultilineScalarChanged)y.getMarkers().findFirst(MultilineScalarChanged.class).get()).isAdded() && indent != 0) {
                indentValue = indent + this.style.getIndentSize();
            }
            String newValue = ((Yaml.Scalar)y).getValue().replaceAll("\\R", "\n" + StringUtils.repeat((String)" ", (int)indentValue));
            y = ((Yaml.Scalar)y).withValue(newValue);
        }
        return y;
    }

    private boolean isUnindentedTopLevel() {
        return this.getCursor().getParentOrThrow().getValue() instanceof Yaml.Document || this.getCursor().getParentOrThrow(2).getValue() instanceof Yaml.Document;
    }

    public @Nullable Yaml postVisit(Yaml tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Yaml.Documents.class, "stop", (Object)true);
        }
        return (Yaml)super.postVisit((Tree)tree, p);
    }

    public @Nullable Yaml visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Yaml)tree;
        }
        return (Yaml)super.visit(tree, p);
    }

    private String indentTo(String prefix, int column) {
        int indent;
        if (StringUtils.hasLineBreak((String)prefix) && (indent = this.findIndent(prefix)) != column) {
            int shift = column - indent;
            prefix = this.indent(prefix, shift);
        }
        return this.indentComments(prefix, column);
    }

    private String indentComments(String prefix, int column) {
        if (prefix.contains("#")) {
            Matcher m = COMMENT_PATTERN.matcher(prefix);
            StringBuilder result = new StringBuilder();
            String indent = StringUtils.repeat((String)" ", (int)column);
            boolean firstLine = true;
            while (m.find()) {
                String whitespace = m.group(1);
                String comment = m.group(2);
                int newlineCount = StringUtils.countOccurrences((String)whitespace, (String)"\n");
                if (firstLine && newlineCount == 0) {
                    if (this.getCursor().getValue() instanceof Yaml.Documents || this.getCursor().getValue() instanceof Yaml.Document) {
                        result.append(indent);
                    } else {
                        result.append(whitespace);
                    }
                    result.append(comment);
                } else {
                    result.append(StringUtils.repeat((String)"\n", (int)newlineCount)).append(indent).append(comment);
                }
                firstLine = false;
            }
            if (!prefix.contentEquals(result)) {
                prefix = result.toString();
            }
        }
        return prefix;
    }

    private String indent(String whitespace, int shift) {
        StringBuilder newWhitespace = new StringBuilder(whitespace);
        this.shift(newWhitespace, shift);
        return newWhitespace.toString();
    }

    private void shift(StringBuilder text, int shift) {
        if (shift > 0) {
            for (int i = 0; i < shift; ++i) {
                text.append(' ');
            }
        } else {
            text.delete(text.length() + shift, text.length());
        }
    }

    private int findIndent(String prefix) {
        int size = 0;
        for (char c : prefix.toCharArray()) {
            ++size;
            if (c != '\n' && c != '\r') continue;
            size = 0;
        }
        return size;
    }

    private String firstIndent(final Yaml yaml) {
        AtomicReference<@Nullable String> indent = new AtomicReference<String>();
        new YamlIsoVisitor<AtomicReference<String>>(){

            public @Nullable Yaml visit(@Nullable Tree tree, AtomicReference<String> indent) {
                Yaml y = (Yaml)tree;
                if (indent.get() != null) {
                    return y;
                }
                if (y != null && y != yaml && !(y instanceof Yaml.Mapping) && !(y instanceof Yaml.Sequence.Entry)) {
                    indent.set(y.getPrefix());
                    return y;
                }
                return (Yaml)super.visit(tree, indent);
            }
        }.visit(yaml, indent);
        String indentStr = indent.get();
        return indentStr == null ? "" : indentStr;
    }
}

