/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Marker;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.Style;
import org.openrewrite.yaml.MergeYaml;
import org.openrewrite.yaml.MultilineScalarChanged;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class MergeYamlVisitor<P>
extends YamlVisitor<P> {
    private static final Pattern LINE_BREAK = Pattern.compile("\\R");
    private final Yaml existing;
    private final Yaml incoming;
    private final boolean acceptTheirs;
    private final @Nullable String objectIdentifyingProperty;
    private final @Nullable MergeYaml.InsertMode insertMode;
    private final @Nullable String insertProperty;
    private boolean shouldAutoFormat = true;
    private @Nullable String linebreak = null;

    private String linebreak() {
        if (this.linebreak == null) {
            this.linebreak = Optional.ofNullable((Yaml.Documents)this.getCursor().firstEnclosing(Yaml.Documents.class)).map(docs -> (GeneralFormatStyle)Style.from(GeneralFormatStyle.class, (SourceFile)docs)).map(format -> format.isUseCRLFNewLines() ? "\r\n" : "\n").orElse("\n");
        }
        return this.linebreak;
    }

    public MergeYamlVisitor(Yaml.Block block, Yaml incoming, boolean acceptTheirs, @Nullable String objectIdentifyingProperty, boolean shouldAutoFormat, @Nullable MergeYaml.InsertMode insertMode, @Nullable String insertProperty) {
        this((Yaml)block, incoming, acceptTheirs, objectIdentifyingProperty, insertMode, insertProperty);
        this.shouldAutoFormat = shouldAutoFormat;
    }

    @Deprecated
    public MergeYamlVisitor(Yaml scope, @Language(value="yml") String yamlString, boolean acceptTheirs, @Nullable String objectIdentifyingProperty, @Nullable MergeYaml.InsertMode insertMode, @Nullable String insertProperty) {
        this(scope, MergeYaml.parse(yamlString), acceptTheirs, objectIdentifyingProperty, insertMode, insertProperty);
    }

    @Override
    public Yaml visitScalar(Yaml.Scalar existingScalar, P p) {
        if (this.existing.isScope(existingScalar) && this.incoming instanceof Yaml.Scalar) {
            return this.mergeScalar(existingScalar, (Yaml.Scalar)this.incoming);
        }
        return super.visitScalar(existingScalar, p);
    }

    @Override
    public Yaml visitSequence(Yaml.Sequence existingSeq, P p) {
        if (this.existing.isScope(existingSeq)) {
            if (this.incoming instanceof Yaml.Mapping) {
                return existingSeq.withEntries(ListUtils.map(existingSeq.getEntries(), (i, existingSeqEntry) -> existingSeqEntry.withBlock((Yaml.Block)new MergeYamlVisitor<P>(existingSeqEntry.getBlock(), this.incoming, this.acceptTheirs, this.objectIdentifyingProperty, this.shouldAutoFormat, this.insertMode, this.insertProperty).visitNonNull(existingSeqEntry.getBlock(), p, new Cursor(this.getCursor(), existingSeqEntry)))));
            }
            if (this.incoming instanceof Yaml.Sequence) {
                return this.mergeSequence(existingSeq, (Yaml.Sequence)this.incoming, p, this.getCursor());
            }
        }
        return super.visitSequence(existingSeq, p);
    }

    @Override
    public Yaml visitMapping(Yaml.Mapping existingMapping, P p) {
        if (this.existing.isScope(existingMapping) && this.incoming instanceof Yaml.Mapping) {
            Yaml.Mapping mapping = this.mergeMapping(existingMapping, (Yaml.Mapping)this.incoming, p, this.getCursor());
            if (((Boolean)this.getCursor().getMessage("REMOVE_PREFIX", (Object)false)).booleanValue()) {
                List<Yaml.Mapping.Entry> entries = ((Yaml.Mapping)this.getCursor().getValue()).getEntries();
                return mapping.withEntries(ListUtils.mapLast(mapping.getEntries(), it -> it.withPrefix(this.linebreak() + this.substringOfAfterFirstLineBreak(((Yaml.Mapping.Entry)entries.get(entries.size() - 1)).getPrefix()))));
            }
            return mapping;
        }
        return super.visitMapping(existingMapping, p);
    }

    private static boolean keyMatches(@Nullable Yaml.Mapping.Entry e1, @Nullable Yaml.Mapping.Entry e2) {
        return e1 != null && e2 != null && e1.getKey().getValue().equals(e2.getKey().getValue());
    }

    private boolean keyMatches(Yaml.Mapping m1, Yaml.Mapping m2) {
        Optional<String> nameToAdd = m2.getEntries().stream().filter(e -> this.objectIdentifyingProperty != null && this.objectIdentifyingProperty.equals(e.getKey().getValue())).map(e -> ((Yaml.Scalar)e.getValue()).getValue()).findAny();
        return nameToAdd.map(nameToAddValue -> m1.getEntries().stream().filter(e -> this.objectIdentifyingProperty.equals(e.getKey().getValue())).map(e -> ((Yaml.Scalar)e.getValue()).getValue()).anyMatch(existingName -> existingName.equals(nameToAddValue))).orElse(false);
    }

    private Yaml.Mapping mergeMapping(Yaml.Mapping m1, Yaml.Mapping m2, P p, Cursor cursor) {
        List mergedEntries = ListUtils.map(m1.getEntries(), existingEntry -> {
            for (Yaml.Mapping.Entry incomingEntry : m2.getEntries()) {
                if (!MergeYamlVisitor.keyMatches(existingEntry, incomingEntry)) continue;
                Yaml.Block value = incomingEntry.getValue();
                if (this.shouldAutoFormat && incomingEntry.getValue() instanceof Yaml.Scalar && StringUtils.hasLineBreak((String)((Yaml.Scalar)value).getValue())) {
                    MultilineScalarChanged marker = new MultilineScalarChanged(Tree.randomId(), false, this.calculateMultilineIndent(incomingEntry));
                    value = this.autoFormat((Yaml.Block)value.withMarkers(value.getMarkers().add((Marker)marker)), p);
                }
                Yaml mergedYaml = (Yaml)new MergeYamlVisitor<P>(existingEntry.getValue(), value, this.acceptTheirs, this.objectIdentifyingProperty, this.shouldAutoFormat, this.insertMode, this.insertProperty).visitNonNull(existingEntry.getValue(), p, new Cursor(cursor, existingEntry));
                return existingEntry.withValue((Yaml.Block)mergedYaml);
            }
            return existingEntry;
        });
        List newEntries = ListUtils.map(m2.getEntries(), it -> {
            for (Yaml.Mapping.Entry existingEntry : m1.getEntries()) {
                if (!MergeYamlVisitor.keyMatches(existingEntry, it)) continue;
                return null;
            }
            if (this.shouldAutoFormat && it.getValue() instanceof Yaml.Scalar && StringUtils.hasLineBreak((String)((Yaml.Scalar)it.getValue()).getValue())) {
                MultilineScalarChanged marker = new MultilineScalarChanged(Tree.randomId(), true, this.calculateMultilineIndent((Yaml.Mapping.Entry)it));
                it = it.withValue((Yaml.Block)it.getValue().withMarkers(it.getValue().getMarkers().add((Marker)marker)));
            }
            return this.shouldAutoFormat ? this.autoFormat(it, p, cursor) : it;
        });
        ListConcat<Yaml.Mapping.Entry> mutatedEntries = this.concatAll(mergedEntries, newEntries, it -> it.getKey().getValue());
        if (m1.getEntries().size() < ((ListConcat)mutatedEntries).ls.size() && !this.getCursor().isRoot()) {
            if (((ListConcat)mutatedEntries).lastNewlyAddedItemIndex != -1 && ((ListConcat)mutatedEntries).lastNewlyAddedItemIndex < ((ListConcat)mutatedEntries).ls.size() - 1) {
                Yaml.Mapping.Entry afterInsertEntry = (Yaml.Mapping.Entry)((ListConcat)mutatedEntries).ls.get(((ListConcat)mutatedEntries).lastNewlyAddedItemIndex + 1);
                if (((ListConcat)mutatedEntries).firstNewlyAddedItemIndex == 0 && this.getCursor().getParentOrThrow().getValue() instanceof Yaml.Document && ((Yaml.Mapping)((Yaml.Document)this.getCursor().getParentOrThrow().getValue()).getBlock()).getEntries().equals(((Yaml.Mapping)this.existing).getEntries())) {
                    ((ListConcat)mutatedEntries).ls.set(((ListConcat)mutatedEntries).firstNewlyAddedItemIndex, ((Yaml.Mapping.Entry)((ListConcat)mutatedEntries).ls.get(0)).withPrefix(""));
                    ((ListConcat)mutatedEntries).ls.set(((ListConcat)mutatedEntries).lastNewlyAddedItemIndex + 1, afterInsertEntry.withPrefix(this.linebreak() + ((Yaml.Document)this.getCursor().getParentOrThrow().getValue()).getPrefix() + afterInsertEntry.getPrefix()));
                    this.getCursor().getParentOrThrow().putMessage("REMOVE_PREFIX", (Object)true);
                } else {
                    Yaml.Mapping.Entry firstNewlyAddedEntry = (Yaml.Mapping.Entry)((ListConcat)mutatedEntries).ls.get(((ListConcat)mutatedEntries).firstNewlyAddedItemIndex);
                    String partOne = this.substringOfBeforeFirstLineBreak(afterInsertEntry.getPrefix());
                    String partTwo = this.substringOfAfterFirstLineBreak(afterInsertEntry.getPrefix());
                    ((ListConcat)mutatedEntries).ls.set(((ListConcat)mutatedEntries).firstNewlyAddedItemIndex, firstNewlyAddedEntry.withPrefix(partOne + firstNewlyAddedEntry.getPrefix()));
                    ((ListConcat)mutatedEntries).ls.set(((ListConcat)mutatedEntries).lastNewlyAddedItemIndex + 1, afterInsertEntry.withPrefix(this.linebreak() + partTwo));
                }
            } else {
                Cursor c = this.getCursor().dropParentUntil(it -> {
                    if ("root".equals(it) || it instanceof Yaml.Document) {
                        return true;
                    }
                    if (it instanceof Yaml.Mapping) {
                        List<Yaml.Mapping.Entry> entries = ((Yaml.Mapping)it).getEntries();
                        return entries.size() > 1 && !entries.get(entries.size() - 1).equals(this.getCursor().getParentOrThrow().getValue());
                    }
                    return false;
                });
                String comment = null;
                if (c.getValue() instanceof Yaml.Document) {
                    comment = ((Yaml.Document)c.getValue()).getEnd().getPrefix();
                } else if (c.getValue() instanceof Yaml.Mapping) {
                    List<Yaml.Mapping.Entry> entries = ((Yaml.Mapping)c.getValue()).getEntries();
                    for (int i = 0; i < entries.size() - 1; ++i) {
                        if (!entries.get(i).getValue().equals(this.getCursor().getValue())) continue;
                        comment = this.substringOfBeforeFirstLineBreak(entries.get(i + 1).getPrefix());
                        break;
                    }
                    if (comment == null && StringUtils.hasLineBreak((String)entries.get(entries.size() - 1).getPrefix())) {
                        comment = this.substringOfBeforeFirstLineBreak(entries.get(entries.size() - 1).getPrefix());
                    }
                }
                if (StringUtils.isNotEmpty((String)comment)) {
                    Yaml.Mapping.Entry last = (Yaml.Mapping.Entry)((ListConcat)mutatedEntries).ls.get(((ListConcat)mutatedEntries).ls.size() - 1);
                    ((ListConcat)mutatedEntries).ls.set(((ListConcat)mutatedEntries).ls.size() - 1, last.withPrefix(comment + last.getPrefix()));
                    c.putMessage("REMOVE_PREFIX", (Object)true);
                }
            }
        }
        if (this.insertMode != MergeYaml.InsertMode.Before) {
            this.removePrefixForDirectChildren(m1.getEntries(), ((ListConcat)mutatedEntries).ls);
        }
        return m1.withEntries(((ListConcat)mutatedEntries).ls);
    }

    private void removePrefixForDirectChildren(List<Yaml.Mapping.Entry> m1Entries, List<Yaml.Mapping.Entry> mutatedEntries) {
        for (int i = 0; i < m1Entries.size() - 1; ++i) {
            if (!(m1Entries.get(i).getValue() instanceof Yaml.Mapping) || !(mutatedEntries.get(i).getValue() instanceof Yaml.Mapping) || ((Yaml.Mapping)m1Entries.get(i).getValue()).getEntries().size() >= ((Yaml.Mapping)mutatedEntries.get(i).getValue()).getEntries().size()) continue;
            mutatedEntries.set(i + 1, mutatedEntries.get(i + 1).withPrefix(this.linebreak() + this.substringOfAfterFirstLineBreak(mutatedEntries.get(i + 1).getPrefix())));
        }
    }

    private Yaml.Sequence mergeSequence(Yaml.Sequence s1, Yaml.Sequence s2, P p, Cursor cursor) {
        if (this.acceptTheirs) {
            return s1;
        }
        boolean isSequenceOfScalars = s2.getEntries().stream().allMatch(entry -> entry.getBlock() instanceof Yaml.Scalar);
        if (isSequenceOfScalars) {
            ArrayList<Yaml.Sequence.Entry> incomingEntries = new ArrayList<Yaml.Sequence.Entry>(s2.getEntries());
            block0: for (Yaml.Sequence.Entry entry2 : s1.getEntries()) {
                if (!(entry2.getBlock() instanceof Yaml.Scalar)) continue;
                String existingScalar = ((Yaml.Scalar)entry2.getBlock()).getValue();
                for (Yaml.Sequence.Entry incomingEntry : incomingEntries) {
                    if (!((Yaml.Scalar)incomingEntry.getBlock()).getValue().equals(existingScalar)) continue;
                    incomingEntries.remove(incomingEntry);
                    continue block0;
                }
            }
            String existingEntryPrefix = s1.getEntries().get(0).getPrefix();
            String currentIndent = existingEntryPrefix.substring(existingEntryPrefix.lastIndexOf(10));
            List newEntries = ListUtils.map(incomingEntries, it -> it.withPrefix(currentIndent));
            List mutatedEntries = ((ListConcat)this.concatAll(s1.getEntries(), newEntries, it -> ((Yaml.Scalar)it.getBlock()).getValue())).ls;
            return s1.withEntries(mutatedEntries);
        }
        if (this.objectIdentifyingProperty == null) {
            return s1;
        }
        List mutatedEntries = ListUtils.map(s2.getEntries(), entry -> {
            Yaml.Mapping incomingMapping = (Yaml.Mapping)entry.getBlock();
            for (Yaml.Sequence.Entry existingEntry : s1.getEntries()) {
                Yaml.Mapping existingMapping = (Yaml.Mapping)existingEntry.getBlock();
                if (!this.keyMatches(existingMapping, incomingMapping)) continue;
                Yaml.Sequence.Entry e1 = existingEntry.withBlock(this.mergeMapping(existingMapping, incomingMapping, p, cursor));
                if (e1 == existingEntry) {
                    return null;
                }
                return e1;
            }
            return entry;
        });
        List entries = ((ListConcat)this.concatAll(ListUtils.filter(s1.getEntries(), it -> !mutatedEntries.contains(it)), ListUtils.map((List)mutatedEntries, it -> this.autoFormat(it, p, cursor)), it -> {
            Yaml.Mapping.Entry entry = ((Yaml.Mapping)it.getBlock()).getEntries().get(0);
            return entry.getKey().getValue() + ": " + ((Yaml.Scalar)entry.getValue()).getValue();
        })).ls;
        return s1.withEntries(entries);
    }

    private Yaml.Scalar mergeScalar(Yaml.Scalar y1, Yaml.Scalar y2) {
        String s2;
        String s1 = y1.getValue();
        return !s1.equals(s2 = y2.getValue()) && !this.acceptTheirs ? y1.withValue(s2) : y1;
    }

    private <T> ListConcat<T> concatAll(List<T> ls, List<T> t, Function<T, String> getValue) {
        if (this.insertMode == null || this.insertMode == MergeYaml.InsertMode.Last || this.insertProperty == null || t.isEmpty()) {
            return new ListConcat(ListUtils.concatAll(ls, t), -1, -1);
        }
        ArrayList<T> mutatedEntries = new ArrayList<T>();
        boolean hasInsertedBeforeOrAfterElements = false;
        int insertIndex = -1;
        int closeIndex = -1;
        for (int i = 0; i < ls.size(); ++i) {
            T existingEntry = ls.get(i);
            if (!hasInsertedBeforeOrAfterElements && this.insertMode == MergeYaml.InsertMode.Before && this.insertProperty.equals(getValue.apply(existingEntry))) {
                hasInsertedBeforeOrAfterElements = true;
                mutatedEntries.addAll(t);
                insertIndex = i;
                closeIndex = i + t.size() - 1;
            }
            mutatedEntries.add(existingEntry);
            if (hasInsertedBeforeOrAfterElements || this.insertMode != MergeYaml.InsertMode.After || !this.insertProperty.equals(getValue.apply(existingEntry))) continue;
            hasInsertedBeforeOrAfterElements = true;
            mutatedEntries.addAll(t);
            insertIndex = i + 1;
            closeIndex = i + t.size();
        }
        if (!hasInsertedBeforeOrAfterElements) {
            mutatedEntries.addAll(t);
        }
        return new ListConcat(mutatedEntries, insertIndex, closeIndex);
    }

    private String substringOfBeforeFirstLineBreak(String s) {
        String[] lines = LINE_BREAK.split(s);
        return lines.length > 0 ? lines[0] : "";
    }

    private String substringOfAfterFirstLineBreak(String s) {
        String[] lines = LINE_BREAK.split(s, -1);
        return lines.length > 1 ? String.join((CharSequence)this.linebreak(), Arrays.copyOfRange(lines, 1, lines.length)) : "";
    }

    private int calculateMultilineIndent(Yaml.Mapping.Entry entry) {
        String[] lines = LINE_BREAK.split(entry.getPrefix(), -1);
        int keyIndent = (lines.length > 1 ? lines[lines.length - 1] : "").length();
        int indent = StringUtils.minCommonIndentLevel((String)this.substringOfAfterFirstLineBreak(((Yaml.Scalar)entry.getValue()).getValue()));
        return Math.max(indent - keyIndent, 0);
    }

    @Generated
    public MergeYamlVisitor(Yaml existing, Yaml incoming, boolean acceptTheirs, @Nullable String objectIdentifyingProperty, @Nullable MergeYaml.InsertMode insertMode, @Nullable String insertProperty) {
        this.existing = existing;
        this.incoming = incoming;
        this.acceptTheirs = acceptTheirs;
        this.objectIdentifyingProperty = objectIdentifyingProperty;
        this.insertMode = insertMode;
        this.insertProperty = insertProperty;
    }

    private static final class ListConcat<T> {
        private final List<T> ls;
        private final int firstNewlyAddedItemIndex;
        private final int lastNewlyAddedItemIndex;

        @Generated
        public ListConcat(List<T> ls, int firstNewlyAddedItemIndex, int lastNewlyAddedItemIndex) {
            this.ls = ls;
            this.firstNewlyAddedItemIndex = firstNewlyAddedItemIndex;
            this.lastNewlyAddedItemIndex = lastNewlyAddedItemIndex;
        }

        @Generated
        public List<T> getLs() {
            return this.ls;
        }

        @Generated
        public int getFirstNewlyAddedItemIndex() {
            return this.firstNewlyAddedItemIndex;
        }

        @Generated
        public int getLastNewlyAddedItemIndex() {
            return this.lastNewlyAddedItemIndex;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListConcat)) {
                return false;
            }
            ListConcat other = (ListConcat)o;
            if (this.getFirstNewlyAddedItemIndex() != other.getFirstNewlyAddedItemIndex()) {
                return false;
            }
            if (this.getLastNewlyAddedItemIndex() != other.getLastNewlyAddedItemIndex()) {
                return false;
            }
            List<T> this$ls = this.getLs();
            List<T> other$ls = other.getLs();
            return !(this$ls == null ? other$ls != null : !((Object)this$ls).equals(other$ls));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getFirstNewlyAddedItemIndex();
            result = result * 59 + this.getLastNewlyAddedItemIndex();
            List<T> $ls = this.getLs();
            result = result * 59 + ($ls == null ? 43 : ((Object)$ls).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "MergeYamlVisitor.ListConcat(ls=" + this.getLs() + ", firstNewlyAddedItemIndex=" + this.getFirstNewlyAddedItemIndex() + ", lastNewlyAddedItemIndex=" + this.getLastNewlyAddedItemIndex() + ")";
        }
    }
}

