/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.instantiation;

import de.danielbechler.diff.access.PropertyAwareAccessor;
import de.danielbechler.diff.instantiation.InstanceFactory;
import de.danielbechler.util.Assert;
import java.util.Collection;
import java.util.LinkedList;

public class TypeInfo {
    private final Class<?> type;
    private final Collection<PropertyAwareAccessor> accessors = new LinkedList<PropertyAwareAccessor>();
    private InstanceFactory instanceFactory;

    public TypeInfo(Class<?> type) {
        Assert.notNull(type, "type");
        this.type = type;
    }

    public void addPropertyAccessor(PropertyAwareAccessor propertyAccessor) {
        if (propertyAccessor != null) {
            this.accessors.add(propertyAccessor);
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    public Object newInstance() {
        return this.instanceFactory.newInstanceOfType(this.type);
    }

    public Collection<PropertyAwareAccessor> getAccessors() {
        return this.accessors;
    }

    public void setInstanceFactory(InstanceFactory instanceFactory) {
        this.instanceFactory = instanceFactory;
    }
}

