/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.gitrepo;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.openrewrite.jgit.annotations.NonNull;
import org.openrewrite.jgit.api.errors.GitAPIException;
import org.openrewrite.jgit.gitrepo.RepoProject;
import org.openrewrite.jgit.gitrepo.internal.RepoText;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.lib.Repository;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ManifestParser
extends DefaultHandler {
    private final String filename;
    private final URI baseUrl;
    private final String defaultBranch;
    private final Repository rootRepo;
    private final Map<String, Remote> remotes;
    private final Set<String> plusGroups;
    private final Set<String> minusGroups;
    private final List<RepoProject> projects;
    private final List<RepoProject> filteredProjects;
    private final IncludedFileReader includedReader;
    private String defaultRemote;
    private String defaultRevision;
    private int xmlInRead;
    private RepoProject currentProject;

    public ManifestParser(IncludedFileReader includedReader, String filename, String defaultBranch, String baseUrl, String groups, Repository rootRepo) {
        this.includedReader = includedReader;
        this.filename = filename;
        this.defaultBranch = defaultBranch;
        this.rootRepo = rootRepo;
        this.baseUrl = ManifestParser.normalizeEmptyPath(URI.create(baseUrl));
        this.plusGroups = new HashSet<String>();
        this.minusGroups = new HashSet<String>();
        if (groups == null || groups.length() == 0 || groups.equals("default")) {
            this.minusGroups.add("notdefault");
        } else {
            for (String group : groups.split(",")) {
                if (group.startsWith("-")) {
                    this.minusGroups.add(group.substring(1));
                    continue;
                }
                this.plusGroups.add(group);
            }
        }
        this.remotes = new HashMap<String, Remote>();
        this.projects = new ArrayList<RepoProject>();
        this.filteredProjects = new ArrayList<RepoProject>();
    }

    public void read(InputStream inputStream) throws IOException {
        XMLReader xr;
        ++this.xmlInRead;
        try {
            xr = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            throw new IOException(JGitText.get().noXMLParserAvailable, e);
        }
        xr.setContentHandler(this);
        try {
            xr.parse(new InputSource(inputStream));
        }
        catch (SAXException e) {
            throw new IOException(RepoText.get().errorParsingManifestFile, e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName == null) {
            return;
        }
        var5_5 = qName;
        var6_6 = -1;
        switch (var5_5.hashCode()) {
            case -309310695: {
                if (!var5_5.equals("project")) break;
                var6_6 = 0;
                break;
            }
            case -934610874: {
                if (!var5_5.equals("remote")) break;
                var6_6 = 1;
                break;
            }
            case 1544803905: {
                if (!var5_5.equals("default")) break;
                var6_6 = 2;
                break;
            }
            case -505421199: {
                if (!var5_5.equals("copyfile")) break;
                var6_6 = 3;
                break;
            }
            case 1194727542: {
                if (!var5_5.equals("linkfile")) break;
                var6_6 = 4;
                break;
            }
            case 1942574248: {
                if (!var5_5.equals("include")) break;
                var6_6 = 5;
                break;
            }
            case -851352880: {
                if (!var5_5.equals("remove-project")) break;
                var6_6 = 6;
            }
        }
        switch (var6_6) {
            case 0: {
                if (attributes.getValue("name") == null) {
                    throw new SAXException(RepoText.get().invalidManifest);
                }
                this.currentProject = new RepoProject(attributes.getValue("name"), attributes.getValue("path"), attributes.getValue("revision"), attributes.getValue("remote"), attributes.getValue("groups"));
                this.currentProject.setRecommendShallow(attributes.getValue("clone-depth"));
                break;
            }
            case 1: {
                alias = attributes.getValue("alias");
                fetch = attributes.getValue("fetch");
                revision = attributes.getValue("revision");
                remote = new Remote(fetch, revision);
                this.remotes.put(attributes.getValue("name"), remote);
                if (alias == null) break;
                this.remotes.put(alias, remote);
                break;
            }
            case 2: {
                this.defaultRemote = attributes.getValue("remote");
                this.defaultRevision = attributes.getValue("revision");
                break;
            }
            case 3: {
                if (this.currentProject == null) {
                    throw new SAXException(RepoText.get().invalidManifest);
                }
                this.currentProject.addCopyFile(new RepoProject.CopyFile(this.rootRepo, this.currentProject.getPath(), attributes.getValue("src"), attributes.getValue("dest")));
                break;
            }
            case 4: {
                if (this.currentProject == null) {
                    throw new SAXException(RepoText.get().invalidManifest);
                }
                this.currentProject.addLinkFile(new RepoProject.LinkFile(this.rootRepo, this.currentProject.getPath(), attributes.getValue("src"), attributes.getValue("dest")));
                break;
            }
            case 5: {
                name = attributes.getValue("name");
                if (this.includedReader == null) ** GOTO lbl103
                try {
                    is = this.includedReader.readIncludeFile(name);
                    var13_16 = null;
                    if (is == null) {
                        throw new SAXException(RepoText.get().errorIncludeNotImplemented);
                    }
                    this.read(is);
                    if (is == null) break;
                    if (var13_16 == null) ** GOTO lbl83
                    try {
                        is.close();
                    }
                    catch (Throwable var14_18) {
                        var13_16.addSuppressed(var14_18);
                    }
                    break;
lbl83:
                    // 1 sources

                    is.close();
                    ** break;
                    catch (Throwable var14_19) {
                        try {
                            var13_16 = var14_19;
                            throw var14_19;
                        }
                        catch (Throwable var15_22) {
                            if (is != null) {
                                if (var13_16 != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable var16_24) {
                                        var13_16.addSuppressed(var16_24);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                            throw var15_22;
lbl100:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (Exception e) {
                    throw new SAXException(MessageFormat.format(RepoText.get().errorIncludeFile, new Object[]{name}), e);
                }
lbl103:
                // 1 sources

                if (this.filename == null) break;
                index = this.filename.lastIndexOf(47);
                path = this.filename.substring(0, index + 1) + name;
                try {
                    is = new FileInputStream(path);
                    var15_23 = null;
                    this.read(is);
                    if (is == null) break;
                    if (var15_23 == null) ** GOTO lbl119
                    try {
                        is.close();
                    }
                    catch (Throwable var16_25) {
                        var15_23.addSuppressed(var16_25);
                    }
                    break;
lbl119:
                    // 1 sources

                    is.close();
                    ** break;
                    catch (Throwable var16_26) {
                        try {
                            var15_23 = var16_26;
                            throw var16_26;
                        }
                        catch (Throwable var17_27) {
                            if (is != null) {
                                if (var15_23 != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable var18_28) {
                                        var15_23.addSuppressed(var18_28);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                            throw var17_27;
lbl136:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (IOException e) {
                    throw new SAXException(MessageFormat.format(RepoText.get().errorIncludeFile, new Object[]{path}), e);
                }
            }
            case 6: {
                name2 = attributes.getValue("name");
                this.projects.removeIf((Predicate<RepoProject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$startElement$0(java.lang.String org.openrewrite.jgit.gitrepo.RepoProject ), (Lorg/openrewrite/jgit/gitrepo/RepoProject;)Z)((String)name2));
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("project".equals(qName)) {
            this.projects.add(this.currentProject);
            this.currentProject = null;
        }
    }

    @Override
    public void endDocument() throws SAXException {
        --this.xmlInRead;
        if (this.xmlInRead != 0) {
            return;
        }
        HashMap<String, URI> remoteUrls = new HashMap<String, URI>();
        if (this.defaultRevision == null && this.defaultRemote != null) {
            Remote remote = this.remotes.get(this.defaultRemote);
            if (remote != null) {
                this.defaultRevision = remote.revision;
            }
            if (this.defaultRevision == null) {
                this.defaultRevision = this.defaultBranch;
            }
        }
        for (RepoProject proj : this.projects) {
            String remote = proj.getRemote();
            String revision = this.defaultRevision;
            if (remote == null) {
                if (this.defaultRemote == null) {
                    if (this.filename != null) {
                        throw new SAXException(MessageFormat.format(RepoText.get().errorNoDefaultFilename, this.filename));
                    }
                    throw new SAXException(RepoText.get().errorNoDefault);
                }
                remote = this.defaultRemote;
            } else {
                Remote r = this.remotes.get(remote);
                if (r != null && r.revision != null) {
                    revision = r.revision;
                }
            }
            URI remoteUrl = (URI)remoteUrls.get(remote);
            if (remoteUrl == null) {
                String fetch = this.remotes.get((Object)remote).fetch;
                if (fetch == null) {
                    throw new SAXException(MessageFormat.format(RepoText.get().errorNoFetch, remote));
                }
                remoteUrl = ManifestParser.normalizeEmptyPath(this.baseUrl.resolve(fetch));
                remoteUrls.put(remote, remoteUrl);
            }
            proj.setUrl(remoteUrl.resolve(proj.getName()).toString()).setDefaultRevision(revision);
        }
        this.filteredProjects.addAll(this.projects);
        this.removeNotInGroup();
        this.removeOverlaps();
    }

    static URI normalizeEmptyPath(URI u) {
        if (u.getHost() != null && !u.getHost().isEmpty() && (u.getPath() == null || u.getPath().isEmpty())) {
            try {
                return new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), "/", u.getQuery(), u.getFragment());
            }
            catch (URISyntaxException x) {
                throw new IllegalArgumentException(x.getMessage(), x);
            }
        }
        return u;
    }

    public List<RepoProject> getProjects() {
        return this.projects;
    }

    @NonNull
    public List<RepoProject> getFilteredProjects() {
        return this.filteredProjects;
    }

    void removeNotInGroup() {
        Iterator<RepoProject> iter = this.filteredProjects.iterator();
        while (iter.hasNext()) {
            if (this.inGroups(iter.next())) continue;
            iter.remove();
        }
    }

    void removeOverlaps() {
        Collections.sort(this.filteredProjects);
        Iterator<RepoProject> iter = this.filteredProjects.iterator();
        if (!iter.hasNext()) {
            return;
        }
        RepoProject last = iter.next();
        while (iter.hasNext()) {
            RepoProject p = iter.next();
            if (last.isAncestorOf(p)) {
                iter.remove();
                continue;
            }
            last = p;
        }
        this.removeNestedCopyAndLinkfiles();
    }

    private void removeNestedCopyAndLinkfiles() {
        for (RepoProject proj : this.filteredProjects) {
            ArrayList<RepoProject.CopyFile> copyfiles = new ArrayList<RepoProject.CopyFile>(proj.getCopyFiles());
            proj.clearCopyFiles();
            for (RepoProject.CopyFile copyfile : copyfiles) {
                if (this.isNestedReferencefile(copyfile)) continue;
                proj.addCopyFile(copyfile);
            }
            ArrayList<RepoProject.LinkFile> linkfiles = new ArrayList<RepoProject.LinkFile>(proj.getLinkFiles());
            proj.clearLinkFiles();
            for (RepoProject.LinkFile linkfile : linkfiles) {
                if (this.isNestedReferencefile(linkfile)) continue;
                proj.addLinkFile(linkfile);
            }
        }
    }

    boolean inGroups(RepoProject proj) {
        for (String group : this.minusGroups) {
            if (!proj.inGroup(group)) continue;
            return false;
        }
        if (this.plusGroups.isEmpty() || this.plusGroups.contains("all")) {
            return true;
        }
        for (String group : this.plusGroups) {
            if (!proj.inGroup(group)) continue;
            return true;
        }
        return false;
    }

    private boolean isNestedReferencefile(RepoProject.ReferenceFile referencefile) {
        if (referencefile.dest.indexOf(47) == -1) {
            return false;
        }
        for (RepoProject proj : this.filteredProjects) {
            if (proj.getPath().compareTo(referencefile.dest) > 0) {
                return false;
            }
            if (!proj.isAncestorOf(referencefile.dest)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$startElement$0(String name2, RepoProject p) {
        return p.getName().equals(name2);
    }

    private static class Remote {
        final String fetch;
        final String revision;

        Remote(String fetch, String revision) {
            this.fetch = fetch;
            this.revision = revision;
        }
    }

    public static interface IncludedFileReader {
        public InputStream readIncludeFile(String var1) throws GitAPIException, IOException;
    }
}

