/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.lib;

import java.io.IOException;
import org.openrewrite.jgit.errors.IncorrectObjectTypeException;
import org.openrewrite.jgit.errors.MissingObjectException;
import org.openrewrite.jgit.lib.AnyObjectId;
import org.openrewrite.jgit.lib.ObjectInserter;
import org.openrewrite.jgit.lib.ObjectLoader;
import org.openrewrite.jgit.lib.ObjectReader;

public abstract class ObjectDatabase {
    protected ObjectDatabase() {
    }

    public boolean exists() {
        return true;
    }

    public void create() throws IOException {
    }

    public abstract ObjectInserter newInserter();

    public abstract ObjectReader newReader();

    public abstract void close();

    public boolean has(AnyObjectId objectId) throws IOException {
        try (ObjectReader or = this.newReader();){
            boolean bl = or.has(objectId);
            return bl;
        }
    }

    public ObjectLoader open(AnyObjectId objectId) throws IOException {
        return this.open(objectId, -1);
    }

    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        try (ObjectReader or = this.newReader();){
            ObjectLoader objectLoader = or.open(objectId, typeHint);
            return objectLoader;
        }
    }

    public ObjectDatabase newCachedDatabase() {
        return this;
    }
}

