/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.nls;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.openrewrite.jgit.nls.TranslationBundle;

class GlobalBundleCache {
    private static final Map<Locale, Map<Class, TranslationBundle>> cachedBundles = new HashMap<Locale, Map<Class, TranslationBundle>>();

    GlobalBundleCache() {
    }

    static synchronized <T extends TranslationBundle> T lookupBundle(Locale locale, Class<T> type) {
        try {
            TranslationBundle bundle;
            Map<Class, TranslationBundle> bundles = cachedBundles.get(locale);
            if (bundles == null) {
                bundles = new HashMap<Class, TranslationBundle>();
                cachedBundles.put(locale, bundles);
            }
            if ((bundle = bundles.get(type)) == null) {
                bundle = (TranslationBundle)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                bundle.load(locale);
                bundles.put(type, bundle);
            }
            return (T)bundle;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new Error(e);
        }
    }

    static void clear() {
        cachedBundles.clear();
    }
}

