/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xmlsec.encryption.CipherData;
import org.opensaml.xmlsec.encryption.CipherReference;
import org.opensaml.xmlsec.encryption.CipherValue;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CipherDataTest
extends XMLObjectProviderBaseTestCase {
    public CipherDataTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/encryption/impl/CipherData.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/encryption/impl/CipherDataChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        CipherData cipherData = (CipherData)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)cipherData, (String)"CipherData");
        Assert.assertNull((Object)cipherData.getCipherValue(), (String)"CipherValue child element");
        Assert.assertNull((Object)cipherData.getCipherReference(), (String)"CipherReference child element");
    }

    @Test
    public void testChildElementsUnmarshall() {
        CipherData cipherData = (CipherData)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)cipherData, (String)"CipherData");
        Assert.assertNotNull((Object)cipherData.getCipherValue(), (String)"CipherValue child element");
        Assert.assertNotNull((Object)cipherData.getCipherReference(), (String)"CipherReference child element");
    }

    @Test
    public void testSingleElementMarshall() {
        CipherData cipherData = (CipherData)this.buildXMLObject(CipherData.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)cipherData);
    }

    @Test
    public void testChildElementsMarshall() {
        CipherData cipherData = (CipherData)this.buildXMLObject(CipherData.DEFAULT_ELEMENT_NAME);
        cipherData.setCipherValue((CipherValue)this.buildXMLObject(CipherValue.DEFAULT_ELEMENT_NAME));
        cipherData.setCipherReference((CipherReference)this.buildXMLObject(CipherReference.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)cipherData);
    }
}

