/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.xmlsec.encryption.EncryptionMethod;
import org.opensaml.xmlsec.encryption.KeySize;
import org.opensaml.xmlsec.encryption.OAEPparams;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EncryptionMethodTest
extends XMLObjectProviderBaseTestCase {
    private String expectedAlgorithm;
    private int expectedNumUnknownChildren;

    public EncryptionMethodTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/encryption/impl/EncryptionMethod.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/encryption/impl/EncryptionMethodChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedAlgorithm = "urn:string:foo";
        this.expectedNumUnknownChildren = 2;
    }

    @Test
    public void testSingleElementUnmarshall() {
        EncryptionMethod em = (EncryptionMethod)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)em, (String)"EncryptionMethod");
        Assert.assertEquals((String)em.getAlgorithm(), (String)this.expectedAlgorithm, (String)"Algorithm attribute");
        Assert.assertNull((Object)em.getKeySize(), (String)"KeySize child");
        Assert.assertNull((Object)em.getOAEPparams(), (String)"OAEPparams child");
        Assert.assertEquals((int)em.getUnknownXMLObjects().size(), (int)0, (String)"Unknown children");
    }

    @Test
    public void testChildElementsUnmarshall() {
        EncryptionMethod em = (EncryptionMethod)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)em, (String)"EncryptionMethod");
        Assert.assertEquals((String)em.getAlgorithm(), (String)this.expectedAlgorithm, (String)"Algorithm attribute");
        Assert.assertNotNull((Object)em.getKeySize(), (String)"KeySize child");
        Assert.assertNotNull((Object)em.getOAEPparams(), (String)"OAEPparams child");
        Assert.assertEquals((int)em.getUnknownXMLObjects().size(), (int)this.expectedNumUnknownChildren, (String)"Unknown children");
    }

    @Test
    public void testSingleElementMarshall() {
        EncryptionMethod em = (EncryptionMethod)this.buildXMLObject(EncryptionMethod.DEFAULT_ELEMENT_NAME);
        em.setAlgorithm(this.expectedAlgorithm);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)em);
    }

    @Test
    public void testChildElementsMarshall() {
        EncryptionMethod em = (EncryptionMethod)this.buildXMLObject(EncryptionMethod.DEFAULT_ELEMENT_NAME);
        em.setAlgorithm(this.expectedAlgorithm);
        em.setKeySize((KeySize)this.buildXMLObject(KeySize.DEFAULT_ELEMENT_NAME));
        em.setOAEPparams((OAEPparams)this.buildXMLObject(OAEPparams.DEFAULT_ELEMENT_NAME));
        em.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        em.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)em);
    }
}

