/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.xmlsec.encryption.MGF;
import org.opensaml.xmlsec.encryption.Parameters;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MGFTest
extends XMLObjectProviderBaseTestCase {
    private String expectedAlgorithm;
    private String expectedParametersContent;

    public MGFTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/encryption/impl/MGF.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/encryption/impl/MGFChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedAlgorithm = "urn:string:foo";
        this.expectedParametersContent = "MyParams";
    }

    @Test
    public void testSingleElementUnmarshall() {
        MGF mgf = (MGF)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)mgf, (String)"MGF");
        Assert.assertEquals((String)mgf.getAlgorithm(), (String)this.expectedAlgorithm, (String)"Algorithm attribute");
    }

    @Test
    public void testChildElementsUnmarshall() {
        MGF mgf = (MGF)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)mgf, (String)"MGF");
        Assert.assertEquals((String)mgf.getAlgorithm(), (String)this.expectedAlgorithm, (String)"Algorithm attribute");
        Assert.assertNotNull((Object)mgf.getParameters(), (String)"Parameters child element");
        System.out.println("Parameters: " + mgf.getParameters().getClass().getName());
    }

    @Test
    public void testSingleElementMarshall() {
        MGF mgf = (MGF)this.buildXMLObject(MGF.DEFAULT_ELEMENT_NAME);
        mgf.setAlgorithm(this.expectedAlgorithm);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)mgf);
    }

    @Test
    public void testChildElementsMarshall() {
        MGF mgf = (MGF)this.buildXMLObject(MGF.DEFAULT_ELEMENT_NAME);
        mgf.setAlgorithm(this.expectedAlgorithm);
        XMLObjectBuilder xsAnyBuilder = builderFactory.getBuilder(XSAny.TYPE_NAME);
        XSAny parameters = (XSAny)xsAnyBuilder.buildObject(Parameters.DEFAULT_ELEMENT_NAME);
        parameters.setTextContent(this.expectedParametersContent);
        mgf.setParameters((XMLObject)parameters);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)mgf);
    }
}

