/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support;

import javax.crypto.Cipher;
import net.shibboleth.utilities.java.support.testing.TestSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.security.SecurityProviderTestSupport;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.algorithm.KeyLengthSpecifiedAlgorithm;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.Decrypter;
import org.opensaml.xmlsec.encryption.support.Encrypter;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.mock.SignableSimpleXMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AESGCMTest
extends XMLObjectBaseTestCase {
    private Logger log = LoggerFactory.getLogger(AESGCMTest.class);
    private String targetFile = "/org/opensaml/xmlsec/encryption/support/SimpleEncryptionTest.xml";
    private SecurityProviderTestSupport providerSupport = new SecurityProviderTestSupport();

    @DataProvider
    public Object[][] testDataAESGCM() {
        AlgorithmRegistry registry = AlgorithmSupport.getGlobalAlgorithmRegistry();
        AlgorithmDescriptor aesGCM128 = registry.get("http://www.w3.org/2009/xmlenc11#aes128-gcm");
        AlgorithmDescriptor aesGCM192 = registry.get("http://www.w3.org/2009/xmlenc11#aes192-gcm");
        AlgorithmDescriptor aesGCM256 = registry.get("http://www.w3.org/2009/xmlenc11#aes256-gcm");
        return new Object[][]{{aesGCM128, 7, TestSupport.isJavaV7OrLater(), true}, {aesGCM192, 8, TestSupport.isJavaV8OrLater(), true}, {aesGCM256, 8, TestSupport.isJavaV8OrLater(), true}, {aesGCM128, 8, TestSupport.isJavaV8OrLater(), false}, {aesGCM192, 8, TestSupport.isJavaV8OrLater(), false}, {aesGCM256, 8, TestSupport.isJavaV8OrLater(), false}, {aesGCM128, 8, TestSupport.isJavaV8OrLater(), true}, {aesGCM192, 8, TestSupport.isJavaV8OrLater(), true}, {aesGCM256, 8, TestSupport.isJavaV8OrLater(), true}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="testDataAESGCM")
    public void testEncryptDecrypt(AlgorithmDescriptor descriptor, int minJavaVersion, boolean haveJavaVersion, boolean loadBC) throws Exception {
        if (!haveJavaVersion) {
            this.log.debug("Not Java {}+, skipping test", (Object)minJavaVersion);
            return;
        }
        int maxKeyLength = Cipher.getMaxAllowedKeyLength(descriptor.getJCAAlgorithmID());
        this.log.debug("Installed policy indicates max allowed key length for '{}' is: {}", (Object)descriptor.getJCAAlgorithmID(), (Object)maxKeyLength);
        if (descriptor instanceof KeyLengthSpecifiedAlgorithm && ((KeyLengthSpecifiedAlgorithm)descriptor).getKeyLength() > maxKeyLength) {
            this.log.debug("Key length {} will exceed max key length {}", (Object)((KeyLengthSpecifiedAlgorithm)descriptor).getKeyLength(), (Object)maxKeyLength);
        } else {
            this.log.debug("Key length {} is ok for max key length {}", (Object)((KeyLengthSpecifiedAlgorithm)descriptor).getKeyLength(), (Object)maxKeyLength);
        }
        try {
            if (loadBC) {
                this.providerSupport.loadBC();
            }
            SignableSimpleXMLObject sxo = (SignableSimpleXMLObject)this.unmarshallElement(this.targetFile);
            Credential encCred = AlgorithmSupport.generateSymmetricKeyAndCredential((String)descriptor.getURI());
            DataEncryptionParameters encParams = new DataEncryptionParameters();
            encParams.setAlgorithm(descriptor.getURI());
            encParams.setEncryptionCredential(encCred);
            Encrypter encrypter = new Encrypter();
            EncryptedData encryptedData = encrypter.encryptElement((XMLObject)sxo, encParams);
            Assert.assertNotNull((Object)encryptedData);
            Assert.assertEquals((String)encryptedData.getEncryptionMethod().getAlgorithm(), (String)descriptor.getURI());
            StaticKeyInfoCredentialResolver dataKeyInfoResolver = new StaticKeyInfoCredentialResolver(encCred);
            Decrypter decrypter = new Decrypter((KeyInfoCredentialResolver)dataKeyInfoResolver, null, null);
            XMLObject decryptedXMLObject = decrypter.decryptData(encryptedData);
            Assert.assertNotNull((Object)decryptedXMLObject);
            Assert.assertTrue((boolean)(decryptedXMLObject instanceof SignableSimpleXMLObject));
            this.assertXMLEquals(sxo.getDOM().getOwnerDocument(), decryptedXMLObject);
        }
        finally {
            this.providerSupport.unloadBC();
        }
    }
}

