/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InlineEncryptedKeyResolverTest
extends XMLObjectBaseTestCase {
    private InlineEncryptedKeyResolver resolver;

    @Test
    public void testSingleEKNoRecipients() {
        String filename = "/org/opensaml/xmlsec/encryption/support/InlineEncryptedKeyResolverSingle.xml";
        EncryptedData encData = (EncryptedData)this.unmarshallElement(filename);
        Assert.assertNotNull((Object)encData);
        Assert.assertNotNull((Object)encData.getKeyInfo());
        List allKeys = encData.getKeyInfo().getEncryptedKeys();
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new InlineEncryptedKeyResolver();
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver);
        Assert.assertEquals((int)resolved.size(), (int)1, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Test
    public void testSingleEKOneRecipientWithMatch() {
        String filename = "/org/opensaml/xmlsec/encryption/support/InlineEncryptedKeyResolverSingle.xml";
        EncryptedData encData = (EncryptedData)this.unmarshallElement(filename);
        Assert.assertNotNull((Object)encData);
        Assert.assertNotNull((Object)encData.getKeyInfo());
        List allKeys = encData.getKeyInfo().getEncryptedKeys();
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new InlineEncryptedKeyResolver(Collections.singleton("foo"));
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver);
        Assert.assertEquals((int)resolved.size(), (int)1, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Test
    public void testSingleEKOneRecipientNoMatch() {
        String filename = "/org/opensaml/xmlsec/encryption/support/InlineEncryptedKeyResolverSingle.xml";
        EncryptedData encData = (EncryptedData)this.unmarshallElement(filename);
        Assert.assertNotNull((Object)encData);
        Assert.assertNotNull((Object)encData.getKeyInfo());
        List allKeys = encData.getKeyInfo().getEncryptedKeys();
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new InlineEncryptedKeyResolver(Collections.singleton("bar"));
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver);
        Assert.assertEquals((int)resolved.size(), (int)0, (String)"Incorrect number of resolved EncryptedKeys found");
    }

    @Test
    public void testMultiEKNoRecipients() {
        String filename = "/org/opensaml/xmlsec/encryption/support/InlineEncryptedKeyResolverMultiple.xml";
        EncryptedData encData = (EncryptedData)this.unmarshallElement(filename);
        Assert.assertNotNull((Object)encData);
        Assert.assertNotNull((Object)encData.getKeyInfo());
        List allKeys = encData.getKeyInfo().getEncryptedKeys();
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new InlineEncryptedKeyResolver();
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver);
        Assert.assertEquals((int)resolved.size(), (int)4, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(1) == allKeys.get(1) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(2) == allKeys.get(2) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(3) == allKeys.get(3) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Test
    public void testMultiEKOneRecipientWithMatch() {
        String filename = "/org/opensaml/xmlsec/encryption/support/InlineEncryptedKeyResolverMultiple.xml";
        EncryptedData encData = (EncryptedData)this.unmarshallElement(filename);
        Assert.assertNotNull((Object)encData);
        Assert.assertNotNull((Object)encData.getKeyInfo());
        List allKeys = encData.getKeyInfo().getEncryptedKeys();
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new InlineEncryptedKeyResolver(Collections.singleton("foo"));
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver);
        Assert.assertEquals((int)resolved.size(), (int)2, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(1) == allKeys.get(2) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    @Test
    public void testMultiEKOneRecipientWithMatches() {
        String filename = "/org/opensaml/xmlsec/encryption/support/InlineEncryptedKeyResolverMultiple.xml";
        EncryptedData encData = (EncryptedData)this.unmarshallElement(filename);
        Assert.assertNotNull((Object)encData);
        Assert.assertNotNull((Object)encData.getKeyInfo());
        List allKeys = encData.getKeyInfo().getEncryptedKeys();
        Assert.assertFalse((boolean)allKeys.isEmpty());
        this.resolver = new InlineEncryptedKeyResolver(new HashSet<String>(Arrays.asList("foo", "baz")));
        List<EncryptedKey> resolved = this.generateList(encData, (EncryptedKeyResolver)this.resolver);
        Assert.assertEquals((int)resolved.size(), (int)3, (String)"Incorrect number of resolved EncryptedKeys found");
        Assert.assertTrue((resolved.get(0) == allKeys.get(0) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(1) == allKeys.get(2) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
        Assert.assertTrue((resolved.get(2) == allKeys.get(3) ? 1 : 0) != 0, (String)"Unexpected EncryptedKey instance found");
    }

    private List<EncryptedKey> generateList(EncryptedData encData, EncryptedKeyResolver ekResolver) {
        ArrayList<EncryptedKey> resolved = new ArrayList<EncryptedKey>();
        for (EncryptedKey encKey : ekResolver.resolve(encData)) {
            resolved.add(encKey);
        }
        return resolved;
    }
}

