/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl;

import java.security.KeyException;
import java.security.PublicKey;
import java.util.List;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.keyinfo.impl.BasicKeyInfoGeneratorFactory;
import org.opensaml.xmlsec.signature.DEREncodedKeyValue;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.KeyValue;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BasicKeyInfoGeneratorTest
extends XMLObjectBaseTestCase {
    private BasicCredential credential;
    private BasicKeyInfoGeneratorFactory factory;
    private KeyInfoGenerator generator;
    private String keyNameFoo = "FOO";
    private String keyNameBar = "BAR";
    private String entityID = "someEntityID";
    private PublicKey pubKey;
    private final String rsaBase64 = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzVp5BZoctb2GuoDf8QUSpGcRct7FKtldC7GG+kN6XvUJW+vgc2jOQ6zfLiKqq6ARN1qdC7a4CrkE6Q6TRQXUtqeWn4lLTmC1gQ7Ys0zs7N2d+jBjIyD1GEOLNNyD98j4drnehCqQz4mKszW5EWoiMJmEorea/kTGL3en7ir0zp+oez2SOQA+0XWu1VoeTlUqGV5Ucd6sRYaPpmYVtKuH1H04uZVsH+BIZHwZc4MP5OYH+HDouq6xqUUtc8Zm7V9UQIPiNtM+ndOINDdlrCubLbM4GCqCETiQol8I62mvP0qBXCC6JVkKbbVRwSFGJcg5ZvJiBZXmX+EXhaX5vp1GMQIDAQAB";

    @BeforeMethod
    protected void setUp() throws Exception {
        this.factory = new BasicKeyInfoGeneratorFactory();
        this.generator = null;
        this.pubKey = KeySupport.buildJavaRSAPublicKey((String)"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzVp5BZoctb2GuoDf8QUSpGcRct7FKtldC7GG+kN6XvUJW+vgc2jOQ6zfLiKqq6ARN1qdC7a4CrkE6Q6TRQXUtqeWn4lLTmC1gQ7Ys0zs7N2d+jBjIyD1GEOLNNyD98j4drnehCqQz4mKszW5EWoiMJmEorea/kTGL3en7ir0zp+oez2SOQA+0XWu1VoeTlUqGV5Ucd6sRYaPpmYVtKuH1H04uZVsH+BIZHwZc4MP5OYH+HDouq6xqUUtc8Zm7V9UQIPiNtM+ndOINDdlrCubLbM4GCqCETiQol8I62mvP0qBXCC6JVkKbbVRwSFGJcg5ZvJiBZXmX+EXhaX5vp1GMQIDAQAB");
        this.credential = new BasicCredential(this.pubKey);
        this.credential.setEntityId(this.entityID);
        this.credential.getKeyNames().add(this.keyNameFoo);
        this.credential.getKeyNames().add(this.keyNameBar);
    }

    @Test
    public void testNoOptions() throws SecurityException {
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        Assert.assertNull((Object)keyInfo, (String)"Generated KeyInfo with no options should have been null");
    }

    @Test
    public void testEmitPublicKey() throws SecurityException, KeyException {
        this.factory.setEmitPublicKeyValue(true);
        this.factory.setEmitPublicDEREncodedKeyValue(true);
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        Assert.assertNotNull((Object)keyInfo, (String)"Generated KeyInfo was null");
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren(), (String)"Generated KeyInfo children list was null");
        Assert.assertEquals((int)keyInfo.getOrderedChildren().size(), (int)2, (String)"Unexpected number of KeyInfo children");
        Assert.assertEquals((int)keyInfo.getKeyValues().size(), (int)1, (String)"Unexpected number of KeyValue elements");
        Assert.assertEquals((int)keyInfo.getDEREncodedKeyValues().size(), (int)1, (String)"Unexpected number of DEREncodedKeyValue elements");
        PublicKey generatedKey = KeyInfoSupport.getKey((KeyValue)((KeyValue)keyInfo.getKeyValues().get(0)));
        Assert.assertEquals((Object)generatedKey, (Object)this.pubKey, (String)"Unexpected key value");
        PublicKey generatedKey2 = KeyInfoSupport.getKey((DEREncodedKeyValue)((DEREncodedKeyValue)keyInfo.getDEREncodedKeyValues().get(0)));
        Assert.assertEquals((Object)this.pubKey, (Object)generatedKey2, (String)"Unexpected key value");
    }

    @Test
    public void testEmitKeynames() throws SecurityException {
        this.factory.setEmitKeyNames(true);
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        Assert.assertNotNull((Object)keyInfo, (String)"Generated KeyInfo was null");
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren(), (String)"Generated KeyInfo children list was null");
        Assert.assertEquals((int)keyInfo.getKeyNames().size(), (int)2, (String)"Unexpected number of KeyName elements");
        List keyNames = KeyInfoSupport.getKeyNames((KeyInfo)keyInfo);
        Assert.assertTrue((boolean)keyNames.contains(this.keyNameFoo), (String)"Failed to find expected KeyName value");
        Assert.assertTrue((boolean)keyNames.contains(this.keyNameBar), (String)"Failed to find expected KeyName value");
    }

    @Test
    public void testEmitEntityIDAsKeyName() throws SecurityException {
        this.factory.setEmitEntityIDAsKeyName(true);
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        Assert.assertNotNull((Object)keyInfo, (String)"Generated KeyInfo was null");
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren(), (String)"Generated KeyInfo children list was null");
        Assert.assertEquals((int)keyInfo.getKeyNames().size(), (int)1, (String)"Unexpected number of KeyName elements");
        List keyNames = KeyInfoSupport.getKeyNames((KeyInfo)keyInfo);
        Assert.assertTrue((boolean)keyNames.contains(this.entityID), (String)"Failed to find expected KeyName value");
    }

    @Test
    public void testProperOptionsCloning() throws SecurityException {
        this.generator = this.factory.newInstance();
        KeyInfo keyInfo = this.generator.generate((Credential)this.credential);
        Assert.assertNull((Object)keyInfo, (String)"Generated KeyInfo was null");
        this.factory.setEmitKeyNames(true);
        this.factory.setEmitEntityIDAsKeyName(true);
        this.factory.setEmitPublicKeyValue(true);
        this.factory.setEmitPublicDEREncodedKeyValue(true);
        keyInfo = this.generator.generate((Credential)this.credential);
        Assert.assertNull((Object)keyInfo, (String)"Generated KeyInfo was null");
        this.generator = this.factory.newInstance();
        keyInfo = this.generator.generate((Credential)this.credential);
        Assert.assertNotNull((Object)keyInfo, (String)"Generated KeyInfo was null");
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren(), (String)"Generated KeyInfo children list was null");
        Assert.assertEquals((int)keyInfo.getOrderedChildren().size(), (int)5, (String)"Unexpected # of KeyInfo children found");
    }
}

