/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl;

import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.X509Support;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCriterion;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CertChainX509DataTest
extends XMLObjectBaseTestCase {
    private KeyInfoCredentialResolver resolver;
    private RSAPublicKey pubKey;
    private final String rsaBase64 = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzVp5BZoctb2GuoDf8QUSpGcRct7FKtldC7GG+kN6XvUJW+vgc2jOQ6zfLiKqq6ARN1qdC7a4CrkE6Q6TRQXUtqeWn4lLTmC1gQ7Ys0zs7N2d+jBjIyD1GEOLNNyD98j4drnehCqQz4mKszW5EWoiMJmEorea/kTGL3en7ir0zp+oez2SOQA+0XWu1VoeTlUqGV5Ucd6sRYaPpmYVtKuH1H04uZVsH+BIZHwZc4MP5OYH+HDouq6xqUUtc8Zm7V9UQIPiNtM+ndOINDdlrCubLbM4GCqCETiQol8I62mvP0qBXCC6JVkKbbVRwSFGJcg5ZvJiBZXmX+EXhaX5vp1GMQIDAQAB";
    private X509Certificate entityCert;
    private String entityCertBase64 = "MIIDjDCCAnSgAwIBAgIBKjANBgkqhkiG9w0BAQUFADAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnMB4XDTA3MDQwOTA2MTIwOVoXDTE3MDQwNjA2MTIwOVowMTESMBAGA1UEChMJSW50ZXJuZXQyMRswGQYDVQQDExJmb29iYXIuZXhhbXBsZS5vcmcwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDNWnkFmhy1vYa6gN/xBRKkZxFy3sUq2V0LsYb6Q3pe9Qlb6+BzaM5DrN8uIqqroBE3Wp0LtrgKuQTpDpNFBdS2p5afiUtOYLWBDtizTOzs3Z36MGMjIPUYQ4s03IP3yPh2ud6EKpDPiYqzNbkRaiIwmYSit5r+RMYvd6fuKvTOn6h7PZI5AD7Rda7VWh5OVSoZXlRx3qxFho+mZhW0q4fUfTi5lWwf4EhkfBlzgw/k5gf4cOi6rrGpRS1zxmbtX1RAg+I20z6d04g0N2WsK5stszgYKoIROJCiXwjraa8/SoFcILolWQpttVHBIUYlyDlm8mIFleZf4ReFpfm+nUYxAgMBAAGjgbIwga8wCQYDVR0TBAIwADAsBglghkgBhvhCAQ0EHxYdT3BlblNTTCBHZW5lcmF0ZWQgQ2VydGlmaWNhdGUwHQYDVR0OBBYEFDgRgTkjaKoK6DoZfUZ4g9LDJUWuMFUGA1UdIwROMEyAFNXuZVPeUdqHrULqQW7yr9buRpQLoTGkLzAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnggEBMA0GCSqGSIb3DQEBBQUAA4IBAQCPj3Si4Eiw9abNgPBUhBXWd6eRYlIHaHcnez6j6g7foAOyuVIUso9Q5c6pvL87lmasK55l09YPXw1qmiH+bHMcrwEPODpLx7xd3snlOCi7FyxahxwSs8yfTu8Pq95rWt0LNcfHxQK938Cpnav6jgDo2uH/ywAOFFSnoBzGHAfScHMfj8asZ6THosYsklII7FSU8j49GV2utkvGB3mcu4STuLdeRCZmi93vq1D4JVGsXC4UaHjg114+a+9q0XZdz6a1UW4pt1ryXIPotCS62M71pkJf5neHUinKAqgoRfPXowudZg1Zl8DjzoOBn+MNHRrR5KYbVGvdHcxoJLCwVB/v";
    private String entityCertSKIBase64 = "OBGBOSNoqgroOhl9RniD0sMlRa4=";
    private String entityCertDigestBase64 = "xSZMa2KvZfsOQzv86Ho/5VmwY4E=";
    private X509Certificate caCert;
    private String caCertBase64 = "MIIDXTCCAkWgAwIBAgIBATANBgkqhkiG9w0BAQUFADAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnMB4XDTA3MDQwOTA1NDcxMloXDTE3MDQwNjA1NDcxMlowLTESMBAGA1UEChMJSW50ZXJuZXQyMRcwFQYDVQQDEw5jYS5leGFtcGxlLm9yZzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANxM5/6mBCcX+S7HApcKtfqdFRZzi6Ra91nkEzXOUcO+BPUdYqSxKGnCCso25ZOZP3gnJVkY8Pi7VWrCM6wRgIMyQDvNYqCpNjkZGFkrMoa6fm8BSaDHJ1fz6l/eEl0CVU3UuUAf0mXQLGm6Jannq8aMolRujlhE5iRaOJ2qp6wqsvyatK+vTgDngnwYVa4Cqu0jUeNF28quST5D3gIuZ0OeFHSM2Z1WUKkwwsHqVkxBBcH1QE1JOGIoSnrxxl/o4VlLWGEI8zq5qixE8VYtBBmijBwIL5ETy2fwiqcsvimQaQAtAfbtpO3kBSs8n7nnzMUHfRlcebGkwwcNfYcD5hcCAwEAAaOBhzCBhDAdBgNVHQ4EFgQU1e5lU95R2oetQupBbvKv1u5GlAswVQYDVR0jBE4wTIAU1e5lU95R2oetQupBbvKv1u5GlAuhMaQvMC0xEjAQBgNVBAoTCUludGVybmV0MjEXMBUGA1UEAxMOY2EuZXhhbXBsZS5vcmeCAQEwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEAbqrozetM/iBVIUir9k14HbLEP0lZ6jOPWFIUFXMOn0t8+Ul7PMp9Rdn+7OGQIoJw97/mam3kpQ/HmjJMFYv6MGsDQ4vAOiQiaTKzgMhrnCdVpVH9uz4ARHiysCujnjH9sehTWgybY8pXzzSG5BAjEGowHq01nXxq2K4yAJSdAUBYLfuSKW1uRU6cmEa9uzl9EvoZfAF3BLnGlPqu4ZajH2NC9ZY0y19LX4yeJLHL1sY4fyxb3x8QhcCXiI16awBTr/VnUpJjSe9vh+OudWGeyCL/KhjlrDkjJ3hIxBF5mP/Y27cFpRnC2gECkieURvh52OyuqkzpbOrTN5rD9fNinA==";

    @BeforeMethod
    protected void setUp() throws Exception {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new InlineX509DataProvider());
        providers.add(new RSAKeyValueProvider());
        this.resolver = new BasicProviderKeyInfoCredentialResolver(providers);
        this.pubKey = KeySupport.buildJavaRSAPublicKey((String)"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzVp5BZoctb2GuoDf8QUSpGcRct7FKtldC7GG+kN6XvUJW+vgc2jOQ6zfLiKqq6ARN1qdC7a4CrkE6Q6TRQXUtqeWn4lLTmC1gQ7Ys0zs7N2d+jBjIyD1GEOLNNyD98j4drnehCqQz4mKszW5EWoiMJmEorea/kTGL3en7ir0zp+oez2SOQA+0XWu1VoeTlUqGV5Ucd6sRYaPpmYVtKuH1H04uZVsH+BIZHwZc4MP5OYH+HDouq6xqUUtc8Zm7V9UQIPiNtM+ndOINDdlrCubLbM4GCqCETiQol8I62mvP0qBXCC6JVkKbbVRwSFGJcg5ZvJiBZXmX+EXhaX5vp1GMQIDAQAB");
        this.entityCert = X509Support.decodeCertificate((String)this.entityCertBase64);
        this.caCert = X509Support.decodeCertificate((String)this.caCertBase64);
        new X500Principal("cn=foobar.example.org, O=Internet2");
        new X500Principal("cn=ca.example.org, O=Internet2");
        Base64Support.decode((String)this.entityCertSKIBase64);
        Base64Support.decode((String)this.entityCertDigestBase64);
    }

    protected void evalCredential(Credential credential) {
        Assert.assertNotNull((Object)credential, (String)"Credential was null");
        Assert.assertTrue((boolean)(credential instanceof X509Credential), (String)"Credential is not of the expected type");
        X509Credential x509Credential = (X509Credential)credential;
        Assert.assertNotNull((Object)x509Credential.getPublicKey(), (String)"Public key was null");
        Assert.assertEquals((Object)this.pubKey, (Object)x509Credential.getPublicKey(), (String)"Expected public key value not found");
        Assert.assertEquals((int)x509Credential.getKeyNames().size(), (int)2, (String)"Wrong number of key names");
        Assert.assertTrue((boolean)x509Credential.getKeyNames().contains("Foo"), (String)"Expected key name value not found");
        Assert.assertTrue((boolean)x509Credential.getKeyNames().contains("Bar"), (String)"Expected key name value not found");
        Assert.assertNotNull((Object)x509Credential.getEntityCertificate(), (String)"Entity certificate was null");
        Assert.assertEquals((Object)this.entityCert, (Object)x509Credential.getEntityCertificate(), (String)"Expected X509Certificate value not found");
        Assert.assertEquals((int)x509Credential.getEntityCertificateChain().size(), (int)2, (String)"Wrong number of certs in cert chain found");
        Assert.assertTrue((boolean)x509Credential.getEntityCertificateChain().contains(this.entityCert), (String)"Cert not found in cert chain");
        Assert.assertTrue((boolean)x509Credential.getEntityCertificateChain().contains(this.caCert), (String)"Cert not found in cert chain");
    }

    @Test
    public void testResolutionWithKeyValue() throws SecurityException, ResolverException {
        KeyInfo keyInfo = (KeyInfo)this.unmarshallElement("/org/opensaml/xmlsec/keyinfo/impl/X509CertificatesWithKeyValue.xml");
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new KeyInfoCriterion(keyInfo)});
        Iterator iter = this.resolver.resolve((Object)criteriaSet).iterator();
        Assert.assertTrue((boolean)iter.hasNext(), (String)"No credentials were found");
        Credential credential = (Credential)iter.next();
        Assert.assertNotNull((Object)credential, (String)"Credential was null");
        Assert.assertFalse((boolean)iter.hasNext(), (String)"Too many credentials returned");
        this.evalCredential(credential);
    }

    @Test
    public void testResolutionWithSubjectName() throws SecurityException, ResolverException {
        KeyInfo keyInfo = (KeyInfo)this.unmarshallElement("/org/opensaml/xmlsec/keyinfo/impl/X509CertificatesWithSubjectName.xml");
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new KeyInfoCriterion(keyInfo)});
        Iterator iter = this.resolver.resolve((Object)criteriaSet).iterator();
        Assert.assertTrue((boolean)iter.hasNext(), (String)"No credentials were found");
        Credential credential = (Credential)iter.next();
        Assert.assertNotNull((Object)credential, (String)"Credential was null");
        Assert.assertFalse((boolean)iter.hasNext(), (String)"Too many credentials returned");
        this.evalCredential(credential);
    }

    @Test
    public void testResolutionWithIssuerSerial() throws SecurityException, ResolverException {
        KeyInfo keyInfo = (KeyInfo)this.unmarshallElement("/org/opensaml/xmlsec/keyinfo/impl/X509CertificatesWithIssuerSerial.xml");
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new KeyInfoCriterion(keyInfo)});
        Iterator iter = this.resolver.resolve((Object)criteriaSet).iterator();
        Assert.assertTrue((boolean)iter.hasNext(), (String)"No credentials were found");
        Credential credential = (Credential)iter.next();
        Assert.assertNotNull((Object)credential, (String)"Credential was null");
        Assert.assertFalse((boolean)iter.hasNext(), (String)"Too many credentials returned");
        this.evalCredential(credential);
    }

    @Test
    public void testResolutionWithSubjectKeyIdentifier() throws SecurityException, ResolverException {
        KeyInfo keyInfo = (KeyInfo)this.unmarshallElement("/org/opensaml/xmlsec/keyinfo/impl/X509CertificatesWithSKI.xml");
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new KeyInfoCriterion(keyInfo)});
        Iterator iter = this.resolver.resolve((Object)criteriaSet).iterator();
        Assert.assertTrue((boolean)iter.hasNext(), (String)"No credentials were found");
        Credential credential = (Credential)iter.next();
        Assert.assertNotNull((Object)credential, (String)"Credential was null");
        Assert.assertFalse((boolean)iter.hasNext(), (String)"Too many credentials returned");
        this.evalCredential(credential);
    }

    @Test
    public void testResolutionWithDigest() throws SecurityException, ResolverException {
        KeyInfo keyInfo = (KeyInfo)this.unmarshallElement("/org/opensaml/xmlsec/keyinfo/impl/X509CertificatesWithDigest.xml");
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new KeyInfoCriterion(keyInfo)});
        Iterator iter = this.resolver.resolve((Object)criteriaSet).iterator();
        Assert.assertTrue((boolean)iter.hasNext(), (String)"No credentials were found");
        Credential credential = (Credential)iter.next();
        Assert.assertNotNull((Object)credential, (String)"Credential was null");
        Assert.assertFalse((boolean)iter.hasNext(), (String)"Too many credentials returned");
        this.evalCredential(credential);
    }
}

