/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xmlsec.signature.Transform;
import org.opensaml.xmlsec.signature.Transforms;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TransformsTest
extends XMLObjectProviderBaseTestCase {
    private int expectedNumTransforms;

    public TransformsTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/signature/impl/Transforms.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/signature/impl/TransformsChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedNumTransforms = 2;
    }

    @Test
    public void testSingleElementUnmarshall() {
        Transforms em = (Transforms)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)em, (String)"Transforms");
        Assert.assertEquals((int)em.getTransforms().size(), (int)0, (String)"Transform children");
    }

    @Test
    public void testChildElementsUnmarshall() {
        Transforms em = (Transforms)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)em, (String)"Transforms");
        Assert.assertEquals((int)em.getTransforms().size(), (int)this.expectedNumTransforms, (String)"Transform children");
    }

    @Test
    public void testSingleElementMarshall() {
        Transforms em = (Transforms)this.buildXMLObject(Transforms.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)em);
    }

    @Test
    public void testChildElementsMarshall() {
        Transforms em = (Transforms)this.buildXMLObject(Transforms.DEFAULT_ELEMENT_NAME);
        em.getTransforms().add((Transform)this.buildXMLObject(Transform.DEFAULT_ELEMENT_NAME));
        em.getTransforms().add((Transform)this.buildXMLObject(Transform.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)em);
    }
}

