/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.data.IODirection;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.JICurrency;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.openscada.opc.dcom.common.KeyedResult;
import org.openscada.opc.dcom.da.OPCITEMDEF;
import org.openscada.opc.dcom.da.OPCITEMRESULT;
import org.openscada.opc.lib.da.browser.Access;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helper {
    private static final Logger logger = LoggerFactory.getLogger(Helper.class);

    public static Variant theirs2ours(JIVariant variant) {
        try {
            switch (variant.getType()) {
                case 11: {
                    return Variant.valueOf((boolean)variant.getObjectAsBoolean());
                }
                case 0: {
                    return Variant.NULL;
                }
                case 1: {
                    return Variant.NULL;
                }
                case 16: {
                    return Variant.valueOf((int)((Character)variant.getObject()).charValue());
                }
                case 2: {
                    return Variant.valueOf((int)variant.getObjectAsShort());
                }
                case 3: {
                    return Variant.valueOf((int)variant.getObjectAsInt());
                }
                case 22: {
                    return Variant.valueOf((int)variant.getObjectAsInt());
                }
                case 20: {
                    return Variant.valueOf((long)variant.getObjectAsLong());
                }
                case 4: {
                    return Variant.valueOf((double)variant.getObjectAsFloat());
                }
                case 5: {
                    return Variant.valueOf((double)variant.getObjectAsDouble());
                }
                case 8: {
                    JIString str = variant.getObjectAsString();
                    if (str != null) {
                        return Variant.valueOf((Object)str.getString());
                    }
                    return Variant.valueOf((Object)"");
                }
                case 17: {
                    return Variant.valueOf((int)variant.getObjectAsUnsigned().getValue().byteValue());
                }
                case 18: {
                    return Variant.valueOf((int)variant.getObjectAsUnsigned().getValue().shortValue());
                }
                case 19: {
                    return Variant.valueOf((int)variant.getObjectAsUnsigned().getValue().intValue());
                }
                case 23: {
                    return Variant.valueOf((int)variant.getObjectAsUnsigned().getValue().intValue());
                }
                case 12: {
                    return Helper.theirs2ours(variant.getObjectAsVariant());
                }
                case 7: {
                    return Variant.valueOf((long)variant.getObjectAsDate().getTime());
                }
                case 6: {
                    JICurrency c = (JICurrency)variant.getObject();
                    return Variant.valueOf((long)(((long)c.getUnits() << 32 | (long)c.getFractionalUnits()) / 10000L));
                }
            }
            return null;
        }
        catch (JIException e) {
            logger.warn("Failed to convert", (Throwable)e);
            return null;
        }
    }

    public static JIVariant ours2theirs(Variant value) {
        block8: {
            try {
                if (!value.isNull()) break block8;
                return null;
            }
            catch (Exception e) {
                logger.warn("Unable to convert write value", (Throwable)e);
                return null;
            }
        }
        if (value.isBoolean()) {
            return new JIVariant(value.asBoolean());
        }
        if (value.isDouble()) {
            return new JIVariant(value.asDouble());
        }
        if (value.isInteger()) {
            return new JIVariant(value.asInteger());
        }
        if (value.isLong()) {
            return new JIVariant((float)value.asLong());
        }
        if (value.isString()) {
            return new JIVariant(new JIString(value.asString()));
        }
        return null;
    }

    public static EnumSet<IODirection> convertToAccessSet(int value) {
        EnumSet<IODirection> set = EnumSet.noneOf(IODirection.class);
        if ((value & Access.READ.getCode()) > 0) {
            set.add(IODirection.INPUT);
        }
        if ((value & Access.WRITE.getCode()) > 0) {
            set.add(IODirection.OUTPUT);
        }
        return set;
    }

    public static Map<String, Variant> convertToAttributes(KeyedResult<OPCITEMDEF, OPCITEMRESULT> entry) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(4);
        if (entry.getErrorCode() != 0) {
            attributes.put("opc.add.error", Variant.TRUE);
            attributes.put("opc.add.code", Variant.valueOf((int)entry.getErrorCode()));
            attributes.put("opc.add.message", Variant.valueOf((Object)String.format("0x%08x", entry.getErrorCode())));
        }
        return attributes;
    }

    public static Map<String, Variant> convertToAttributes(OPCITEMDEF def) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(4);
        attributes.put("opc.itemId", Variant.valueOf((Object)def.getItemID()));
        attributes.put("opc.clientHandle", Variant.valueOf((int)def.getClientHandle()));
        if (def.getAccessPath() != null) {
            attributes.put("opc.accessPath", Variant.valueOf((Object)def.getAccessPath()));
        }
        return attributes;
    }

    public static Map<String, Variant> convertToAttributes(OPCITEMRESULT result) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(4);
        attributes.put("opc.serverHandle", Variant.valueOf((int)result.getServerHandle()));
        attributes.put("opc.dataType", Variant.valueOf((int)result.getCanonicalDataType()));
        attributes.put("opc.accessRights", Variant.valueOf((int)result.getAccessRights()));
        attributes.put("opc.accessRights.string", Variant.valueOf((Object)Helper.convertToAccessSet(result.getAccessRights()).toString()));
        return attributes;
    }

    public static Map<String, Variant> clearAttributes() {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(16);
        attributes.put("opc.serverHandle", null);
        attributes.put("opc.dataType", null);
        attributes.put("opc.accessRights", null);
        attributes.put("opc.accessRights.string", null);
        attributes.put("opc.accessPath", null);
        attributes.put("opc.clientHandle", null);
        attributes.put("opc.add.error", null);
        attributes.put("opc.add.code", null);
        attributes.put("opc.add.message", null);
        return attributes;
    }
}

