/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.ValidationStrategy;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.jinterop.dcom.common.JISystem;
import org.openscada.da.opc.configuration.ConfigurationPackage;
import org.openscada.da.opc.configuration.RootType;
import org.openscada.da.opc.configuration.util.ConfigurationResourceFactoryImpl;
import org.openscada.da.server.opc.configuration.XMLConfigurator;
import org.openscada.da.server.opc.connection.OPCConnection;
import org.openscada.da.server.opc.connection.data.ConnectionSetup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hive
extends HiveCommon {
    private static final Logger logger = LoggerFactory.getLogger(Hive.class);
    private final Collection<OPCConnection> connections = new CopyOnWriteArrayList<OPCConnection>();
    private final FolderCommon rootFolder = new FolderCommon();
    private final XMLConfigurator configurator;

    public Hive() throws IOException {
        this(new XMLConfigurator(Hive.parse(URI.createFileURI((String)System.getProperty("org.openscada.da.server.opc.defaultConfigurationFile", "configuration.xml")))));
    }

    public Hive(String uri) throws IOException {
        this(new XMLConfigurator(Hive.parse(URI.createURI((String)uri))));
    }

    public Hive(RootType root) {
        this(new XMLConfigurator(root));
    }

    public Hive(XMLConfigurator configurator) {
        this.initJInterop();
        this.setValidatonStrategy(ValidationStrategy.GRANT_ALL);
        this.setRootFolder((Folder)this.rootFolder);
        this.configurator = configurator;
    }

    protected void performStart() throws Exception {
        super.performStart();
        this.configurator.configure(this);
    }

    protected void performStop() throws Exception {
        for (OPCConnection connection : this.connections) {
            try {
                connection.dispose();
            }
            catch (Exception e) {
                logger.warn("Failed to clean up connection", (Throwable)e);
            }
        }
        super.performStop();
    }

    private static RootType parse(URI uri) throws IOException {
        ConfigurationPackage.eINSTANCE.eClass();
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ConfigurationResourceFactoryImpl());
        Resource r = rs.createResource(uri);
        r.load(null);
        return (RootType)EcoreUtil.getObjectByType((Collection)r.getContents(), (EClassifier)ConfigurationPackage.Literals.ROOT_TYPE);
    }

    public String getHiveId() {
        return "org.openscada.da.server.opc";
    }

    private void initJInterop() {
        logger.warn("rpc.socketTimeout = {}", (Object)System.getProperty("rpc.socketTimeout"));
        if (!Boolean.getBoolean("dcom.debug")) {
            java.util.logging.Logger.getLogger("org.jinterop").setLevel(Level.WARNING);
        }
        JISystem.setJavaCoClassAutoCollection((!Boolean.getBoolean("dcom.disableAutoCollection") ? 1 : 0) != 0);
        logger.info("DCOM auto collection: {}", (Object)JISystem.isJavaCoClassAutoCollectionSet());
    }

    public void addConnection(ConnectionSetup setup, boolean connect) {
        OPCConnection connection = new OPCConnection(this, this.rootFolder, setup);
        if (this.connections.add(connection)) {
            connection.start();
            if (connect) {
                connection.connect();
            }
        }
    }

    public void removeConnection(OPCConnection connection) {
        if (this.connections.remove(connection)) {
            connection.dispose();
        }
    }
}

