/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.browser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scada.utils.beans.AbstractPropertyChange;
import org.openscada.da.server.opc.Hive;
import org.openscada.da.server.opc.browser.BrowseRequest;
import org.openscada.da.server.opc.browser.BrowseRequestListener;
import org.openscada.da.server.opc.browser.BrowseResult;
import org.openscada.da.server.opc.connection.OPCModel;
import org.openscada.da.server.opc.connection.data.ConnectionSetup;
import org.openscada.da.server.opc.job.Job;
import org.openscada.da.server.opc.job.Worker;
import org.openscada.da.server.opc.job.impl.BrowseJob;

public class OPCBrowserManager
extends AbstractPropertyChange {
    private static final String PROP_ACTIVE_REQUESTS = "activeRequests";
    private static final String PROP_QUEUED_REQUESTS = "queuedRequests";
    private final Worker worker;
    private final OPCModel model;
    private final List<Request> requests = new LinkedList<Request>();
    private int activeRequests = 0;
    private int queuedRequests = 0;

    public OPCBrowserManager(Worker worker, ConnectionSetup configuration, OPCModel model, Hive hive) {
        this.worker = worker;
        this.model = model;
    }

    public int getQueuedRequests() {
        return this.queuedRequests;
    }

    protected void setQueuedRequests(int queuedRequests) {
        int oldQueuedRequests = this.queuedRequests;
        this.queuedRequests = queuedRequests;
        this.firePropertyChange(PROP_QUEUED_REQUESTS, oldQueuedRequests, queuedRequests);
    }

    public int getActiveRequests() {
        return this.activeRequests;
    }

    protected void setActiveRequests(int activeRequests) {
        int oldActiveRequests = this.activeRequests;
        this.activeRequests = activeRequests;
        this.firePropertyChange(PROP_ACTIVE_REQUESTS, oldActiveRequests, activeRequests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performBrowse() throws Throwable {
        ArrayList<Request> currentRequests;
        List<Request> list = this.requests;
        synchronized (list) {
            currentRequests = new ArrayList<Request>(this.requests);
            this.requests.clear();
            this.setQueuedRequests(0);
        }
        if (!currentRequests.isEmpty()) {
            int len = currentRequests.size();
            for (Request request : currentRequests) {
                this.setActiveRequests(len--);
                this.processRequest(request);
            }
            this.setActiveRequests(0);
        }
    }

    private void processRequest(Request request) throws Throwable {
        BrowseJob job = new BrowseJob(this.model.getDefaultTimeout(), this.model, request.request);
        try {
            BrowseResult result = this.worker.execute((Job)job, job);
            request.listener.browseComplete(result);
        }
        catch (Throwable e) {
            request.listener.browseError(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBrowseRequest(BrowseRequest request, BrowseRequestListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener must not be null");
        }
        if (!this.model.isConnected()) {
            listener.browseError(new RuntimeException("OPC is not connected").fillInStackTrace());
            return;
        }
        List<Request> list = this.requests;
        synchronized (list) {
            this.requests.add(new Request(request, listener));
            this.setQueuedRequests(this.requests.size());
        }
    }

    private static class Request {
        private final BrowseRequest request;
        private final BrowseRequestListener listener;

        public Request(BrowseRequest request, BrowseRequestListener listener) {
            this.request = request;
            this.listener = listener;
        }
    }
}

