/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.browser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Stack;
import org.eclipse.scada.da.core.browser.Entry;
import org.eclipse.scada.da.core.server.browser.NoSuchFolderException;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.browser.common.FolderListener;
import org.eclipse.scada.da.server.common.DataItemInformationBase;
import org.eclipse.scada.utils.str.StringHelper;
import org.openscada.da.server.opc.browser.BrowseRequest;
import org.openscada.da.server.opc.browser.BrowseRequestListener;
import org.openscada.da.server.opc.browser.BrowseResult;
import org.openscada.da.server.opc.browser.BrowseResultEntry;
import org.openscada.da.server.opc.connection.OPCController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OPCTreeFolder
implements Folder,
BrowseRequestListener {
    private static final Logger logger = LoggerFactory.getLogger(OPCTreeFolder.class);
    protected FolderCommon folderImpl = new FolderCommon();
    protected boolean refreshed = false;
    private final OPCController controller;
    private Collection<String> path = new ArrayList<String>();

    public OPCTreeFolder(OPCController controller, Collection<String> path) {
        this.controller = controller;
        this.path = path;
    }

    public void added() {
        this.folderImpl.added();
    }

    public Entry[] list(Stack<String> path) throws NoSuchFolderException {
        return this.folderImpl.list(path);
    }

    public void removed() {
        this.folderImpl.removed();
    }

    public void subscribe(Stack<String> path, FolderListener listener, Object tag) throws NoSuchFolderException {
        this.checkRefresh();
        this.folderImpl.subscribe(path, listener, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkRefresh() {
        OPCTreeFolder oPCTreeFolder = this;
        synchronized (oPCTreeFolder) {
            if (this.refreshed) {
                return;
            }
            logger.info("Need to refresh folder ({})", (Object)this.getPath());
            this.refreshed = true;
        }
        this.refresh();
    }

    private void refresh() {
        this.controller.getBrowserManager().addBrowseRequest(new BrowseRequest(this.path), this);
    }

    public void unsubscribe(Stack<String> path, Object tag) throws NoSuchFolderException {
        try {
            this.folderImpl.unsubscribe(path, tag);
        }
        finally {
            this.checkCleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCleanUp() {
        OPCTreeFolder oPCTreeFolder = this;
        synchronized (oPCTreeFolder) {
            if (!this.folderImpl.hasSubscribers() && this.refreshed) {
                logger.info("No more subscribers. Clearing folder. ({})", (Object)this.getPath());
                this.refreshed = false;
                this.folderImpl.clear();
            }
        }
    }

    @Override
    public void browseComplete(BrowseResult result) {
        HashMap<String, OPCTreeFolder> folders = new HashMap<String, OPCTreeFolder>();
        HashMap<String, DataItemInformationBase> items = new HashMap<String, DataItemInformationBase>();
        for (String branch : result.getBranches()) {
            ArrayList<String> path = new ArrayList<String>(this.path);
            path.add(branch);
            folders.put(branch, new OPCTreeFolder(this.controller, path));
        }
        for (BrowseResultEntry entry : result.getLeaves()) {
            String itemId = this.controller.getItemManager().createItemId(entry.getItemId());
            DataItemInformationBase itemInformation = new DataItemInformationBase(itemId, entry.getIoDirections());
            items.put(entry.getEntryName(), itemInformation);
        }
        this.folderImpl.add(folders, items);
    }

    @Override
    public void browseError(Throwable error) {
        logger.info("Failed to browse", error);
    }

    protected String getPath() {
        return StringHelper.join(this.path, (String)"/");
    }
}

