/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.configuration;

import org.openscada.da.opc.configuration.ConfigurationType;
import org.openscada.da.opc.configuration.RootType;
import org.openscada.da.server.opc.Hive;
import org.openscada.da.server.opc.connection.data.AccessMethod;
import org.openscada.da.server.opc.connection.data.ConnectionSetup;
import org.openscada.opc.lib.common.ConnectionInformation;

public class XMLConfigurator {
    private static final int DEFAULT_RECONNECT_DELAY = 5000;
    private final RootType root;

    public XMLConfigurator(RootType root) {
        this.root = root;
    }

    public void configure(Hive hive) {
        for (ConfigurationType configuration : this.root.getConnections().getConfiguration()) {
            String access;
            if (!configuration.isEnabled()) continue;
            ConnectionInformation ci = new ConnectionInformation();
            ci.setUser(configuration.getUser());
            ci.setPassword(configuration.getPassword());
            ci.setDomain(configuration.getDomain());
            ci.setHost(configuration.getHost());
            ci.setClsid(configuration.getClsid());
            ci.setProgId(configuration.getProgid());
            ConnectionSetup setup = new ConnectionSetup(ci);
            if (configuration.isSetIgnoreTimestampOnlyChange()) {
                setup.setIgnoreTimestampOnlyChange(configuration.isIgnoreTimestampOnlyChange());
            }
            if (configuration.isSetReconnectDelay()) {
                setup.setReconnectDelay(configuration.getReconnectDelay());
            } else {
                setup.setReconnectDelay(5000);
            }
            if (configuration.isSetQualityErrorIfLessThen()) {
                setup.setQualityErrorIfLessThen(Integer.valueOf(configuration.getQualityErrorIfLessThen()).shortValue());
            }
            if ((access = configuration.getAccess()).equalsIgnoreCase("sync")) {
                setup.setAccessMethod(AccessMethod.SYNC);
            } else if (access.equalsIgnoreCase("async")) {
                setup.setAccessMethod(AccessMethod.ASYNC20);
            } else if (access.equalsIgnoreCase("async20")) {
                setup.setAccessMethod(AccessMethod.ASYNC20);
            }
            setup.setFlatBrowser(configuration.isFlatBrowser());
            setup.setTreeBrowser(configuration.isTreeBrowser());
            setup.setUpdateRate(configuration.getRefresh());
            setup.setInitialConnect(configuration.isInitialRefresh());
            setup.setDeviceTag(configuration.getAlias());
            setup.setItemIdPrefix(configuration.getItemIdPrefix());
            if (setup.getDeviceTag() == null) {
                setup.setDeviceTag(String.valueOf(setup.getConnectionInformation().getHost()) + ":" + setup.getConnectionInformation().getClsOrProgId());
            }
            hive.addConnection(setup, configuration.isConnected());
        }
    }
}

