/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.connection;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.eclipse.scada.utils.concurrent.FutureTask;
import org.openscada.da.server.opc.connection.OPCController;
import org.openscada.da.server.opc.connection.OPCIoManager;
import org.openscada.da.server.opc.connection.OPCModel;
import org.openscada.da.server.opc.connection.OPCWriteRequest;
import org.openscada.da.server.opc.job.Job;
import org.openscada.da.server.opc.job.Worker;
import org.openscada.da.server.opc.job.impl.AttachGroupJob;
import org.openscada.da.server.opc.job.impl.DetachGroupJob;
import org.openscada.da.server.opc.job.impl.SyncWriteJob;
import org.openscada.opc.dcom.common.EventHandler;
import org.openscada.opc.dcom.common.KeyedResultSet;
import org.openscada.opc.dcom.common.Result;
import org.openscada.opc.dcom.common.ResultSet;
import org.openscada.opc.dcom.da.IOPCDataCallback;
import org.openscada.opc.dcom.da.OPCDATASOURCE;
import org.openscada.opc.dcom.da.ValueData;
import org.openscada.opc.dcom.da.WriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OPCAsync2IoManager
extends OPCIoManager
implements IOPCDataCallback {
    private static final Logger logger = LoggerFactory.getLogger(OPCAsync2IoManager.class);
    private EventHandler eventHandler;
    private final Queue<KeyedResultSet<Integer, ValueData>> incomingChanges = new LinkedList<KeyedResultSet<Integer, ValueData>>();

    public OPCAsync2IoManager(Worker worker, OPCModel model, OPCController controller) {
        super(worker, model, controller);
    }

    @Override
    public void handleConnected() throws InvocationTargetException {
        super.handleConnected();
        AttachGroupJob job = new AttachGroupJob(this.model.getConnectJobTimeout(), this.model, this);
        this.eventHandler = this.worker.execute((Job)job, job);
    }

    @Override
    public void handleDisconnected() {
        try {
            EventHandler eventHandler = this.eventHandler;
            this.eventHandler = null;
            if (eventHandler != null) {
                DetachGroupJob job = new DetachGroupJob(this.model.getConnectJobTimeout(), eventHandler);
                this.worker.execute((Job)job, new Runnable(){

                    @Override
                    public void run() {
                        logger.info("Group detached");
                    }
                });
            }
        }
        catch (Throwable e) {
            logger.warn("Failed to detach from group", e);
        }
        super.handleDisconnected();
    }

    public void cancelComplete(int transactionId, int serverGroupHandle) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataChange(int transactionId, int serverGroupHandle, int masterQuality, int masterErrorCode, KeyedResultSet<Integer, ValueData> result) {
        logger.info("dataChange - transactionId: {}, serverGroupHandle: {}, masterQuality: {}, masterErrorCode: {}, changes: {}", new Object[]{transactionId, serverGroupHandle, masterQuality, masterErrorCode, result.size()});
        if (!this.connected) {
            logger.warn("Incoming data change although disconnected");
            return;
        }
        OPCAsync2IoManager oPCAsync2IoManager = this;
        synchronized (oPCAsync2IoManager) {
            this.incomingChanges.add(result);
        }
        this.controller.submitJob(new Runnable(){

            @Override
            public void run() {
                try {
                    OPCAsync2IoManager.this.handleValueUpdates();
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Failed to handle value updates", e);
                }
            }
        });
    }

    public void readComplete(int transactionId, int serverGroupHandle, int masterQuality, int masterErrorCode, KeyedResultSet<Integer, ValueData> result) {
    }

    public void writeComplete(int transactionId, int serverGroupHandle, int masterErrorCode, ResultSet<Integer> result) {
    }

    @Override
    protected void performRead(Set<String> readSet, OPCDATASOURCE dataSource) throws InvocationTargetException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleValueUpdates() throws InvocationTargetException {
        ArrayList<KeyedResultSet<Integer, ValueData>> changes;
        OPCAsync2IoManager oPCAsync2IoManager = this;
        synchronized (oPCAsync2IoManager) {
            changes = new ArrayList<KeyedResultSet<Integer, ValueData>>(this.incomingChanges);
            this.incomingChanges.clear();
        }
        for (KeyedResultSet keyedResultSet : changes) {
            this.handleReadResult((KeyedResultSet<Integer, ValueData>)keyedResultSet, false);
        }
    }

    @Override
    protected FutureTask<Result<WriteRequest>> newWriteFuture(final OPCWriteRequest request) {
        return new FutureTask((Callable)new Callable<Result<WriteRequest>>(){

            @Override
            public Result<WriteRequest> call() throws Exception {
                Integer serverHandle = (Integer)OPCAsync2IoManager.this.serverHandleMap.get(request.getItemId());
                if (serverHandle == null) {
                    throw new RuntimeException(String.format("Item '%s' is not realized.", request.getItemId()));
                }
                SyncWriteJob job = new SyncWriteJob(OPCAsync2IoManager.this.model.getWriteJobTimeout(), OPCAsync2IoManager.this.model, new WriteRequest[]{new WriteRequest(serverHandle.intValue(), request.getValue())});
                Result result = (Result)OPCAsync2IoManager.this.worker.execute((Job)job, job).get(0);
                if (result != null) {
                    return result;
                }
                throw new RuntimeException("No connection to the OPC server");
            }
        });
    }

    @Override
    protected void performWriteRequests(Collection<FutureTask<Result<WriteRequest>>> requests) throws InvocationTargetException {
        for (FutureTask<Result<WriteRequest>> task : requests) {
            task.run();
            try {
                task.get();
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof InvocationTargetException)) continue;
                logger.warn("Re-throwing opc exception");
                throw (InvocationTargetException)e.getCause();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

