/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.connection;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.HashMap;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.DataItemCommand;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.chain.DataItemInputOutputChained;
import org.eclipse.scada.da.server.common.chain.WriteHandler;
import org.eclipse.scada.da.server.common.exporter.ObjectExporter;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.common.item.factory.FolderItemFactory;
import org.eclipse.scada.da.server.common.item.factory.ItemFactory;
import org.eclipse.scada.utils.collection.MapBuilder;
import org.jinterop.dcom.common.JIException;
import org.openscada.da.server.opc.Hive;
import org.openscada.da.server.opc.browser.OPCRootTreeFolder;
import org.openscada.da.server.opc.connection.OPCConnectionDataItemFactory;
import org.openscada.da.server.opc.connection.OPCController;
import org.openscada.da.server.opc.connection.data.ConnectionSetup;
import org.openscada.opc.dcom.da.OPCSERVERSTATUS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OPCConnection
implements PropertyChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(OPCConnection.class);
    private Hive hive;
    private final ConnectionSetup connectionSetup;
    private OPCController controller;
    private final FolderCommon rootFolder;
    private DataItemInputChained serverStateItem;
    private DataItemInputChained connectedItem;
    private DataItemInputChained connectingItem;
    private DataItemCommand connectDataItem;
    private DataItemCommand disconnectDataItem;
    private DataItemCommand suicideCommandDataItem;
    private DataItemInputOutputChained loopDelayDataItem;
    private DataItemInputChained lastConnectDataItem;
    private DataItemInputChained lastConnectionError;
    private DataItemInputChained numDisposersRunningDataItem;
    private DataItemInputChained controllerStateDataItem;
    private FolderItemFactory itemFactory;
    private FolderItemFactory connectionItemFactory;
    private final OPCConnectionDataItemFactory hiveItemFactory;
    private ObjectExporter modelExporter;
    private ObjectExporter ioManagerExporter;
    private ObjectExporter itemManagerExporter;
    private ObjectExporter browserManagerExporter;
    private ObjectExporter groupStateExporter;

    public OPCConnection(Hive hive, FolderCommon rootFolder, ConnectionSetup setup) {
        this.hive = hive;
        this.connectionSetup = setup;
        this.rootFolder = rootFolder;
        this.hiveItemFactory = new OPCConnectionDataItemFactory(this);
        this.hive.addItemFactory(this.hiveItemFactory);
    }

    protected String getDeviceTag() {
        return this.connectionSetup.getDeviceTag();
    }

    public synchronized void start() {
        if (this.controller != null) {
            throw new RuntimeException("OPC connection is already started");
        }
        this.itemFactory = new FolderItemFactory((HiveCommon)this.hive, this.rootFolder, this.getDeviceTag(), this.getDeviceTag());
        this.connectionItemFactory = this.itemFactory.createSubFolderFactory("connection");
        logger.info("User: {}", (Object)this.connectionSetup.getConnectionInformation().getUser());
        logger.info("Domain: {} ", (Object)this.connectionSetup.getConnectionInformation().getDomain());
        this.serverStateItem = this.connectionItemFactory.createInput("serverState", null);
        this.connectedItem = this.connectionItemFactory.createInput("connected", null);
        this.connectingItem = this.connectionItemFactory.createInput("connecting", null);
        this.lastConnectionError = this.connectionItemFactory.createInput("lastConnectionError", null);
        this.numDisposersRunningDataItem = this.connectionItemFactory.createInput("numDisposersRunning", null);
        this.controllerStateDataItem = this.connectionItemFactory.createInput("controllerStateDataItem", null);
        this.connectDataItem = this.connectionItemFactory.createCommand("connect", null);
        this.connectDataItem.addListener(new DataItemCommand.Listener(){

            public void command(Variant value) {
                OPCConnection.this.connect();
            }
        });
        this.disconnectDataItem = this.connectionItemFactory.createCommand("disconnect", null);
        this.disconnectDataItem.addListener(new DataItemCommand.Listener(){

            public void command(Variant value) {
                OPCConnection.this.disconnect();
            }
        });
        this.lastConnectDataItem = this.connectionItemFactory.createInput("lastConnect", null);
        this.loopDelayDataItem = this.connectionItemFactory.createInputOutput("loopDelay", null, new WriteHandler(){

            public void handleWrite(Variant value, OperationParameters operationParameters) throws Exception {
                OPCConnection.this.setLoopDelay(value);
            }
        });
        this.loopDelayDataItem = this.connectionItemFactory.createInputOutput("defaultTimeout", null, new WriteHandler(){

            public void handleWrite(Variant value, OperationParameters operationParameters) throws Exception {
                try {
                    OPCConnection.this.controller.getModel().setDefaultTimeout(value.asLong());
                }
                catch (Throwable e) {
                    logger.warn("Failed to set default timeout to: " + value, e);
                }
            }
        });
        this.suicideCommandDataItem = this.connectionItemFactory.createCommand("suicide", null);
        this.suicideCommandDataItem.addListener(new DataItemCommand.Listener(){

            public void command(Variant value) {
                OPCConnection.this.suicide();
            }
        });
        this.controller = new OPCController(this.connectionSetup, this.hive, this.itemFactory);
        this.controller.getModel().addPropertyChangeListener(this);
        this.controller.getModel().setReconnectDelay(this.connectionSetup.getReconnectDelay());
        Thread t = new Thread((Runnable)this.controller, "OPCController/" + this.getDeviceTag());
        t.setDaemon(true);
        t.start();
        this.updateBaseModel();
        this.updateLastConnect();
        this.loopDelayDataItem.updateData(Variant.valueOf((long)this.controller.getModel().getLoopDelay()), null, null);
        if (this.connectionSetup.isTreeBrowser()) {
            this.itemFactory.getFolder().add("tree", (Folder)new OPCRootTreeFolder(this.controller), new MapBuilder().getMap());
        }
        this.modelExporter = new ObjectExporter((ItemFactory)this.connectionItemFactory.createSubFolderFactory("model"));
        this.modelExporter.attachTarget((Object)this.controller.getModel());
        this.ioManagerExporter = new ObjectExporter((ItemFactory)this.connectionItemFactory.createSubFolderFactory("ioManager"));
        this.ioManagerExporter.attachTarget((Object)this.controller.getIoManager());
        this.itemManagerExporter = new ObjectExporter((ItemFactory)this.connectionItemFactory.createSubFolderFactory("itemManager"));
        this.itemManagerExporter.attachTarget((Object)this.controller.getItemManager());
        this.browserManagerExporter = new ObjectExporter((ItemFactory)this.connectionItemFactory.createSubFolderFactory("browserManager"));
        this.browserManagerExporter.attachTarget((Object)this.controller.getBrowserManager());
        this.groupStateExporter = new ObjectExporter((ItemFactory)this.connectionItemFactory.createSubFolderFactory("group"));
        this.groupStateExporter.attachTarget((Object)this.controller.getGroupState());
    }

    protected void setLoopDelay(Variant value) {
        try {
            long loopDelay = value.asLong();
            this.controller.setLoopDelay(loopDelay);
        }
        catch (Throwable e) {
            logger.warn("Failed to set loop delay", e);
        }
    }

    protected void suicide() {
        logger.error("Performing suicide");
        this.hive.removeItemFactory(this.hiveItemFactory);
        this.hive.removeConnection(this);
    }

    public void connect() {
        logger.warn("Requested connect");
        this.controller.connect(this.connectionSetup.getConnectionInformation());
    }

    public void disconnect() {
        logger.warn("Requested disconnect");
        this.controller.disconnect();
    }

    public synchronized void stop() {
        if (this.controller == null) {
            throw new RuntimeException("OPC connection is already disposed");
        }
        this.disconnect();
        this.modelExporter.detachTarget();
        this.itemManagerExporter.detachTarget();
        this.browserManagerExporter.detachTarget();
        this.itemFactory.dispose();
        this.itemFactory = null;
        this.connectionItemFactory = null;
        this.controller.getModel().removePropertyChangeListener(this);
        this.controller.shutdown();
        this.controller = null;
    }

    public synchronized void dispose() {
        if (this.hive == null) {
            return;
        }
        this.stop();
        this.hive = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("serverState".equals(propertyName)) {
            this.updateStatus(this.controller.getModel().getServerState());
        } else if ("connected".equals(propertyName)) {
            this.updateBaseModel();
        } else if ("connecting".equals(propertyName)) {
            this.updateBaseModel();
        } else if ("connectionState".equals(propertyName)) {
            this.updateBaseModel();
        } else if ("lastConnect".equals(propertyName)) {
            this.updateLastConnect();
        } else if ("lastConnectionError".equals(propertyName)) {
            this.setLastConnectionError((Throwable)evt.getNewValue());
        } else if ("numDisposersRunning".equals(propertyName)) {
            this.numDisposersRunningDataItem.updateData(Variant.valueOf((long)this.controller.getModel().getNumDisposersRunning()), null, null);
        } else if ("controllerState".equals(propertyName)) {
            this.controllerStateDataItem.updateData(Variant.valueOf((Object)this.controller.getModel().getControllerState().toString()), null, null);
        } else if ("loopDelay".equals(propertyName)) {
            this.loopDelayDataItem.updateData(Variant.valueOf((long)this.controller.getModel().getLoopDelay()), null, null);
        }
    }

    private void setLastConnectionError(Throwable newValue) {
        if (newValue == null) {
            this.lastConnectionError.updateData(Variant.NULL, null, null);
            return;
        }
        if (newValue instanceof JIException) {
            this.lastConnectionError.updateData(Variant.valueOf((Object)String.format("0x%08X", ((JIException)newValue).getErrorCode())), null, null);
        } else {
            this.lastConnectionError.updateData(Variant.valueOf((Object)newValue.getMessage()), null, null);
        }
    }

    private void updateBaseModel() {
        this.connectedItem.updateData(Variant.valueOf((boolean)this.controller.getModel().isConnected()), null, null);
        this.connectingItem.updateData(Variant.valueOf((boolean)this.controller.getModel().isConnecting()), null, null);
        this.serverStateItem.updateData(Variant.valueOf((Object)this.controller.getModel().getConnectionState().toString()), null, null);
    }

    private void updateLastConnect() {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(this.controller.getModel().getLastConnect());
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(1);
        attributes.put("milliseconds", Variant.valueOf((long)c.getTimeInMillis()));
        this.lastConnectDataItem.updateData(Variant.valueOf((Object)String.format("%tc", c)), attributes, AttributeMode.SET);
    }

    private void updateStatus(OPCSERVERSTATUS state) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(13);
        if (state != null) {
            attributes.put("opc.server.bandwidth", Variant.valueOf((int)state.getBandWidth()));
            attributes.put("opc.server.build-number", Variant.valueOf((int)state.getBuildNumber()));
            attributes.put("opc.server.minor-version", Variant.valueOf((int)state.getMinorVersion()));
            attributes.put("opc.server.major-version", Variant.valueOf((int)state.getMajorVersion()));
            attributes.put("opc.server.version", Variant.valueOf((Object)String.format("%d.%d.%d", state.getMajorVersion(), state.getMinorVersion(), state.getBuildNumber())));
            attributes.put("opc.server.current-time", Variant.valueOf((long)state.getCurrentTime().asCalendar().getTimeInMillis()));
            attributes.put("opc.server.last-update-time", Variant.valueOf((long)state.getLastUpdateTime().asCalendar().getTimeInMillis()));
            attributes.put("opc.server.start-time", Variant.valueOf((long)state.getStartTime().asCalendar().getTimeInMillis()));
            attributes.put("opc.server.group-count", Variant.valueOf((int)state.getGroupCount()));
            attributes.put("opc.server.server-state.name", Variant.valueOf((Object)state.getServerState().name()));
            attributes.put("opc.server.server-state.id", Variant.valueOf((int)state.getServerState().id()));
            attributes.put("opc.server.vendor-info", Variant.valueOf((Object)state.getVendorInfo()));
        } else {
            attributes.put("opc.server.bandwidth", null);
            attributes.put("opc.server.build-number", null);
            attributes.put("opc.server.minor-version", null);
            attributes.put("opc.server.major-version", null);
            attributes.put("opc.server.version", null);
            attributes.put("opc.server.current-time", null);
            attributes.put("opc.server.last-update-time", null);
            attributes.put("opc.server.start-time", null);
            attributes.put("opc.server.group-count", null);
            attributes.put("opc.server.server-state.name", null);
            attributes.put("opc.server.server-state.id", null);
            attributes.put("opc.server.vendor-info", null);
        }
        this.serverStateItem.updateData(null, attributes, AttributeMode.UPDATE);
    }

    public void addUnrealizedItem(String opcItemId) {
        logger.debug("Adding unrealized item: {}", (Object)opcItemId);
        if (opcItemId == null) {
            return;
        }
        this.controller.getItemManager().registerItem(opcItemId, EnumSet.allOf(IODirection.class), null);
    }

    public String getItemPrefix() {
        return this.controller.getItemManager().getItemPrefix();
    }
}

