/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.connection;

import org.eclipse.scada.da.server.common.factory.DataItemFactory;
import org.openscada.da.server.opc.connection.OPCConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OPCConnectionDataItemFactory
implements DataItemFactory {
    private static final Logger logger = LoggerFactory.getLogger(OPCConnectionDataItemFactory.class);
    private final OPCConnection connection;

    public OPCConnectionDataItemFactory(OPCConnection connection) {
        this.connection = connection;
    }

    public boolean canCreate(String itemId) {
        return itemId.startsWith(String.valueOf(this.connection.getItemPrefix()) + ".");
    }

    public void create(String itemId) {
        logger.info("Requested: {}", (Object)itemId);
        String opcItemId = itemId.substring(this.connection.getItemPrefix().length() + 1);
        this.connection.addUnrealizedItem(opcItemId);
    }
}

