/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.connection;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.da.server.common.item.factory.FolderItemFactory;
import org.jinterop.dcom.core.JISession;
import org.openscada.da.server.opc.Hive;
import org.openscada.da.server.opc.browser.OPCBrowserManager;
import org.openscada.da.server.opc.connection.OPCAsync2IoManager;
import org.openscada.da.server.opc.connection.OPCIoContext;
import org.openscada.da.server.opc.connection.OPCIoManager;
import org.openscada.da.server.opc.connection.OPCItemManager;
import org.openscada.da.server.opc.connection.OPCModel;
import org.openscada.da.server.opc.connection.OPCStateListener;
import org.openscada.da.server.opc.connection.OPCSyncIoManager;
import org.openscada.da.server.opc.connection.data.ConnectionSetup;
import org.openscada.da.server.opc.connection.data.ConnectionState;
import org.openscada.da.server.opc.connection.data.ControllerState;
import org.openscada.da.server.opc.connection.data.GroupState;
import org.openscada.da.server.opc.job.Job;
import org.openscada.da.server.opc.job.Worker;
import org.openscada.da.server.opc.job.impl.ConnectJob;
import org.openscada.da.server.opc.job.impl.GetGroupStateJob;
import org.openscada.da.server.opc.job.impl.ServerStatusJob;
import org.openscada.opc.dcom.da.OPCDATASOURCE;
import org.openscada.opc.dcom.da.OPCGroupState;
import org.openscada.opc.dcom.da.OPCSERVERSTATUS;
import org.openscada.opc.lib.common.ConnectionInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OPCController
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(OPCController.class);
    private static final long LOOP_DELAY_MIN = 50L;
    private static final long LOOP_DELAY_MAX = 10000L;
    private ConnectionInformation connectionInformation;
    private volatile boolean running = true;
    private final Worker worker;
    private final OPCModel model;
    private final OPCItemManager itemManager;
    private final OPCIoManager ioManager;
    private final OPCBrowserManager browserManager;
    private final ConnectionSetup configuration;
    private final Collection<OPCStateListener> stateListener = new CopyOnWriteArraySet<OPCStateListener>();
    private final BlockingQueue<Runnable> jobQueue = new LinkedBlockingQueue<Runnable>();
    private final GroupState groupState = new GroupState();

    public OPCController(ConnectionSetup config, Hive hive, FolderItemFactory itemFactory) {
        this.configuration = config;
        this.worker = new Worker();
        this.model = new OPCModel();
        this.model.setIgnoreTimestampOnlyChange(config.isIgnoreTimestampOnlyChange());
        this.model.setQualityErrorIfLessThen(config.getQualityErrorIfLessThen());
        this.model.setUpdateRate(config.getUpdateRate());
        switch (this.configuration.getAccessMethod()) {
            case ASYNC20: {
                this.ioManager = new OPCAsync2IoManager(this.worker, this.model, this);
                break;
            }
            default: {
                this.ioManager = new OPCSyncIoManager(this.worker, this.model, this);
            }
        }
        this.itemManager = new OPCItemManager(this.worker, this.configuration, this.model, this, hive, itemFactory);
        this.browserManager = new OPCBrowserManager(this.worker, this.configuration, this.model, hive);
    }

    public void connect(ConnectionInformation connectionInformation) {
        this.connectionInformation = connectionInformation;
        this.model.setConnectionRequested(true);
    }

    public void disconnect() {
        this.model.setConnectionRequested(false);
        this.connectionInformation = null;
    }

    public void submitJob(Runnable runnable) {
        this.jobQueue.add(runnable);
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Runnable runnable = this.jobQueue.poll(this.getModel().getLoopDelay(), TimeUnit.MILLISECONDS);
                if (!this.running) {
                    return;
                }
                if (runnable != null) {
                    try {
                        logger.debug("Running runnable");
                        runnable.run();
                    }
                    catch (Throwable e) {
                        logger.warn("Runnable failed", e);
                        this.disposeSession();
                    }
                    continue;
                }
                logger.trace("Running normal queue");
                this.runOnce();
            }
            catch (InterruptedException e) {
                logger.debug("Got interrupted", (Throwable)e);
            }
        }
    }

    protected void setControllerState(ControllerState state) {
        logger.trace("Controller state: {}", (Object)state);
        this.model.setControllerState(state);
    }

    protected void runOnce() {
        try {
            if (this.model.isConnectionRequested() && !this.model.isConnected() && !this.model.isConnecting() && this.model.mayConnect()) {
                this.setControllerState(ControllerState.CONNECTING);
                if (this.performConnect()) {
                    this.itemManager.handleConnected();
                    this.ioManager.handleConnected();
                    this.fireConnected();
                }
            } else if (!this.model.isConnectionRequested() && this.model.isConnected()) {
                this.setControllerState(ControllerState.DISCONNECTING);
                this.performDisconnect();
            }
            if (this.model.isConnected()) {
                this.setControllerState(ControllerState.READING_STATUS);
                this.updateStatus();
                this.setControllerState(ControllerState.GET_GROUP_STATUS);
                this.updateGroupStatus();
                OPCIoContext ctx = this.ioManager.prepareProcessing();
                this.ioManager.performProcessing(ctx, OPCDATASOURCE.OPC_DS_CACHE);
                this.setControllerState(ControllerState.BROWSING);
                this.browserManager.performBrowse();
            }
            this.setControllerState(ControllerState.IDLE);
        }
        catch (Throwable e) {
            logger.error("Failed to process", e);
            this.disposeSession();
        }
    }

    private void updateStatus() throws InvocationTargetException {
        ServerStatusJob job = new ServerStatusJob(this.model.getStatusJobTimeout(), this.model);
        this.setServerState(this.worker.execute((Job)job, job));
    }

    private void updateGroupStatus() throws InvocationTargetException {
        GetGroupStateJob job = new GetGroupStateJob(this.model.getStatusJobTimeout(), this.model);
        this.setGroupState(this.worker.execute((Job)job, job));
    }

    private void setGroupState(OPCGroupState state) {
        this.groupState.update(state);
    }

    protected void setServerState(OPCSERVERSTATUS state) {
        this.model.setServerState(state);
    }

    private boolean performConnect() {
        this.model.setLastConnectNow();
        this.model.setConnecting(true);
        this.model.setConnectionState(ConnectionState.CONNECTING);
        final ConnectJob job = new ConnectJob(this.model.getConnectJobTimeout(), this.connectionInformation, this.model.getGlobalTimeout(), this.model.getUpdateRate());
        final OPCModel model = this.model;
        try {
            try {
                this.worker.execute((Job)job, new Runnable(){

                    @Override
                    public void run() {
                        model.setSession(job.getSession());
                        model.setServer(job.getServer());
                        model.setCommon(job.getCommon());
                        model.setGroup(job.getGroup());
                        model.setSyncIo(job.getSyncIo());
                        model.setItemMgt(job.getItemMgt());
                        model.setAsyncIo2(job.getAsyncIo2());
                        model.setConnectionState(ConnectionState.CONNECTED);
                    }
                });
            }
            catch (InvocationTargetException e) {
                logger.info("Failed to connect", (Throwable)e);
                this.model.setLastConnectionError(e.getCause());
                model.setConnectionState(ConnectionState.DISCONNECTED);
                this.disposeSession(job.getSession());
                model.setConnecting(false);
                return false;
            }
        }
        finally {
            model.setConnecting(false);
        }
        return true;
    }

    private void performDisconnect() {
        this.disposeSession();
    }

    protected void disposeSession(final JISession session) {
        logger.info("Destroying DCOM session...");
        Thread destructor = new Thread(new Runnable(){

            @Override
            public void run() {
                OPCController.this.model.addDisposerRunning(Thread.currentThread());
                long ts = System.currentTimeMillis();
                try {
                    try {
                        logger.debug("Starting destruction of DCOM session");
                        JISession.destroySession((JISession)session);
                        logger.info("Destructed DCOM session");
                    }
                    catch (Throwable e) {
                        logger.warn("Failed to destruct DCOM session", e);
                        logger.info("Session destruction took {} ms", (Object)(System.currentTimeMillis() - ts));
                        OPCController.this.model.removeDisposerRunning(Thread.currentThread());
                    }
                }
                finally {
                    logger.info("Session destruction took {} ms", (Object)(System.currentTimeMillis() - ts));
                    OPCController.this.model.removeDisposerRunning(Thread.currentThread());
                }
            }
        });
        destructor.setName("OPCSessionDestructor/" + this.configuration.getDeviceTag());
        destructor.setDaemon(true);
        destructor.start();
        logger.info("Destroying DCOM session... forked");
    }

    protected void disposeSession() {
        if (this.model.getSession() == null) {
            return;
        }
        this.model.setConnectionState(ConnectionState.DISCONNECTING);
        this.disposeSession(this.model.getSession());
        this.itemManager.handleDisconnected();
        this.ioManager.handleDisconnected();
        this.fireDisconnected();
        this.model.setServerState(null);
        this.model.setConnecting(false);
        this.model.setServer(null);
        this.model.setSession(null);
        this.model.setGroup(null);
        this.model.setItemMgt(null);
        this.model.setSyncIo(null);
        this.model.setAsyncIo2(null);
        this.model.setCommon(null);
        this.model.setConnectionState(ConnectionState.DISCONNECTED);
        this.setGroupState(null);
    }

    public void shutdown() {
        this.itemManager.shutdown();
        this.ioManager.shutdown();
        this.running = false;
    }

    public OPCModel getModel() {
        return this.model;
    }

    public OPCItemManager getItemManager() {
        return this.itemManager;
    }

    public OPCIoManager getIoManager() {
        return this.ioManager;
    }

    public OPCBrowserManager getBrowserManager() {
        return this.browserManager;
    }

    public void setLoopDelay(long loopDelay) {
        if (loopDelay < 50L) {
            loopDelay = 50L;
        }
        if (loopDelay > 10000L) {
            loopDelay = 10000L;
        }
        this.model.setLoopDelay(loopDelay);
    }

    public void addStateListener(OPCStateListener stateListener) {
        this.stateListener.add(stateListener);
    }

    public void removeStateListener(OPCStateListener stateListener) {
        this.stateListener.remove(stateListener);
    }

    protected void fireConnected() {
        for (OPCStateListener listener : this.stateListener) {
            listener.connectionEstablished();
        }
    }

    protected void fireDisconnected() {
        for (OPCStateListener listener : this.stateListener) {
            listener.connectionLost();
        }
    }

    public GroupState getGroupState() {
        return this.groupState;
    }
}

