/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.connection;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.utils.beans.AbstractPropertyChange;
import org.eclipse.scada.utils.concurrent.FutureTask;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.jinterop.dcom.core.JIVariant;
import org.openscada.da.server.opc.Helper;
import org.openscada.da.server.opc.connection.ItemRegistrationRequest;
import org.openscada.da.server.opc.connection.OPCController;
import org.openscada.da.server.opc.connection.OPCIoContext;
import org.openscada.da.server.opc.connection.OPCModel;
import org.openscada.da.server.opc.connection.OPCWriteRequest;
import org.openscada.da.server.opc.connection.data.ControllerState;
import org.openscada.da.server.opc.job.Job;
import org.openscada.da.server.opc.job.Worker;
import org.openscada.da.server.opc.job.impl.ErrorMessageJob;
import org.openscada.da.server.opc.job.impl.ItemActivationJob;
import org.openscada.da.server.opc.job.impl.RealizeItemsJob;
import org.openscada.da.server.opc.job.impl.UnrealizeItemsJob;
import org.openscada.opc.dcom.common.KeyedResult;
import org.openscada.opc.dcom.common.KeyedResultSet;
import org.openscada.opc.dcom.common.Result;
import org.openscada.opc.dcom.common.ResultSet;
import org.openscada.opc.dcom.da.OPCDATASOURCE;
import org.openscada.opc.dcom.da.OPCITEMDEF;
import org.openscada.opc.dcom.da.OPCITEMRESULT;
import org.openscada.opc.dcom.da.ValueData;
import org.openscada.opc.dcom.da.WriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OPCIoManager
extends AbstractPropertyChange {
    private static final Logger logger = LoggerFactory.getLogger(OPCIoManager.class);
    private static final String PROP_SERVER_HANDLE_COUNT = "serverHandleCount";
    private static final String PROP_WRITE_REQUEST_COUNT = "writeRequestCount";
    private static final String PROP_WRITE_REQUEST_MAX = "writeRequestMax";
    private static final String PROP_WRITE_REQUEST_TOTAL = "writeRequestTotal";
    private int writeRequestMax = 0;
    private final AtomicLong writeRequestTotal = new AtomicLong();
    private final Map<String, ItemRegistrationRequest> requestMap = new HashMap<String, ItemRegistrationRequest>();
    private final Map<String, ItemRegistrationRequest> requestedMap = new HashMap<String, ItemRegistrationRequest>();
    protected final Map<String, Integer> clientHandleMap = new HashMap<String, Integer>();
    protected final Map<Integer, String> clientHandleMapRev = new HashMap<Integer, String>();
    protected final Map<String, Integer> serverHandleMap = new HashMap<String, Integer>();
    protected final Map<Integer, String> serverHandleMapRev = new HashMap<Integer, String>();
    private final Map<String, Boolean> activationRequestMap = new HashMap<String, Boolean>();
    private final Set<String> activeSet = new HashSet<String>();
    private final Queue<FutureTask<Result<WriteRequest>>> writeRequests = new LinkedList<FutureTask<Result<WriteRequest>>>();
    private final Set<String> itemUnregistrations = new HashSet<String>();
    protected final Worker worker;
    protected final OPCModel model;
    protected final OPCController controller;
    private final Map<Integer, String> errorCodeCache = new HashMap<Integer, String>();
    protected volatile boolean connected = false;

    public OPCIoManager(Worker worker, OPCModel model, OPCController controller) {
        this.worker = worker;
        this.model = model;
        this.controller = controller;
    }

    public void shutdown() {
        this.handleDisconnected();
    }

    public void requestItemsById(Collection<String> requestItems) {
        ArrayList<ItemRegistrationRequest> reqs = new ArrayList<ItemRegistrationRequest>(requestItems.size());
        for (String itemId : requestItems) {
            ItemRegistrationRequest req = new ItemRegistrationRequest();
            OPCITEMDEF def = new OPCITEMDEF();
            def.setItemID(itemId);
            def.setActive(false);
            req.setItemDefinition(def);
            reqs.add(req);
        }
        this.requestItems(reqs);
    }

    public synchronized void requestItems(Collection<ItemRegistrationRequest> items) {
        for (ItemRegistrationRequest itemDef : items) {
            String itemId = itemDef.getItemDefinition().getItemID();
            logger.debug("Requesting item: {}", (Object)itemId);
            this.itemUnregistrations.remove(itemId);
            if (this.requestMap.containsKey(itemId)) {
                logger.info("Item already in request queue");
                continue;
            }
            if (this.requestedMap.containsKey(itemId)) {
                logger.info("Item already requested");
                continue;
            }
            this.requestMap.put(itemDef.getItemDefinition().getItemID(), itemDef);
        }
    }

    public synchronized void unrequestItem(String itemId) {
        logger.debug("Adding item to unrequest queue: {}", (Object)itemId);
        this.itemUnregistrations.add(itemId);
        this.requestMap.remove(itemId);
    }

    public void requestItemById(String itemId) {
        this.requestItemsById(Arrays.asList(itemId));
    }

    public void handleConnected() throws InvocationTargetException {
        this.registerAllItems();
        this.connected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDisconnected() {
        ArrayList<FutureTask<Result<WriteRequest>>> copyWriteRequests;
        OPCIoManager oPCIoManager = this;
        synchronized (oPCIoManager) {
            this.connected = false;
            this.itemUnregistrations.clear();
            copyWriteRequests = new ArrayList<FutureTask<Result<WriteRequest>>>(this.writeRequests);
            this.writeRequests.clear();
            this.firePropertyChange(PROP_WRITE_REQUEST_COUNT, null, this.writeRequests.size());
            this.clientHandleMap.clear();
            this.clientHandleMapRev.clear();
            this.serverHandleMap.clear();
            this.serverHandleMapRev.clear();
            this.firePropertyChange(PROP_SERVER_HANDLE_COUNT, null, this.serverHandleMap.size());
        }
        logger.info("Discarding {} write requests", (Object)copyWriteRequests.size());
        for (FutureTask futureTask : copyWriteRequests) {
            futureTask.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAllItems() throws InvocationTargetException {
        ArrayList<ItemRegistrationRequest> requested;
        OPCIoManager oPCIoManager = this;
        synchronized (oPCIoManager) {
            requested = new ArrayList<ItemRegistrationRequest>(this.requestedMap.values());
        }
        this.performRealizeItems(requested);
        this.setActive(true, this.activeSet);
    }

    private void performUnrealizeItems(Collection<String> items) throws InvocationTargetException {
        if (items.isEmpty()) {
            return;
        }
        HashSet<Integer> itemHandles = new HashSet<Integer>();
        for (String itemId : items) {
            Integer serverHandle = this.serverHandleMap.get(itemId);
            if (serverHandle == null) continue;
            itemHandles.add(serverHandle);
        }
        UnrealizeItemsJob job = new UnrealizeItemsJob(this.model.getConnectJobTimeout(), this.model.getItemMgt(), itemHandles.toArray(new Integer[itemHandles.size()]));
        ResultSet<Integer> result = this.worker.execute((Job)job, job);
        for (Result entry : result) {
            if (entry.isFailed()) continue;
            Integer serverHandle = (Integer)entry.getValue();
            String itemId = this.serverHandleMapRev.get(serverHandle);
            this.removeByServerHandle(serverHandle);
            if (itemId == null) continue;
            try {
                this.controller.getItemManager().itemUnrealized(itemId);
            }
            catch (Throwable e) {
                logger.warn("Failed to notify item of unrealize", e);
            }
        }
    }

    private void removeByServerHandle(Integer serverHandle) {
        String itemId;
        if (serverHandle != null && (itemId = this.serverHandleMapRev.get(serverHandle)) != null) {
            Integer clientHandle = this.clientHandleMap.get(itemId);
            if (clientHandle != null) {
                this.clientHandleMapRev.remove(clientHandle);
            }
            this.clientHandleMap.remove(itemId);
            this.serverHandleMap.remove(itemId);
            this.serverHandleMapRev.remove(serverHandle);
        }
    }

    private void performRealizeItems(Collection<ItemRegistrationRequest> newItems) throws InvocationTargetException {
        if (newItems.isEmpty()) {
            return;
        }
        Random r = new Random();
        for (ItemRegistrationRequest def : newItems) {
            Integer i = r.nextInt();
            while (this.clientHandleMapRev.containsKey(i)) {
                i = r.nextInt();
            }
            this.clientHandleMap.put(def.getItemDefinition().getItemID(), i);
            this.clientHandleMapRev.put(i, def.getItemDefinition().getItemID());
            def.getItemDefinition().setClientHandle(i.intValue());
        }
        for (ItemRegistrationRequest def : newItems) {
            RealizeItemsJob job = new RealizeItemsJob(this.model.getConnectJobTimeout(), this.model.getItemMgt(), new OPCITEMDEF[]{def.getItemDefinition()});
            KeyedResultSet<OPCITEMDEF, OPCITEMRESULT> result = this.worker.execute((Job)job, job);
            for (KeyedResult entry : result) {
                String itemId = ((OPCITEMDEF)entry.getKey()).getItemID();
                if (entry.isFailed()) {
                    logger.info("Revoking client handle {} for item {}", (Object)((OPCITEMDEF)entry.getKey()).getClientHandle(), (Object)itemId);
                    this.clientHandleMap.remove(itemId);
                    this.clientHandleMapRev.remove(((OPCITEMDEF)entry.getKey()).getClientHandle());
                } else {
                    int serverHandle = ((OPCITEMRESULT)entry.getValue()).getServerHandle();
                    this.serverHandleMap.put(itemId, serverHandle);
                    this.serverHandleMapRev.put(serverHandle, itemId);
                }
                this.controller.getItemManager().itemRealized(def.getItemDefinition().getItemID(), (KeyedResult<OPCITEMDEF, OPCITEMRESULT>)entry);
            }
        }
        this.firePropertyChange(PROP_SERVER_HANDLE_COUNT, null, this.serverHandleMap.size());
    }

    public synchronized void wakeupItem(String item) {
        logger.debug("Waking up item: {}", (Object)item);
        this.requestItemById(item);
        this.activationRequestMap.put(item, Boolean.TRUE);
        this.activeSet.add(item);
    }

    public synchronized void suspendItem(String item) {
        logger.debug("Suspending item: {}", (Object)item);
        this.activationRequestMap.put(item, Boolean.FALSE);
        this.activeSet.remove(item);
        this.unrequestItem(item);
    }

    public synchronized OPCIoContext prepareProcessing() {
        OPCIoContext ctx = new OPCIoContext();
        if (!this.requestMap.isEmpty()) {
            ArrayList<ItemRegistrationRequest> newItems = new ArrayList<ItemRegistrationRequest>(this.requestMap.size());
            for (Map.Entry<String, ItemRegistrationRequest> def : this.requestMap.entrySet()) {
                newItems.add(def.getValue());
                this.requestedMap.put(def.getKey(), def.getValue());
            }
            this.requestMap.clear();
            ctx.setRegistrations(newItems);
        }
        if (!this.activationRequestMap.isEmpty()) {
            ctx.setActivations(new HashMap<String, Boolean>(this.activationRequestMap));
            this.activationRequestMap.clear();
        }
        if (!this.writeRequests.isEmpty()) {
            ctx.setWriteRequests(new ArrayList<FutureTask<Result<WriteRequest>>>(this.writeRequests));
            this.writeRequests.clear();
            this.firePropertyChange(PROP_WRITE_REQUEST_COUNT, null, this.writeRequests.size());
        }
        if (!this.activeSet.isEmpty()) {
            ctx.setReadItems(new HashSet<String>(this.activeSet));
        }
        if (!this.itemUnregistrations.isEmpty()) {
            ctx.setUnregistrations(new HashSet<String>(this.itemUnregistrations));
            this.itemUnregistrations.clear();
            for (String itemId : ctx.getUnregistrations()) {
                logger.debug("Removing item {} from requestedMap", (Object)itemId);
                this.requestedMap.remove(itemId);
            }
        }
        return ctx;
    }

    public void performProcessing(OPCIoContext ctx, OPCDATASOURCE dataSource) throws InvocationTargetException {
        if (ctx.getRegistrations() != null) {
            this.controller.setControllerState(ControllerState.REGISTERING);
            this.performRealizeItems(ctx.getRegistrations());
        }
        if (ctx.getActivations() != null) {
            this.controller.setControllerState(ControllerState.ACTIVATING);
            this.performActivations(ctx.getActivations());
        }
        if (ctx.getWriteRequests() != null) {
            this.controller.setControllerState(ControllerState.WRITING);
            this.performWriteRequests(ctx.getWriteRequests());
        }
        if (ctx.getReadItems() != null) {
            this.controller.setControllerState(ControllerState.READING);
            this.performRead(ctx.getReadItems(), dataSource);
        }
        if (ctx.getUnregistrations() != null) {
            this.controller.setControllerState(ControllerState.UNREGISTERING);
            this.performUnrealizeItems(ctx.getUnregistrations());
        }
    }

    private void performActivations(Map<String, Boolean> processMap) throws InvocationTargetException {
        HashSet<String> setActive = new HashSet<String>();
        HashSet<String> setInactive = new HashSet<String>();
        for (Map.Entry<String, Boolean> entry : processMap.entrySet()) {
            if (entry.getValue().booleanValue()) {
                setActive.add(entry.getKey());
                continue;
            }
            setInactive.add(entry.getKey());
        }
        this.setActive(true, setActive);
        this.setActive(false, setInactive);
    }

    private void setActive(boolean state, Collection<String> list) throws InvocationTargetException {
        if (list.isEmpty()) {
            return;
        }
        ArrayList<Integer> handles = new ArrayList<Integer>(list.size());
        for (String itemId : list) {
            Integer handle = this.serverHandleMap.get(itemId);
            if (handle == null) continue;
            handles.add(handle);
        }
        if (handles.isEmpty()) {
            return;
        }
        ItemActivationJob job = new ItemActivationJob(this.model.getConnectJobTimeout(), this.model, state, handles.toArray(new Integer[0]));
        this.worker.execute((Job)job, job);
    }

    protected abstract void performRead(Set<String> var1, OPCDATASOURCE var2) throws InvocationTargetException;

    protected void handleReadResult(KeyedResultSet<Integer, ValueData> result, boolean useServerHandles) throws InvocationTargetException {
        for (KeyedResult entry : result) {
            String itemId = useServerHandles ? this.serverHandleMapRev.get(entry.getKey()) : this.clientHandleMapRev.get(entry.getKey());
            if (itemId == null) {
                logger.info("Got read reply for invalid item - server handle: '{}'", entry.getKey());
                continue;
            }
            String errorMessage = null;
            if (entry.isFailed()) {
                errorMessage = this.getErrorMessage(entry.getErrorCode());
            }
            this.controller.getItemManager().dataRead(itemId, (KeyedResult<Integer, ValueData>)entry, errorMessage);
        }
    }

    private String getErrorMessage(int errorCode) throws InvocationTargetException {
        if (this.errorCodeCache.containsKey(errorCode)) {
            return this.errorCodeCache.get(errorCode);
        }
        ErrorMessageJob job = new ErrorMessageJob(this.model.getConnectJobTimeout(), this.model, errorCode);
        String message = this.worker.execute((Job)job, job);
        this.errorCodeCache.put(errorCode, message);
        return message;
    }

    public NotifyFuture<Result<WriteRequest>> addWriteRequest(String itemId, Variant value) {
        if (!this.model.isConnected()) {
            logger.warn("OPC is not connected");
            return new InstantErrorFuture(new RuntimeException("OPC is not connected").fillInStackTrace());
        }
        this.requestItemById(itemId);
        JIVariant variant = Helper.ours2theirs(value);
        if (variant == null) {
            logger.warn("Failed to convert {} to variant", (Object)value);
            return new InstantErrorFuture(new RuntimeException(String.format("Failed to convert %s to variant", value)).fillInStackTrace());
        }
        return this.addWriteRequest(new OPCWriteRequest(itemId, variant));
    }

    protected abstract FutureTask<Result<WriteRequest>> newWriteFuture(OPCWriteRequest var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NotifyFuture<Result<WriteRequest>> addWriteRequest(OPCWriteRequest request) {
        FutureTask<Result<WriteRequest>> future;
        logger.debug("Adding write request: {}", (Object)request);
        OPCIoManager oPCIoManager = this;
        synchronized (oPCIoManager) {
            if (!this.connected) {
                return new InstantErrorFuture(new RuntimeException("OPC is not connected").fillInStackTrace());
            }
            future = this.newWriteFuture(request);
            this.writeRequests.add(future);
        }
        int size = this.writeRequests.size();
        this.writeRequestMax = Math.max(this.writeRequestMax, size);
        long total = this.writeRequestTotal.incrementAndGet();
        this.firePropertyChange(PROP_WRITE_REQUEST_COUNT, null, size);
        this.firePropertyChange(PROP_WRITE_REQUEST_MAX, null, size);
        this.firePropertyChange(PROP_WRITE_REQUEST_TOTAL, null, total);
        return future;
    }

    protected abstract void performWriteRequests(Collection<FutureTask<Result<WriteRequest>>> var1) throws InvocationTargetException;

    public int getServerHandleCount() {
        return this.serverHandleMap.size();
    }

    public int getWriteRequestCount() {
        return this.writeRequests.size();
    }

    public int getWriteRequestMax() {
        return this.writeRequestMax;
    }

    public long getWriteRequestTotal() {
        return this.writeRequestTotal.get();
    }
}

