/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.connection;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.InvalidOperationException;
import org.eclipse.scada.core.NotConvertableException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.SuspendableDataItem;
import org.eclipse.scada.da.server.common.chain.DataItemInputOutputChained;
import org.eclipse.scada.utils.collection.MapBuilder;
import org.eclipse.scada.utils.concurrent.DirectExecutor;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.jinterop.dcom.core.JIVariant;
import org.openscada.da.server.opc.Helper;
import org.openscada.da.server.opc.Hive;
import org.openscada.da.server.opc.connection.OPCController;
import org.openscada.da.server.opc.connection.WriteFuture;
import org.openscada.opc.dcom.common.KeyedResult;
import org.openscada.opc.dcom.common.Result;
import org.openscada.opc.dcom.da.OPCITEMDEF;
import org.openscada.opc.dcom.da.OPCITEMRESULT;
import org.openscada.opc.dcom.da.ValueData;
import org.openscada.opc.dcom.da.WriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OPCItem
extends DataItemInputOutputChained
implements SuspendableDataItem {
    private static final int MANUAL_VALUE = Integer.getInteger("org.openscada.da.server.opc.manualValue", 216);
    private static final Logger logger = LoggerFactory.getLogger(OPCItem.class);
    private volatile boolean suspended = true;
    private Variant lastValue;
    private final OPCController controller;
    private final String opcItemId;
    private boolean ignoreTimestampOnlyChange = false;
    private short qualityErrorIfLessThen = Integer.getInteger("org.openscada.da.server.opc.qualityErrorIfLessThen", 192).shortValue();

    public OPCItem(Hive hive, OPCController controller, DataItemInformation di, String opcItemId) {
        super(di, DirectExecutor.INSTANCE);
        this.controller = controller;
        this.opcItemId = opcItemId;
        this.ignoreTimestampOnlyChange = controller.getModel().isIgnoreTimestampOnlyChange();
        this.qualityErrorIfLessThen = controller.getModel().getQualityErrorIfLessThen();
        this.updateData(null, new MapBuilder().put((Object)"opc.connection.error", (Object)Variant.TRUE).put((Object)"opc.itemId", (Object)Variant.valueOf((Object)opcItemId)).getMap(), AttributeMode.SET);
    }

    protected NotifyFuture<WriteResult> startWriteCalculatedValue(Variant value, OperationParameters operationParameters) {
        if (!this.getInformation().getIODirection().contains(IODirection.OUTPUT)) {
            logger.warn("Failed to write to read-only item ({})", (Object)this.opcItemId);
            return new InstantErrorFuture(new InvalidOperationException().fillInStackTrace());
        }
        JIVariant variant = Helper.ours2theirs(value);
        logger.debug("Converting write request from {} to {}", (Object)value, (Object)variant);
        if (variant == null) {
            logger.info("Unable to convert write request");
            return new InstantErrorFuture(new NotConvertableException((Object)value.getValue()).fillInStackTrace());
        }
        return this.processWriteRequest(value);
    }

    private NotifyFuture<WriteResult> processWriteRequest(Variant value) {
        NotifyFuture<Result<WriteRequest>> future = this.controller.getIoManager().addWriteRequest(this.opcItemId, value);
        return new WriteFuture(this, future);
    }

    public synchronized void suspend() {
        logger.info("Suspend item: {} - currentState: {}", (Object)this.getInformation().getName(), (Object)this.suspended);
        if (this.suspended) {
            return;
        }
        this.suspended = true;
        this.controller.getIoManager().suspendItem(this.opcItemId);
    }

    public synchronized void wakeup() {
        logger.info("Wakeup item: {} - currentState: {}", (Object)this.getInformation().getName(), (Object)this.suspended);
        if (!this.suspended) {
            return;
        }
        this.suspended = false;
        this.controller.getIoManager().wakeupItem(this.opcItemId);
    }

    public void updateStatus(KeyedResult<Integer, ValueData> entry, String errorMessage) {
        if (this.suspended) {
            return;
        }
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        ValueData state = (ValueData)entry.getValue();
        attributes.put("opc.connection.error", null);
        if (entry.isFailed()) {
            attributes.put("opc.read.error", Variant.TRUE);
            attributes.put("opc.read.error.code", Variant.valueOf((int)entry.getErrorCode()));
            attributes.put("opc.read.error.message", Variant.valueOf((Object)String.format("0x%08x: %s", entry.getErrorCode(), errorMessage)));
            attributes.put("opc.quality", null);
            attributes.put("timestamp", null);
            attributes.put("timestamp.message", null);
            attributes.put("opc.value.type", null);
            attributes.put("opc.value.conversion.error", null);
            attributes.put("opc.value.conversion.source", null);
            this.lastValue = null;
            this.updateData(Variant.NULL, attributes, AttributeMode.UPDATE);
        } else {
            attributes.put("opc.read.error", null);
            attributes.put("opc.read.error.code", null);
            attributes.put("opc.read.error.message", null);
            short quality = state.getQuality();
            attributes.put("opc.quality", Variant.valueOf((int)quality));
            attributes.put("opc.quality.error", Variant.valueOf((quality < this.qualityErrorIfLessThen ? 1 : 0) != 0));
            attributes.put("opc.quality.manual", Variant.valueOf((quality == MANUAL_VALUE ? 1 : 0) != 0));
            attributes.put("org.openscada.da.manual.active", Variant.valueOf((quality == MANUAL_VALUE ? 1 : 0) != 0));
            attributes.put("opc.value.type", null);
            try {
                attributes.put("opc.value.type", Variant.valueOf((int)state.getValue().getType()));
            }
            catch (Throwable e) {
                logger.trace("Failed to get type");
            }
            Variant value = Helper.theirs2ours(state.getValue());
            if (value == null) {
                value = Variant.NULL;
                attributes.put("opc.value.conversion.error", Variant.TRUE);
                attributes.put("opc.value.conversion.source", Variant.valueOf((Object)state.getValue().toString()));
            } else {
                attributes.put("opc.value.conversion.error", null);
                attributes.put("opc.value.conversion.source", null);
                if (!this.ignoreTimestampOnlyChange || this.lastValue == null || !this.lastValue.equals((Object)value)) {
                    attributes.put("timestamp", Variant.valueOf((long)state.getTimestamp().getTimeInMillis()));
                    attributes.put("timestamp.message", Variant.valueOf((Object)String.format("%tc", state.getTimestamp())));
                }
            }
            this.updateData(value, attributes, AttributeMode.UPDATE);
            this.lastValue = value;
        }
    }

    public void setLastWriteError(Result<WriteRequest> result) {
        Calendar c = Calendar.getInstance();
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        if (result != null) {
            attributes.put("opc.lastWriteError.code", Variant.valueOf((int)result.getErrorCode()));
            attributes.put("opc.lastWriteError.message", Variant.valueOf((Object)String.format("0x%08x", result.getErrorCode())));
        } else {
            attributes.put("opc.lastWriteError.code", Variant.valueOf((int)-1));
            attributes.put("opc.lastWriteError.message", Variant.valueOf((Object)"unknown error"));
        }
        attributes.put("opc.lastWriteError.timestamp", Variant.valueOf((long)c.getTimeInMillis()));
        attributes.put("opc.lastWriteError.timestamp.message", Variant.valueOf((Object)String.format("%tc", c)));
        this.updateData(null, attributes, AttributeMode.UPDATE);
    }

    public void itemRealized(KeyedResult<OPCITEMDEF, OPCITEMRESULT> entry) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.putAll(Helper.convertToAttributes(entry));
        attributes.putAll(Helper.convertToAttributes((OPCITEMDEF)entry.getKey()));
        attributes.putAll(Helper.convertToAttributes((OPCITEMRESULT)entry.getValue()));
        this.updateData(null, attributes, AttributeMode.UPDATE);
    }

    public void itemUnrealized() {
        logger.debug("Item got unrealized");
        Map<String, Variant> attributes = Helper.clearAttributes();
        attributes.put("opc.connection.error", Variant.TRUE);
        this.updateData(null, attributes, AttributeMode.UPDATE);
    }

    public WriteAttributeResults processSetAttributes(Map<String, Variant> attributes, OperationParameters operationParameters) {
        return super.processSetAttributes(attributes, operationParameters);
    }
}

