/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.connection;

import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.browser.common.query.AttributeNameProvider;
import org.eclipse.scada.da.server.browser.common.query.GroupFolder;
import org.eclipse.scada.da.server.browser.common.query.GroupProvider;
import org.eclipse.scada.da.server.browser.common.query.InvisibleStorage;
import org.eclipse.scada.da.server.browser.common.query.ItemDescriptor;
import org.eclipse.scada.da.server.browser.common.query.ItemStorage;
import org.eclipse.scada.da.server.browser.common.query.NameProvider;
import org.eclipse.scada.da.server.browser.common.query.PatternNameProvider;
import org.eclipse.scada.da.server.browser.common.query.SplitGroupProvider;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.DataItemInformationBase;
import org.eclipse.scada.da.server.common.item.factory.FolderItemFactory;
import org.eclipse.scada.utils.beans.AbstractPropertyChange;
import org.eclipse.scada.utils.collection.MapBuilder;
import org.openscada.da.server.opc.Helper;
import org.openscada.da.server.opc.Hive;
import org.openscada.da.server.opc.connection.IOListener;
import org.openscada.da.server.opc.connection.OPCController;
import org.openscada.da.server.opc.connection.OPCItem;
import org.openscada.da.server.opc.connection.OPCModel;
import org.openscada.da.server.opc.connection.data.ConnectionSetup;
import org.openscada.da.server.opc.job.Worker;
import org.openscada.opc.dcom.common.KeyedResult;
import org.openscada.opc.dcom.da.OPCITEMDEF;
import org.openscada.opc.dcom.da.OPCITEMRESULT;
import org.openscada.opc.dcom.da.ValueData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OPCItemManager
extends AbstractPropertyChange
implements IOListener {
    private static final Logger logger = LoggerFactory.getLogger(OPCItemManager.class);
    private static final String PROP_REGISTERED_ITEM_COUNT = "registeredItemCount";
    private final Map<String, OPCItem> itemMap = new HashMap<String, OPCItem>();
    private final String itemIdPrefix;
    private final Hive hive;
    private final InvisibleStorage allItemsStorage = new InvisibleStorage();
    private final GroupFolder allItemsFolder;
    private final ConnectionSetup configuration;
    private final FolderItemFactory parentItemFactory;
    private final OPCController controller;
    private volatile int registeredItemCount;

    public OPCItemManager(Worker worker, ConnectionSetup configuration, OPCModel model, OPCController controller, Hive hive, FolderItemFactory parentItemFactory) {
        this.hive = hive;
        this.configuration = configuration;
        this.parentItemFactory = parentItemFactory;
        this.controller = controller;
        this.itemIdPrefix = this.configuration.getItemIdPrefix();
        this.allItemsFolder = new GroupFolder((GroupProvider)new SplitGroupProvider((NameProvider)new AttributeNameProvider("opc.itemId"), "\\.", 0, 1), (NameProvider)new PatternNameProvider((NameProvider)new AttributeNameProvider("opc.itemId"), Pattern.compile(".*\\.(.*?)$"), 1));
        this.allItemsStorage.addChild((ItemStorage)this.allItemsFolder);
        this.parentItemFactory.getFolder().add("registeredItems", (Folder)this.allItemsFolder, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"Contains all items that are registered with the OPC server")).getMap());
    }

    public int getRegisteredItemCount() {
        return this.registeredItemCount;
    }

    protected void setRegisteredItemCount(int registeredItemCount) {
        int oldRegisteredItemCount = this.registeredItemCount;
        this.registeredItemCount = registeredItemCount;
        this.firePropertyChange(PROP_REGISTERED_ITEM_COUNT, oldRegisteredItemCount, registeredItemCount);
    }

    public void shutdown() {
        this.handleDisconnected();
        FolderCommon folder = this.parentItemFactory.getFolder();
        if (folder != null) {
            folder.remove((Folder)this.allItemsFolder);
        }
    }

    protected synchronized void unregisterAllItems() {
        for (Map.Entry<String, OPCItem> entry : this.itemMap.entrySet()) {
            OPCItem item = entry.getValue();
            this.hive.unregisterItem((DataItem)item);
            this.allItemsStorage.removed(new ItemDescriptor((DataItem)item, new HashMap()));
        }
        this.itemMap.clear();
    }

    public void handleConnected() throws InvocationTargetException {
    }

    public void handleDisconnected() {
        this.unrealizeAllItems();
    }

    private synchronized void unrealizeAllItems() {
        for (Map.Entry<String, OPCItem> entry : this.itemMap.entrySet()) {
            OPCItem item = entry.getValue();
            item.itemUnrealized();
        }
    }

    private void createRealizedItem(String opcItemId, KeyedResult<OPCITEMDEF, OPCITEMRESULT> entry) {
        logger.debug("Create realized item - opcItemId: {}", (Object)opcItemId);
        OPCITEMRESULT result = (OPCITEMRESULT)entry.getValue();
        this.registerItem(opcItemId, Helper.convertToAccessSet(result.getAccessRights()), Helper.convertToAttributes((OPCITEMDEF)entry.getKey()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerItem(String opcItemId, EnumSet<IODirection> ioDirection, Map<String, Variant> additionalBrowserAttributes) {
        OPCItem item;
        logger.debug("Request to register item: {}", (Object)opcItemId);
        OPCItemManager oPCItemManager = this;
        synchronized (oPCItemManager) {
            item = this.itemMap.get(opcItemId);
            if (item != null) {
                logger.debug("Item {} already exists", (Object)opcItemId);
                return;
            }
            item = new OPCItem(this.hive, this.controller, (DataItemInformation)new DataItemInformationBase(this.createItemId(opcItemId), ioDirection), opcItemId);
            this.itemMap.put(opcItemId, item);
            this.setRegisteredItemCount(this.itemMap.size());
        }
        this.hive.registerItem((DataItem)item);
        HashMap<String, Variant> browserMap = new HashMap<String, Variant>(additionalBrowserAttributes != null ? additionalBrowserAttributes.size() + 1 : 1);
        browserMap.put("opc.itemId", Variant.valueOf((Object)opcItemId));
        if (additionalBrowserAttributes != null) {
            browserMap.putAll(additionalBrowserAttributes);
        }
        this.allItemsStorage.added(new ItemDescriptor((DataItem)item, browserMap));
    }

    public String createItemId(String opcItemId) {
        return String.valueOf(this.getItemPrefix()) + "." + opcItemId;
    }

    protected String getItemPrefix() {
        if (this.itemIdPrefix == null || this.itemIdPrefix.length() == 0) {
            return this.configuration.getDeviceTag();
        }
        return String.valueOf(this.configuration.getDeviceTag()) + "." + this.itemIdPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataRead(String itemId, KeyedResult<Integer, ValueData> entry, String errorMessage) {
        OPCItem item;
        OPCItemManager oPCItemManager = this;
        synchronized (oPCItemManager) {
            item = this.itemMap.get(itemId);
            if (item == null) {
                return;
            }
        }
        item.updateStatus(entry, errorMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void itemRealized(String itemId, KeyedResult<OPCITEMDEF, OPCITEMRESULT> entry) {
        OPCItem item;
        logger.debug("itemRealized - itemId: {}", (Object)itemId);
        OPCItemManager oPCItemManager = this;
        synchronized (oPCItemManager) {
            item = this.itemMap.get(itemId);
            if (item == null) {
                this.createRealizedItem(itemId, entry);
                return;
            }
        }
        item.itemRealized(entry);
    }

    @Override
    public void itemUnrealized(String itemId) {
        OPCItem item = this.itemMap.get(itemId);
        if (item == null) {
            return;
        }
        item.itemUnrealized();
        if (!Boolean.getBoolean("org.openscada.da.server.opc.keepItems")) {
            this.unregisterItem(itemId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterItem(String itemId) {
        OPCItem item;
        logger.info("Unregistering item: {}", (Object)itemId);
        OPCItemManager oPCItemManager = this;
        synchronized (oPCItemManager) {
            item = this.itemMap.remove(itemId);
            if (item == null) {
                return;
            }
            this.setRegisteredItemCount(this.itemMap.size());
            this.hive.unregisterItem((DataItem)item);
        }
        item.itemUnrealized();
        this.allItemsStorage.removed(new ItemDescriptor((DataItem)item, null));
    }
}

