/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.connection;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.scada.utils.beans.AbstractPropertyChange;
import org.jinterop.dcom.core.JISession;
import org.openscada.da.server.opc.connection.data.ConnectionState;
import org.openscada.da.server.opc.connection.data.ControllerState;
import org.openscada.opc.dcom.common.impl.OPCCommon;
import org.openscada.opc.dcom.da.OPCSERVERSTATUS;
import org.openscada.opc.dcom.da.impl.OPCAsyncIO2;
import org.openscada.opc.dcom.da.impl.OPCGroupStateMgt;
import org.openscada.opc.dcom.da.impl.OPCItemMgt;
import org.openscada.opc.dcom.da.impl.OPCServer;
import org.openscada.opc.dcom.da.impl.OPCSyncIO;

public class OPCModel
extends AbstractPropertyChange {
    private boolean connectionRequested;
    private boolean connecting;
    private JISession session;
    private OPCServer server;
    private long lastConnect;
    private long reconnectDelay = 5000L;
    private OPCSERVERSTATUS serverState;
    private OPCGroupStateMgt group;
    private OPCItemMgt itemMgt;
    private OPCSyncIO syncIo;
    private OPCAsyncIO2 asyncIo2;
    private OPCCommon common;
    private Throwable lastConnectionError;
    private ConnectionState connectionState = ConnectionState.DISCONNECTED;
    private final Set<Thread> disposersRunning = new CopyOnWriteArraySet<Thread>();
    private ControllerState controllerState = ControllerState.IDLE;
    private long loopDelay = 250L;
    private long defaultTimeout = Long.getLong("rpc.socketTimeout", 5000L);
    private Long globalTimeout = null;
    private Long connectJobTimeout = null;
    private Long statusJobTimeout = null;
    private Long writeJobTimeout = null;
    private Long readJobTimeout = null;
    private int updateRate = 250;
    private boolean ignoreTimestampOnlyChange = false;
    private short qualityErrorIfLessThen = (short)192;

    public short getQualityErrorIfLessThen() {
        return this.qualityErrorIfLessThen;
    }

    public void setQualityErrorIfLessThen(short qualityErrorIfLessThen) {
        this.qualityErrorIfLessThen = qualityErrorIfLessThen;
    }

    public boolean isIgnoreTimestampOnlyChange() {
        return this.ignoreTimestampOnlyChange;
    }

    public void setIgnoreTimestampOnlyChange(boolean ignoreTimestampOnlyChange) {
        boolean oldIgnoreTimestampOnlyChange = this.ignoreTimestampOnlyChange;
        this.ignoreTimestampOnlyChange = ignoreTimestampOnlyChange;
        this.firePropertyChange("ignoreTimestampOnlyChange", oldIgnoreTimestampOnlyChange, ignoreTimestampOnlyChange);
    }

    public void setLastConnectNow() {
        this.setLastConnect(System.currentTimeMillis());
    }

    public void setLastConnect(long lastConnect) {
        long oldLastConnect = this.lastConnect;
        this.lastConnect = lastConnect;
        this.firePropertyChange("lastConnect", oldLastConnect, lastConnect);
    }

    public long getLastConnect() {
        return this.lastConnect;
    }

    public boolean mayConnect() {
        return System.currentTimeMillis() - this.lastConnect > this.reconnectDelay;
    }

    public boolean isConnected() {
        return this.session != null && this.server != null;
    }

    public JISession getSession() {
        return this.session;
    }

    public void setSession(JISession session) {
        JISession oldSession = this.session;
        boolean oldConnected = this.isConnected();
        this.session = session;
        this.firePropertyChange("session", oldSession, session);
        this.firePropertyChange("connected", oldConnected, this.isConnected());
    }

    public OPCServer getServer() {
        return this.server;
    }

    public void setServer(OPCServer server) {
        OPCServer oldServer = this.server;
        boolean oldConnected = this.isConnected();
        this.server = server;
        this.firePropertyChange("session", oldServer, this.session);
        this.firePropertyChange("connected", oldConnected, this.isConnected());
    }

    public boolean isConnectionRequested() {
        return this.connectionRequested;
    }

    public void setConnectionRequested(boolean connectionRequested) {
        this.connectionRequested = connectionRequested;
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    public void setConnecting(boolean connecting) {
        boolean oldConnecting = this.connecting;
        this.connecting = connecting;
        this.firePropertyChange("connecting", oldConnecting, connecting);
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public OPCSERVERSTATUS getServerState() {
        return this.serverState;
    }

    public void setServerState(OPCSERVERSTATUS serverState) {
        OPCSERVERSTATUS oldServerState = this.serverState;
        this.serverState = serverState;
        this.firePropertyChange("serverState", oldServerState, serverState);
    }

    public OPCGroupStateMgt getGroup() {
        return this.group;
    }

    public void setGroup(OPCGroupStateMgt group) {
        this.group = group;
    }

    public OPCItemMgt getItemMgt() {
        return this.itemMgt;
    }

    public void setItemMgt(OPCItemMgt itemMgt) {
        this.itemMgt = itemMgt;
    }

    public OPCSyncIO getSyncIo() {
        return this.syncIo;
    }

    public void setSyncIo(OPCSyncIO syncIo) {
        this.syncIo = syncIo;
    }

    public OPCCommon getCommon() {
        return this.common;
    }

    public void setCommon(OPCCommon common) {
        this.common = common;
    }

    public Throwable getLastConnectionError() {
        return this.lastConnectionError;
    }

    public void setLastConnectionError(Throwable lastConnectionError) {
        Throwable oldLastConnectionError = this.lastConnectionError;
        this.lastConnectionError = lastConnectionError;
        this.firePropertyChange("lastConnectionError", oldLastConnectionError, lastConnectionError);
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    public void setConnectionState(ConnectionState connectionState) {
        ConnectionState oldConnectionState = this.connectionState;
        this.connectionState = connectionState;
        this.firePropertyChange("connectionState", (Object)oldConnectionState, (Object)connectionState);
    }

    public long getNumDisposersRunning() {
        return this.disposersRunning.size();
    }

    public void addDisposerRunning(Thread disposer) {
        this.disposersRunning.add(disposer);
        long disposersRunning = this.disposersRunning.size();
        this.firePropertyChange("numDisposersRunning", null, disposersRunning);
    }

    public void removeDisposerRunning(Thread disposer) {
        this.disposersRunning.remove(disposer);
        long disposersRunning = this.disposersRunning.size();
        this.firePropertyChange("numDisposersRunning", null, disposersRunning);
    }

    public ControllerState getControllerState() {
        return this.controllerState;
    }

    public void setControllerState(ControllerState controllerState) {
        ControllerState oldControllerState = this.controllerState;
        this.controllerState = controllerState;
        this.firePropertyChange("controllerState", (Object)oldControllerState, (Object)controllerState);
    }

    public long getLoopDelay() {
        return this.loopDelay;
    }

    public void setLoopDelay(long loopDelay) {
        long oldLoopDelay = this.loopDelay;
        this.loopDelay = loopDelay;
        this.firePropertyChange("loopDelay", oldLoopDelay, loopDelay);
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public long getGlobalTimeout() {
        Long globalTimeout = this.globalTimeout;
        if (globalTimeout == null) {
            return this.defaultTimeout;
        }
        return globalTimeout;
    }

    public void setGlobalTimeout(Long globalTimeout) {
        this.globalTimeout = globalTimeout;
    }

    public int getUpdateRate() {
        return this.updateRate;
    }

    public void setUpdateRate(int updateRate) {
        int oldUpdateRate = this.updateRate;
        this.updateRate = updateRate;
        this.firePropertyChange("updateRate", oldUpdateRate, updateRate);
    }

    public long getConnectJobTimeout() {
        Long connectJobTimeout = this.connectJobTimeout;
        if (connectJobTimeout == null) {
            return this.defaultTimeout;
        }
        return connectJobTimeout;
    }

    public void setConnectJobTimeout(Long connectJobTimeout) {
        this.connectJobTimeout = connectJobTimeout;
    }

    public long getStatusJobTimeout() {
        Long statusJobTimeout = this.statusJobTimeout;
        if (statusJobTimeout == null) {
            return this.defaultTimeout;
        }
        return statusJobTimeout;
    }

    public void setStatusJobTimeout(Long statusJobTimeout) {
        this.statusJobTimeout = statusJobTimeout;
    }

    public long getReadJobTimeout() {
        Long readJobTimeout = this.readJobTimeout;
        if (readJobTimeout == null) {
            return this.defaultTimeout;
        }
        return readJobTimeout;
    }

    public void setReadJobTimeout(Long readJobTimeout) {
        this.readJobTimeout = readJobTimeout;
    }

    public long getWriteJobTimeout() {
        Long writeJobTimeout = this.writeJobTimeout;
        if (writeJobTimeout == null) {
            return this.defaultTimeout;
        }
        return writeJobTimeout;
    }

    public void setWriteJobTimeout(Long writeJobTimeout) {
        this.writeJobTimeout = writeJobTimeout;
    }

    public OPCAsyncIO2 getAsyncIo2() {
        return this.asyncIo2;
    }

    public void setAsyncIo2(OPCAsyncIO2 asyncIo2) {
        this.asyncIo2 = asyncIo2;
    }
}

