/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.connection;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.eclipse.scada.utils.concurrent.FutureTask;
import org.openscada.da.server.opc.connection.OPCController;
import org.openscada.da.server.opc.connection.OPCIoManager;
import org.openscada.da.server.opc.connection.OPCModel;
import org.openscada.da.server.opc.connection.OPCWriteRequest;
import org.openscada.da.server.opc.job.Job;
import org.openscada.da.server.opc.job.Worker;
import org.openscada.da.server.opc.job.impl.SyncReadJob;
import org.openscada.da.server.opc.job.impl.SyncWriteJob;
import org.openscada.opc.dcom.common.KeyedResult;
import org.openscada.opc.dcom.common.KeyedResultSet;
import org.openscada.opc.dcom.common.Result;
import org.openscada.opc.dcom.da.OPCDATASOURCE;
import org.openscada.opc.dcom.da.OPCITEMSTATE;
import org.openscada.opc.dcom.da.ValueData;
import org.openscada.opc.dcom.da.WriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OPCSyncIoManager
extends OPCIoManager {
    private static final Logger logger = LoggerFactory.getLogger(OPCSyncIoManager.class);

    public OPCSyncIoManager(Worker worker, OPCModel model, OPCController controller) {
        super(worker, model, controller);
    }

    @Override
    protected void performRead(Set<String> readSet, OPCDATASOURCE dataSource) throws InvocationTargetException {
        if (readSet.isEmpty()) {
            return;
        }
        HashSet<Integer> handles = new HashSet<Integer>();
        for (String itemId : readSet) {
            Integer handle = (Integer)this.serverHandleMap.get(itemId);
            if (handle == null) continue;
            handles.add(handle);
        }
        if (handles.isEmpty()) {
            return;
        }
        SyncReadJob job = new SyncReadJob(this.model.getReadJobTimeout(), this.model, dataSource, handles.toArray(new Integer[0]));
        KeyedResultSet<Integer, OPCITEMSTATE> result = this.worker.execute((Job)job, job);
        KeyedResultSet valueResult = new KeyedResultSet();
        for (KeyedResult entry : result) {
            OPCITEMSTATE state = (OPCITEMSTATE)entry.getValue();
            ValueData valueData = new ValueData();
            valueData.setQuality(state.getQuality());
            valueData.setTimestamp(state.getTimestamp().asCalendar());
            valueData.setValue(state.getValue());
            valueResult.add((Object)new KeyedResult((Object)((Integer)entry.getKey()), (Object)valueData, entry.getErrorCode()));
        }
        this.handleReadResult((KeyedResultSet<Integer, ValueData>)valueResult, true);
    }

    @Override
    protected FutureTask<Result<WriteRequest>> newWriteFuture(final OPCWriteRequest request) {
        return new FutureTask((Callable)new Callable<Result<WriteRequest>>(){

            @Override
            public Result<WriteRequest> call() throws Exception {
                return OPCSyncIoManager.this.performWriteRequest(request);
            }
        });
    }

    private Result<WriteRequest> performWriteRequest(OPCWriteRequest request) throws InvocationTargetException {
        Integer serverHandle = (Integer)this.serverHandleMap.get(request.getItemId());
        if (serverHandle == null) {
            throw new RuntimeException(String.format("Item '%s' is not realized.", request.getItemId()));
        }
        SyncWriteJob job = new SyncWriteJob(this.model.getWriteJobTimeout(), this.model, new WriteRequest[]{new WriteRequest(serverHandle.intValue(), request.getValue())});
        Result result = (Result)this.worker.execute((Job)job, job).get(0);
        if (result != null) {
            return result;
        }
        throw new RuntimeException("No connection to the OPC server");
    }

    @Override
    protected void performWriteRequests(Collection<FutureTask<Result<WriteRequest>>> requests) throws InvocationTargetException {
        for (FutureTask<Result<WriteRequest>> task : requests) {
            task.run();
            try {
                task.get();
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof InvocationTargetException)) continue;
                logger.warn("Re-throwing opc exception");
                throw (InvocationTargetException)e.getCause();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

