/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.connection;

import java.util.concurrent.Future;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.utils.concurrent.AbstractFuture;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.openscada.da.server.opc.connection.OPCItem;
import org.openscada.opc.dcom.common.Result;
import org.openscada.opc.dcom.da.WriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteFuture
extends AbstractFuture<WriteResult> {
    private static final Logger logger = LoggerFactory.getLogger(WriteFuture.class);
    private final NotifyFuture<Result<WriteRequest>> opcFuture;
    private final OPCItem opcItem;

    public WriteFuture(OPCItem opcItem, NotifyFuture<Result<WriteRequest>> opcFuture) {
        this.opcItem = opcItem;
        this.opcFuture = opcFuture;
        this.opcFuture.addListener((FutureListener)new FutureListener<Result<WriteRequest>>(){

            public void complete(Future<Result<WriteRequest>> future) {
                WriteFuture.this.handleComplete();
            }
        });
    }

    protected void handleComplete() {
        Result result;
        try {
            result = (Result)this.opcFuture.get();
            logger.info("Write returned");
            this.setResult(new WriteResult());
        }
        catch (Throwable e) {
            logger.info("Failed to write", e);
            this.opcItem.setLastWriteError(null);
            this.setError(new OperationException("Failed to write", e).fillInStackTrace());
            return;
        }
        if (result.isFailed()) {
            this.opcItem.setLastWriteError((Result<WriteRequest>)result);
            this.setError(new OperationException(String.format("Write returned with failure: 0x%08X", result.getErrorCode())).fillInStackTrace());
        }
    }
}

